"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PsModuleStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * AutomationStep implemenation for aws:psmodule
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-psModule
 */
class PsModuleStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS];
        this.action = 'aws:psModule';
        this.runCommand = props.runCommand;
        this.source = props.source;
        this.sourceHash = props.sourceHash;
        this.timeoutSeconds = props.timeoutSeconds;
        this.workingDirectory = props.workingDirectory;
    }
    /**
       * Inputs required for this command includes both the runCommand variables and workingDirectory if provided.
       */
    listInputs() {
        var _b, _c, _d, _e, _f, _g;
        return [
            ...(_c = (_b = this.runCommand) === null || _b === void 0 ? void 0 : _b.flatMap(v => v.requiredInputs())) !== null && _c !== void 0 ? _c : [],
            ...this.source.requiredInputs(),
            ...(_e = (_d = this.workingDirectory) === null || _d === void 0 ? void 0 : _d.requiredInputs()) !== null && _e !== void 0 ? _e : [],
            ...(_g = (_f = this.sourceHash) === null || _f === void 0 ? void 0 : _f.requiredInputs()) !== null && _g !== void 0 ? _g : [],
        ];
    }
    toSsmEntry() {
        const inputs = { source: this.source };
        if (this.workingDirectory != undefined) {
            inputs.workingDirectory = this.workingDirectory;
        }
        if (this.timeoutSeconds != undefined) {
            inputs.timeoutSeconds = this.timeoutSeconds;
        }
        if (this.sourceHash != undefined) {
            inputs.sourceHash = this.sourceHash;
        }
        if (this.runCommand != undefined) {
            inputs.runCommand = this.runCommand;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.PsModuleStep = PsModuleStep;
_a = JSII_RTTI_SYMBOL_1;
PsModuleStep[_a] = { fqn: "cdk-ssm-documents.PsModuleStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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