"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DownloadContentStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * AutomationStep implemenation for aws:downloadContent
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-downloadContent
 */
class DownloadContentStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX];
        this.action = 'aws:downloadContent';
        this.downloadableContent = props.downloadableContent;
        this.destinationPath = props.destinationPath;
    }
    /**
     * Inputs required for this command includes both the sourceType and sourceInfo variables and  destinationPath if provided.
     */
    listInputs() {
        var _b, _c;
        return [
            ...(_c = (_b = this.destinationPath) === null || _b === void 0 ? void 0 : _b.requiredInputs()) !== null && _c !== void 0 ? _c : [],
            ...this.downloadableContent.requiredInputs(),
        ];
    }
    toSsmEntry() {
        const inputs = {
            sourceType: this.downloadableContent.sourceType,
            sourceInfo: this.downloadableContent.formatSourceInfo(),
        };
        if (this.destinationPath != undefined) {
            inputs.destinationPath = this.destinationPath;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.DownloadContentStep = DownloadContentStep;
_a = JSII_RTTI_SYMBOL_1;
DownloadContentStep[_a] = { fqn: "cdk-ssm-documents.DownloadContentStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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