"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainJoinStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * CommandStep implemenation for aws:softwareInventory
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-domainJoin
 */
class DomainJoinStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX];
        this.action = 'aws:domainJoin';
        this.directoryId = props.directoryId;
        this.directoryName = props.directoryName;
        this.directoryOU = props.directoryOU;
        this.dnsIpAddresses = props.dnsIpAddresses;
    }
    /**
     * All Inputs for this command are optional.
     */
    listInputs() {
        const inputs = [
            this.directoryId,
            this.directoryName,
            this.directoryOU,
            this.dnsIpAddresses,
        ];
        return inputs.flatMap(i => { var _b; return (_b = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _b !== void 0 ? _b : []; });
    }
    toSsmEntry() {
        const inputs = {
            directoryId: this.directoryId,
            directoryName: this.directoryName,
            dnsIpAddresses: this.dnsIpAddresses,
        };
        if (this.directoryOU != undefined) {
            inputs.directoryOU = this.directoryOU;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.DomainJoinStep = DomainJoinStep;
_a = JSII_RTTI_SYMBOL_1;
DomainJoinStep[_a] = { fqn: "cdk-ssm-documents.DomainJoinStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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