"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigurePackageStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * CommandStep implemenation for aws:configurePackage
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-configurepackage
 */
class ConfigurePackageStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX];
        this.action = 'aws:configurePackage';
        this.packageName = props.packageName;
        this.packageAction = props.packageAction;
        this.installationType = props.installationType;
        this.additionalArguments = props.additionalArguments;
        this.version = props.version;
    }
    /**
     * Inputs required for this command include ...
     */
    listInputs() {
        const inputs = [
            this.packageName,
            this.packageAction,
            this.installationType,
            this.additionalArguments,
            this.version,
        ];
        return inputs.flatMap(i => { var _b; return (_b = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _b !== void 0 ? _b : []; });
    }
    toSsmEntry() {
        const inputs = { name: this.packageName };
        inputs.action = this.packageAction;
        if (this.installationType != undefined) {
            inputs.installationType = this.installationType;
        }
        if (this.additionalArguments != undefined) {
            inputs.additionalArguments = this.additionalArguments;
        }
        if (this.version != undefined) {
            inputs.version = this.version;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.ConfigurePackageStep = ConfigurePackageStep;
_a = JSII_RTTI_SYMBOL_1;
ConfigurePackageStep[_a] = { fqn: "cdk-ssm-documents.ConfigurePackageStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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