"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigureDockerStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * AutomationStep implemenation for aws:UpdateAgent
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-configuredocker
 */
class ConfigureDockerStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX];
        this.action = 'aws:configureDocker';
        this.installAction = props.action;
    }
    /**
     * Inputs required for this command include agentName allowDowngrade source and targetVersion if version other than latest is desired
     */
    listInputs() {
        const inputs = [
            this.installAction,
        ];
        return inputs.flatMap(i => { var _b; return (_b = i.requiredInputs()) !== null && _b !== void 0 ? _b : []; });
    }
    toSsmEntry() {
        const inputs = { action: this.installAction };
        return super.prepareSsmEntry(inputs);
    }
}
exports.ConfigureDockerStep = ConfigureDockerStep;
_a = JSII_RTTI_SYMBOL_1;
ConfigureDockerStep[_a] = { fqn: "cdk-ssm-documents.ConfigureDockerStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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