"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationsStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * CommandStep implemenation for aws:applications
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-applications
 */
class ApplicationsStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX];
        this.action = 'aws:applications';
        this.installAction = props.action;
        this.parameters = props.parameters;
        this.source = props.source;
        this.sourceHash = props.sourceHash;
    }
    listInputs() {
        const inputs = [
            this.installAction,
            this.parameters,
            this.source,
            this.sourceHash,
        ];
        return inputs.flatMap(i => { var _b; return (_b = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _b !== void 0 ? _b : []; });
    }
    toSsmEntry() {
        const inputs = {
            action: this.installAction,
            source: this.source,
        };
        if (this.parameters != undefined) {
            inputs.parameters = this.parameters;
        }
        if (this.sourceHash != undefined) {
            inputs.sourceHash = this.sourceHash;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.ApplicationsStep = ApplicationsStep;
_a = JSII_RTTI_SYMBOL_1;
ApplicationsStep[_a] = { fqn: "cdk-ssm-documents.ApplicationsStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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