"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommandStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const string_variable_1 = require("../interface/variables/string-variable");
const step_1 = require("./step");
class CommandStep extends step_1.Step {
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id, props);
        this.exitOnFailure = (_b = props.exitOnFailure) !== null && _b !== void 0 ? _b : false;
        this.exitOnSuccess = (_c = props.exitOnSuccess) !== null && _c !== void 0 ? _c : false;
        this.markSuccessAndExitOnFailure = (_d = props.markSuccessAndExitOnFailure) !== null && _d !== void 0 ? _d : false;
        this.finallyStep = (_e = props.finallyStep) !== null && _e !== void 0 ? _e : false;
        this.precondition = props.precondition;
    }
    addToDocument(doc) {
        doc.addStep(this);
    }
    prepareSsmEntry(inputs) {
        // Maps maintain insertion order
        const ssmDef = new Map();
        if (this.description) {
            ssmDef.set('description', this.description);
        }
        ssmDef.set('name', this.name);
        ssmDef.set('action', this.action);
        if (this.precondition) {
            ssmDef.set('precondition', this.precondition.asSsmEntry());
        }
        ssmDef.set('inputs', inputs);
        if (this.exitOnFailure) {
            ssmDef.set('onFailure', 'exit');
        }
        if (this.markSuccessAndExitOnFailure) {
            ssmDef.set('onFailure', 'successAndExit');
        }
        if (this.exitOnSuccess) {
            ssmDef.set('onSuccess', 'exit');
        }
        if (this.finallyStep) {
            ssmDef.set('finallyStep', this.finallyStep);
        }
        const ssmDict = {};
        ssmDef.forEach((value, key) => {
            ssmDict[key] = value;
        });
        return ssmDict;
    }
    /**
     * RunCommand Steps do not have outputs.
     * @returns []
     */
    listOutputs() {
        return [];
    }
    variables() {
        return Object.assign({}, ...this.listOutputs()
            .map(out => ({ [out.name]: new string_variable_1.StringVariable(`${this.name}.${out.name}`) })));
    }
}
exports.CommandStep = CommandStep;
_a = JSII_RTTI_SYMBOL_1;
CommandStep[_a] = { fqn: "cdk-ssm-documents.CommandStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tbWFuZC1zdGVwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3BhcmVudC1zdGVwcy9jb21tYW5kLXN0ZXAudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFNQSw0RUFBd0U7QUFDeEUsaUNBQXlDO0FBcUN6QyxNQUFzQixXQUFZLFNBQVEsV0FBSTtJQVc1QyxZQUFzQixLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUF1Qjs7UUFDekUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDeEIsSUFBSSxDQUFDLGFBQWEsU0FBRyxLQUFLLENBQUMsYUFBYSxtQ0FBSSxLQUFLLENBQUM7UUFDbEQsSUFBSSxDQUFDLGFBQWEsU0FBRyxLQUFLLENBQUMsYUFBYSxtQ0FBSSxLQUFLLENBQUM7UUFDbEQsSUFBSSxDQUFDLDJCQUEyQixTQUFHLEtBQUssQ0FBQywyQkFBMkIsbUNBQUksS0FBSyxDQUFDO1FBQzlFLElBQUksQ0FBQyxXQUFXLFNBQUcsS0FBSyxDQUFDLFdBQVcsbUNBQUksS0FBSyxDQUFDO1FBQzlDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztJQUN6QyxDQUFDO0lBRU0sYUFBYSxDQUFDLEdBQTJCO1FBQzlDLEdBQUcsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDcEIsQ0FBQztJQUVTLGVBQWUsQ0FBQyxNQUErQjtRQUN2RCxnQ0FBZ0M7UUFDaEMsTUFBTSxNQUFNLEdBQXFCLElBQUksR0FBRyxFQUFFLENBQUM7UUFDM0MsSUFBSSxJQUFJLENBQUMsV0FBVyxFQUFFO1lBQ3BCLE1BQU0sQ0FBQyxHQUFHLENBQUMsYUFBYSxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQztTQUM3QztRQUNELE1BQU0sQ0FBQyxHQUFHLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUM5QixNQUFNLENBQUMsR0FBRyxDQUFDLFFBQVEsRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDbEMsSUFBSSxJQUFJLENBQUMsWUFBWSxFQUFFO1lBQ3JCLE1BQU0sQ0FBQyxHQUFHLENBQUMsY0FBYyxFQUFFLElBQUksQ0FBQyxZQUFZLENBQUMsVUFBVSxFQUFFLENBQUMsQ0FBQztTQUM1RDtRQUNELE1BQU0sQ0FBQyxHQUFHLENBQUMsUUFBUSxFQUFFLE1BQU0sQ0FBQyxDQUFDO1FBRTdCLElBQUksSUFBSSxDQUFDLGFBQWEsRUFBRTtZQUN0QixNQUFNLENBQUMsR0FBRyxDQUFDLFdBQVcsRUFBRSxNQUFNLENBQUMsQ0FBQztTQUNqQztRQUNELElBQUksSUFBSSxDQUFDLDJCQUEyQixFQUFFO1lBQ3BDLE1BQU0sQ0FBQyxHQUFHLENBQUMsV0FBVyxFQUFFLGdCQUFnQixDQUFDLENBQUM7U0FDM0M7UUFDRCxJQUFJLElBQUksQ0FBQyxhQUFhLEVBQUU7WUFDdEIsTUFBTSxDQUFDLEdBQUcsQ0FBQyxXQUFXLEVBQUUsTUFBTSxDQUFDLENBQUM7U0FDakM7UUFDRCxJQUFJLElBQUksQ0FBQyxXQUFXLEVBQUU7WUFDcEIsTUFBTSxDQUFDLEdBQUcsQ0FBQyxhQUFhLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1NBQzdDO1FBQ0QsTUFBTSxPQUFPLEdBQTRCLEVBQUUsQ0FBQztRQUM1QyxNQUFNLENBQUMsT0FBTyxDQUFDLENBQUMsS0FBSyxFQUFFLEdBQUcsRUFBRSxFQUFFO1lBQzVCLE9BQU8sQ0FBQyxHQUFHLENBQUMsR0FBRyxLQUFLLENBQUM7UUFDdkIsQ0FBQyxDQUFDLENBQUM7UUFDSCxPQUFPLE9BQU8sQ0FBQztJQUNqQixDQUFDO0lBRUQ7OztPQUdHO0lBQ0ksV0FBVztRQUNoQixPQUFPLEVBQUUsQ0FBQztJQUNaLENBQUM7SUFFTSxTQUFTO1FBQ2QsT0FBTyxNQUFNLENBQUMsTUFBTSxDQUFDLEVBQUUsRUFBRSxHQUFHLElBQUksQ0FBQyxXQUFXLEVBQUU7YUFDM0MsR0FBRyxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksZ0NBQWMsQ0FBQyxHQUFHLElBQUksQ0FBQyxJQUFJLElBQUksR0FBRyxDQUFDLElBQUksRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNuRixDQUFDOztBQW5FSCxrQ0FxRUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IElDb21tYW5kQ29tcG9uZW50IH0gZnJvbSAnLi4vY29uc3RydWN0L2RvY3VtZW50LWNvbXBvbmVudCc7XG5pbXBvcnQgeyBDb21tYW5kRG9jdW1lbnRCdWlsZGVyIH0gZnJvbSAnLi4vZG9jdW1lbnQvZG9jdW1lbnQtYnVpbGRlcic7XG5pbXBvcnQgeyBPdXRwdXQgfSBmcm9tICcuLi9kb21haW4vb3V0cHV0JztcbmltcG9ydCB7IFBsYXRmb3JtIH0gZnJvbSAnLi4vZG9tYWluL3BsYXRmb3JtJztcbmltcG9ydCB7IFByZWNvbmRpdGlvbiB9IGZyb20gJy4uL2RvbWFpbi9wcmVjb25kaXRpb24nO1xuaW1wb3J0IHsgU3RyaW5nVmFyaWFibGUgfSBmcm9tICcuLi9pbnRlcmZhY2UvdmFyaWFibGVzL3N0cmluZy12YXJpYWJsZSc7XG5pbXBvcnQgeyBTdGVwLCBTdGVwUHJvcHMgfSBmcm9tICcuL3N0ZXAnO1xuXG5leHBvcnQgaW50ZXJmYWNlIENvbW1hbmRTdGVwUHJvcHMgZXh0ZW5kcyBTdGVwUHJvcHMge1xuXG4gIC8qKlxuICAgKiAoT3B0aW9uYWwpIFdoZXRoZXIgdG8gZXhpdCB0aGUgZG9jdW1lbnQgZXhlY3V0aW9uIGFmdGVyIGZhaWxlZCBleGVjdXRpb24gb2YgdGhpcyBzdGVwLlxuICAgKiBGaW5hbGx5IHN0ZXAgd2lsbCBiZSBydW4uXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBleGl0T25GYWlsdXJlPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogKE9wdGlvbmFsKSBXaGV0aGVyIHRvIGV4aXQgdGhlIGRvY3VtZW50IGV4ZWN1dGlvbiBhZnRlciBzdWNjZXNzZnVsIGV4ZWN1dGlvbiBvZiB0aGlzIHN0ZXAuXG4gICAqIEZpbmFsbHkgc3RlcCB3aWxsIGJlIHJ1bi5cbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGV4aXRPblN1Y2Nlc3M/OiBib29sZWFuO1xuXG4gIHJlYWRvbmx5IG1hcmtTdWNjZXNzQW5kRXhpdE9uRmFpbHVyZT86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIChPcHRpb25hbCkgU3RlcCB0byBqdW1wIHRvIGluIHRoZSBldmVudCB0aGF0IHRoaXMgc3RlcCBpcyBjYW5jZWxsZWQuXG4gICAqIEBkZWZhdWx0IHVuZGVmaW5lZFxuICAgKi9cbiAgcmVhZG9ubHkgb25DYW5jZWw/OiBTdGVwO1xuXG4gIHJlYWRvbmx5IGZpbmFsbHlTdGVwPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogKE9wdGlvbmFsKSBBIHByZWNvbmRpdGlvbiB0byB0ZXN0IGJlZm9yZSBleGVjdXRpb24gb2NjdXJycy5cbiAgICogV2hlbiB0aGUgcHJlY29uZGl0aW9uIGlzbid0IG1ldCwgdGhlIGNvbW1hbmQgc3RlcCBpc24ndCBleGVjdXRlZC5cbiAgICogQGRlZmF1bHQgdW5kZWZpbmVkXG4gICAqL1xuICByZWFkb25seSBwcmVjb25kaXRpb24/OiBQcmVjb25kaXRpb247XG5cbn1cblxuZXhwb3J0IGFic3RyYWN0IGNsYXNzIENvbW1hbmRTdGVwIGV4dGVuZHMgU3RlcCBpbXBsZW1lbnRzIElDb21tYW5kQ29tcG9uZW50IHtcblxuICBuZXh0U3RlcDogQ29tbWFuZFN0ZXAgfCB1bmRlZmluZWQ7XG4gIGFsbFN0ZXBzSW5FeGVjdXRpb246IENvbW1hbmRTdGVwW10gfCB1bmRlZmluZWQ7XG4gIHJlYWRvbmx5IGV4aXRPbkZhaWx1cmU6IGJvb2xlYW47XG4gIHJlYWRvbmx5IGV4aXRPblN1Y2Nlc3M6IGJvb2xlYW47XG4gIHJlYWRvbmx5IG1hcmtTdWNjZXNzQW5kRXhpdE9uRmFpbHVyZTogYm9vbGVhbjtcbiAgcmVhZG9ubHkgZmluYWxseVN0ZXA6IGJvb2xlYW47XG4gIHJlYWRvbmx5IHByZWNvbmRpdGlvbjogUHJlY29uZGl0aW9uIHwgdW5kZWZpbmVkO1xuICBhYnN0cmFjdCByZWFkb25seSBwbGF0Zm9ybXM6IFBsYXRmb3JtW107XG5cbiAgcHJvdGVjdGVkIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDb21tYW5kU3RlcFByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG4gICAgdGhpcy5leGl0T25GYWlsdXJlID0gcHJvcHMuZXhpdE9uRmFpbHVyZSA/PyBmYWxzZTtcbiAgICB0aGlzLmV4aXRPblN1Y2Nlc3MgPSBwcm9wcy5leGl0T25TdWNjZXNzID8/IGZhbHNlO1xuICAgIHRoaXMubWFya1N1Y2Nlc3NBbmRFeGl0T25GYWlsdXJlID0gcHJvcHMubWFya1N1Y2Nlc3NBbmRFeGl0T25GYWlsdXJlID8/IGZhbHNlO1xuICAgIHRoaXMuZmluYWxseVN0ZXAgPSBwcm9wcy5maW5hbGx5U3RlcCA/PyBmYWxzZTtcbiAgICB0aGlzLnByZWNvbmRpdGlvbiA9IHByb3BzLnByZWNvbmRpdGlvbjtcbiAgfVxuXG4gIHB1YmxpYyBhZGRUb0RvY3VtZW50KGRvYzogQ29tbWFuZERvY3VtZW50QnVpbGRlcik6IHZvaWQge1xuICAgIGRvYy5hZGRTdGVwKHRoaXMpO1xuICB9XG5cbiAgcHJvdGVjdGVkIHByZXBhcmVTc21FbnRyeShpbnB1dHM6IHsgW25hbWU6IHN0cmluZ106IGFueSB9KTogeyBbbmFtZTogc3RyaW5nXTogYW55IH0ge1xuICAgIC8vIE1hcHMgbWFpbnRhaW4gaW5zZXJ0aW9uIG9yZGVyXG4gICAgY29uc3Qgc3NtRGVmOiBNYXA8c3RyaW5nLCBhbnk+ID0gbmV3IE1hcCgpO1xuICAgIGlmICh0aGlzLmRlc2NyaXB0aW9uKSB7XG4gICAgICBzc21EZWYuc2V0KCdkZXNjcmlwdGlvbicsIHRoaXMuZGVzY3JpcHRpb24pO1xuICAgIH1cbiAgICBzc21EZWYuc2V0KCduYW1lJywgdGhpcy5uYW1lKTtcbiAgICBzc21EZWYuc2V0KCdhY3Rpb24nLCB0aGlzLmFjdGlvbik7XG4gICAgaWYgKHRoaXMucHJlY29uZGl0aW9uKSB7XG4gICAgICBzc21EZWYuc2V0KCdwcmVjb25kaXRpb24nLCB0aGlzLnByZWNvbmRpdGlvbi5hc1NzbUVudHJ5KCkpO1xuICAgIH1cbiAgICBzc21EZWYuc2V0KCdpbnB1dHMnLCBpbnB1dHMpO1xuXG4gICAgaWYgKHRoaXMuZXhpdE9uRmFpbHVyZSkge1xuICAgICAgc3NtRGVmLnNldCgnb25GYWlsdXJlJywgJ2V4aXQnKTtcbiAgICB9XG4gICAgaWYgKHRoaXMubWFya1N1Y2Nlc3NBbmRFeGl0T25GYWlsdXJlKSB7XG4gICAgICBzc21EZWYuc2V0KCdvbkZhaWx1cmUnLCAnc3VjY2Vzc0FuZEV4aXQnKTtcbiAgICB9XG4gICAgaWYgKHRoaXMuZXhpdE9uU3VjY2Vzcykge1xuICAgICAgc3NtRGVmLnNldCgnb25TdWNjZXNzJywgJ2V4aXQnKTtcbiAgICB9XG4gICAgaWYgKHRoaXMuZmluYWxseVN0ZXApIHtcbiAgICAgIHNzbURlZi5zZXQoJ2ZpbmFsbHlTdGVwJywgdGhpcy5maW5hbGx5U3RlcCk7XG4gICAgfVxuICAgIGNvbnN0IHNzbURpY3Q6IHsgW25hbWU6IHN0cmluZ106IGFueSB9ID0ge307XG4gICAgc3NtRGVmLmZvckVhY2goKHZhbHVlLCBrZXkpID0+IHtcbiAgICAgIHNzbURpY3Rba2V5XSA9IHZhbHVlO1xuICAgIH0pO1xuICAgIHJldHVybiBzc21EaWN0O1xuICB9XG5cbiAgLyoqXG4gICAqIFJ1bkNvbW1hbmQgU3RlcHMgZG8gbm90IGhhdmUgb3V0cHV0cy5cbiAgICogQHJldHVybnMgW11cbiAgICovXG4gIHB1YmxpYyBsaXN0T3V0cHV0cygpOiBPdXRwdXRbXSB7XG4gICAgcmV0dXJuIFtdO1xuICB9XG5cbiAgcHVibGljIHZhcmlhYmxlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIE9iamVjdC5hc3NpZ24oe30sIC4uLnRoaXMubGlzdE91dHB1dHMoKVxuICAgICAgLm1hcChvdXQgPT4gKHsgW291dC5uYW1lXTogbmV3IFN0cmluZ1ZhcmlhYmxlKGAke3RoaXMubmFtZX0uJHtvdXQubmFtZX1gKSB9KSkpO1xuICB9XG5cbn0iXX0=