"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunCommandStep = exports.DocumentHashTypeVariable = exports.HardCodedDocumentHashType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("../..");
const string_variable_1 = require("../../interface/variables/string-variable");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
class HardCodedDocumentHashType extends string_variable_1.HardCodedString {
    constructor(val) {
        super(val);
    }
}
exports.HardCodedDocumentHashType = HardCodedDocumentHashType;
_a = JSII_RTTI_SYMBOL_1;
HardCodedDocumentHashType[_a] = { fqn: "cdk-ssm-documents.HardCodedDocumentHashType", version: "0.0.12" };
HardCodedDocumentHashType.SHA256 = new HardCodedDocumentHashType('Sha256');
HardCodedDocumentHashType.SHA1 = new HardCodedDocumentHashType('Sha1');
class DocumentHashTypeVariable extends string_variable_1.StringVariable {
    constructor() {
        super(...arguments);
        this.validValues = ['Sha256', 'Sha1'];
    }
    assertType(value) {
        string_variable_1.assertString(value);
        if (!this.validValues.includes(value)) {
            throw new Error(`${value} is not a valid enum value`);
        }
    }
}
exports.DocumentHashTypeVariable = DocumentHashTypeVariable;
_b = JSII_RTTI_SYMBOL_1;
DocumentHashTypeVariable[_b] = { fqn: "cdk-ssm-documents.DocumentHashTypeVariable", version: "0.0.12" };
/**
 * AutomationStep implementation of [aws:runCommand](https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-runcommand.html)
 */
class RunCommandStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:runCommand';
        this.documentName = props.documentName;
        this.targets = props.targets;
        this.parameters = props.parameters;
        this.cloudWatchOutputConfig = props.cloudWatchOutputConfig;
        this.comment = props.comment;
        this.documentHash = props.documentHash;
        this.documentHashType = props.documentHashType;
        this.notificationConfig = props.notificationConfig;
        this.outputS3BucketName = props.outputS3BucketName;
        this.outputS3KeyPrefix = props.outputS3KeyPrefix;
        this.serviceRoleArn = props.serviceRoleArn;
        this.commandTimeoutSeconds = props.commandTimeoutSeconds;
        this.maxConcurrency = props.maxConcurrency;
        this.maxErrors = props.maxErrors;
    }
    listOutputs() {
        return [{
                outputType: __1.DataTypeEnum.STRING,
                selector: '$.CommandId',
                name: 'CommandId',
            }, {
                outputType: __1.DataTypeEnum.STRING,
                selector: '$.Status',
                name: 'Status',
            }, {
                outputType: __1.DataTypeEnum.INTEGER,
                selector: '$.ResponseCode',
                name: 'ResponseCode',
            }, {
                outputType: __1.DataTypeEnum.STRING,
                selector: '$.Output',
                name: 'Output',
            }];
    }
    listInputs() {
        const inputs = [
            this.documentName,
            this.targets,
            this.parameters,
            this.cloudWatchOutputConfig,
            this.comment,
            this.documentHash,
            this.documentHashType,
            this.notificationConfig,
            this.outputS3BucketName,
            this.outputS3KeyPrefix,
            this.serviceRoleArn,
            this.commandTimeoutSeconds,
            this.maxConcurrency,
            this.maxErrors,
        ];
        return inputs.flatMap(i => { var _d; return (_d = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _d !== void 0 ? _d : []; });
    }
    toSsmEntry() {
        var _d;
        const entryMap = {
            DocumentName: this.documentName,
            Parameters: this.parameters,
            CloudWatchOutputConfig: this.cloudWatchOutputConfig,
            Comment: this.comment,
            DocumentHash: this.documentHash,
            DocumentHashType: this.documentHashType,
            NotificationConfig: this.notificationConfig,
            OutputS3BucketName: this.outputS3BucketName,
            OutputS3KeyPrefix: this.outputS3KeyPrefix,
            ServiceRoleArn: this.serviceRoleArn,
            TimeoutSeconds: this.commandTimeoutSeconds,
            MaxConcurrency: this.maxConcurrency,
            MaxErrors: this.maxErrors,
        };
        if ((_d = this.targets) === null || _d === void 0 ? void 0 : _d.resolveToStringList) {
            entryMap.InstanceIds = this.targets;
        }
        else {
            entryMap.Targets = this.targets;
        }
        return super.prepareSsmEntry(prune_and_transform_record_1.pruneAndTransformRecord(entryMap, x => x.print()));
    }
}
exports.RunCommandStep = RunCommandStep;
_c = JSII_RTTI_SYMBOL_1;
RunCommandStep[_c] = { fqn: "cdk-ssm-documents.RunCommandStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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