"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeWebhookStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const data_type_1 = require("../../domain/data-type");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implementation for [aws:invokeWebhook](https://docs.aws.amazon.com/systems-manager/latest/userguide/invoke-webhook.html)
 */
class InvokeWebhookStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:invokeWebhook';
        this.integrationName = props.integrationName;
        this.body = props.body;
    }
    listOutputs() {
        return [{
                outputType: data_type_1.DataTypeEnum.STRING,
                selector: '$.Response',
                name: 'Response',
            }, {
                outputType: data_type_1.DataTypeEnum.INTEGER,
                selector: '$.ResponseCode',
                name: 'ResponseCode',
            }];
    }
    listInputs() {
        const inputs = [
            this.integrationName,
            this.body,
        ];
        return inputs.flatMap(i => { var _b; return (_b = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _b !== void 0 ? _b : []; });
    }
    toSsmEntry() {
        return super.prepareSsmEntry(prune_and_transform_record_1.pruneAndTransformRecord({
            IntegrationName: this.integrationName,
            Body: this.body,
        }, x => x.print()));
    }
}
exports.InvokeWebhookStep = InvokeWebhookStep;
_a = JSII_RTTI_SYMBOL_1;
InvokeWebhookStep[_a] = { fqn: "cdk-ssm-documents.InvokeWebhookStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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