"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeLambdaFunctionStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const data_type_1 = require("../../domain/data-type");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implemenation for aws:invokeLambdaFunction
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-lamb.html
 */
class InvokeLambdaFunctionStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:invokeLambdaFunction';
        this.functionName = props.functionName;
        this.qualifier = props.qualifier;
        this.invocationType = props.invocationType;
        this.logType = props.logType;
        this.clientContext = props.clientContext;
        this.payload = props.payload;
    }
    listOutputs() {
        return [{
                outputType: data_type_1.DataTypeEnum.INTEGER,
                name: 'StatusCode',
                selector: '$.StatusCode',
            }, {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'FunctionError',
                selector: '$.FunctionError',
            }, {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'LogResult',
                selector: '$.LogResult',
            }, {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'Payload',
                selector: '$.Payload',
            }];
    }
    listInputs() {
        const inputs = [
            this.functionName,
            this.qualifier,
            this.invocationType,
            this.logType,
            this.clientContext,
            this.payload,
        ];
        return inputs.flatMap(i => { var _b; return (_b = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _b !== void 0 ? _b : []; });
    }
    toSsmEntry() {
        const entryMap = this.formatInputMap();
        const entries = prune_and_transform_record_1.pruneAndTransformRecord(entryMap, x => x.print());
        return super.prepareSsmEntry(entries);
    }
    formatInputMap() {
        return {
            FunctionName: this.functionName,
            Qualifier: this.qualifier,
            InvocationType: this.invocationType,
            LogType: this.logType,
            ClientContext: this.clientContext,
            Payload: this.payload,
        };
    }
}
exports.InvokeLambdaFunctionStep = InvokeLambdaFunctionStep;
_a = JSII_RTTI_SYMBOL_1;
InvokeLambdaFunctionStep[_a] = { fqn: "cdk-ssm-documents.InvokeLambdaFunctionStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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