"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExecuteStateMachineStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implementation of [aws:executeStateMachine](https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-executeStateMachine.html)
 */
class ExecuteStateMachineStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:executeStateMachine';
        this.stateMachineArn = props.stateMachineArn;
        this.executionName = props.executionName;
        this.input = props.input;
    }
    /**
       * No outputs emitted from Delete Stack step
       * @returns []
       */
    listOutputs() {
        return [];
    }
    listInputs() {
        const inputs = [
            this.stateMachineArn,
            this.executionName,
            this.input,
        ];
        return inputs.flatMap(i => { var _b; return (_b = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _b !== void 0 ? _b : []; });
    }
    toSsmEntry() {
        return this.prepareSsmEntry(prune_and_transform_record_1.pruneAndTransformRecord({
            stateMachineArn: this.stateMachineArn,
            name: this.executionName,
            input: this.input,
        }, x => x.print()));
    }
}
exports.ExecuteStateMachineStep = ExecuteStateMachineStep;
_a = JSII_RTTI_SYMBOL_1;
ExecuteStateMachineStep[_a] = { fqn: "cdk-ssm-documents.ExecuteStateMachineStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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