"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExecuteAutomationStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const data_type_1 = require("../../domain/data-type");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implementation for aws:executeAutomation
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-executeAutomation.html
 */
class ExecuteAutomationStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:executeAutomation';
        this.documentName = props.documentName;
        this.documentVersion = props.documentVersion;
        this.maxConcurrency = props.maxConcurrency;
        this.maxErrors = props.maxErrors;
        this.runtimeParameters = props.runtimeParameters;
        this.tags = props.tags;
        this.targetLocations = props.targetLocations;
        this.targetMaps = props.targetMaps;
        this.targetParameterName = props.targetParameterName;
        this.targets = props.targets;
    }
    listInputs() {
        const inputs = [
            this.documentName,
            this.documentVersion,
            this.maxConcurrency,
            this.maxErrors,
            this.runtimeParameters,
            this.tags,
            this.targetLocations,
            this.targetMaps,
            this.targetParameterName,
            this.targets,
        ];
        return inputs.flatMap(i => { var _b; return (_b = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _b !== void 0 ? _b : []; });
    }
    listOutputs() {
        return [{
                outputType: data_type_1.DataTypeEnum.STRING_LIST,
                name: 'Output',
                selector: '$.Outputs',
            },
            {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'ExecutionId',
                selector: '$.ExecutionId',
            },
            {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'Status',
                selector: '$.Status',
            }];
    }
    toSsmEntry() {
        const inputs = {
            DocumentName: this.documentName,
        };
        if (this.documentVersion != undefined) {
            inputs.DocumentVersion = this.documentVersion;
        }
        if (this.maxConcurrency != undefined) {
            inputs.MaxConcurrency = this.maxConcurrency;
        }
        if (this.maxErrors != undefined) {
            inputs.MaxErrors = this.maxErrors;
        }
        if (this.runtimeParameters != undefined) {
            inputs.RuntimeParameters = this.runtimeParameters;
        }
        if (this.tags != undefined) {
            inputs.Tags = this.tags;
        }
        if (this.targetLocations != undefined) {
            inputs.TargetLocations = this.targetLocations;
        }
        if (this.targetMaps != undefined) {
            inputs.TargetMaps = this.targetMaps;
        }
        if (this.targetParameterName != undefined) {
            inputs.TargetParameterName = this.targetParameterName;
        }
        if (this.targets != undefined) {
            inputs.Targets = this.targets;
        }
        const entireEntry = super.prepareSsmEntry(inputs);
        const { outputs, ...newObj } = entireEntry;
        return newObj;
    }
}
exports.ExecuteAutomationStep = ExecuteAutomationStep;
_a = JSII_RTTI_SYMBOL_1;
ExecuteAutomationStep[_a] = { fqn: "cdk-ssm-documents.ExecuteAutomationStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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