import { Construct } from 'constructs';
import { Output } from '../../domain/output';
import { IMapListVariable } from '../../interface/variables/map-list-variable';
import { IStringMapVariable } from '../../interface/variables/string-map-variable';
import { IStringVariable } from '../../interface/variables/string-variable';
import { AutomationStep, AutomationStepProps } from '../automation-step';
export interface ExecuteAutomationStepProps extends AutomationStepProps {
    readonly documentName: IStringVariable;
    readonly documentVersion?: IStringVariable;
    readonly maxConcurrency?: IStringVariable;
    readonly maxErrors?: IStringVariable;
    readonly runtimeParameters?: IStringMapVariable;
    readonly tags?: IMapListVariable;
    readonly targetLocations?: IMapListVariable;
    readonly targetMaps?: IMapListVariable;
    readonly targetParameterName?: IStringVariable;
    readonly targets?: IMapListVariable;
}
/**
 * AutomationStep implementation for aws:executeAutomation
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-executeAutomation.html
 */
export declare class ExecuteAutomationStep extends AutomationStep {
    readonly documentName: IStringVariable;
    readonly documentVersion?: IStringVariable;
    readonly maxConcurrency?: IStringVariable;
    readonly maxErrors?: IStringVariable;
    readonly runtimeParameters?: IStringMapVariable;
    readonly tags?: IMapListVariable;
    readonly targetLocations?: IMapListVariable;
    readonly targetMaps?: IMapListVariable;
    readonly targetParameterName?: IStringVariable;
    readonly targets?: IMapListVariable;
    readonly action = "aws:executeAutomation";
    constructor(scope: Construct, id: string, props: ExecuteAutomationStepProps);
    listInputs(): string[];
    listOutputs(): Output[];
    toSsmEntry(): {
        [name: string]: any;
    };
}
