"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateTagsStep = exports.ResourceTypeVariable = exports.HardCodedResourceType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const string_variable_1 = require("../../interface/variables/string-variable");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
class HardCodedResourceType extends string_variable_1.HardCodedString {
    constructor(val) {
        super(val);
    }
}
exports.HardCodedResourceType = HardCodedResourceType;
_a = JSII_RTTI_SYMBOL_1;
HardCodedResourceType[_a] = { fqn: "cdk-ssm-documents.HardCodedResourceType", version: "0.0.12" };
HardCodedResourceType.EC2 = new HardCodedResourceType('EC2');
HardCodedResourceType.MANAGED_INSTANCE = new HardCodedResourceType('ManagedInstance');
HardCodedResourceType.MAINTENANCE_WINDOW = new HardCodedResourceType('MaintenanceWindow');
HardCodedResourceType.PARAMETER = new HardCodedResourceType('Parameter');
class ResourceTypeVariable extends string_variable_1.StringVariable {
    constructor() {
        super(...arguments);
        this.validValues = ['EC2', 'ManagedInstance', 'MaintenanceWindow', 'Parameter'];
    }
    assertType(value) {
        string_variable_1.assertString(value);
        if (!this.validValues.includes(value)) {
            throw new Error(`${value} is not a valid enum value`);
        }
    }
}
exports.ResourceTypeVariable = ResourceTypeVariable;
_b = JSII_RTTI_SYMBOL_1;
ResourceTypeVariable[_b] = { fqn: "cdk-ssm-documents.ResourceTypeVariable", version: "0.0.12" };
/**
 * AutomationStep implemenation for aws:createTags
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-createtag.html
 */
class CreateTagsStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:createTags';
        this.resourceIds = props.resourceIds;
        this.tags = props.tags;
        this.resourceType = props.resourceType;
    }
    /**
       * This step has no outputs.
       */
    listOutputs() {
        return [];
    }
    listInputs() {
        const inputs = [
            this.resourceIds,
            this.tags,
            this.resourceType,
        ];
        return inputs.flatMap(i => { var _d; return (_d = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _d !== void 0 ? _d : []; });
    }
    toSsmEntry() {
        const entryMap = {
            ResourceIds: this.resourceIds,
            Tags: this.tags,
            ResourceType: this.resourceType,
        };
        const entries = prune_and_transform_record_1.pruneAndTransformRecord(entryMap, x => x.print());
        return super.prepareSsmEntry(entries);
    }
}
exports.CreateTagsStep = CreateTagsStep;
_c = JSII_RTTI_SYMBOL_1;
CreateTagsStep[_c] = { fqn: "cdk-ssm-documents.CreateTagsStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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