"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateStackStep = exports.OnFailureVariable = exports.HardCodedOnFailure = exports.BodyOrUrlType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const data_type_1 = require("../../domain/data-type");
const string_variable_1 = require("../../interface/variables/string-variable");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
var BodyOrUrlType;
(function (BodyOrUrlType) {
    BodyOrUrlType[BodyOrUrlType["BODY"] = 0] = "BODY";
    BodyOrUrlType[BodyOrUrlType["URL"] = 1] = "URL";
})(BodyOrUrlType = exports.BodyOrUrlType || (exports.BodyOrUrlType = {}));
class HardCodedOnFailure extends string_variable_1.HardCodedString {
    constructor(val) {
        super(val);
    }
}
exports.HardCodedOnFailure = HardCodedOnFailure;
_a = JSII_RTTI_SYMBOL_1;
HardCodedOnFailure[_a] = { fqn: "cdk-ssm-documents.HardCodedOnFailure", version: "0.0.12" };
HardCodedOnFailure.DO_NOTHING = new HardCodedOnFailure('DO_NOTHING');
HardCodedOnFailure.ROLLBACK = new HardCodedOnFailure('ROLLBACK');
HardCodedOnFailure.DELETE = new HardCodedOnFailure('DELETE');
class OnFailureVariable extends string_variable_1.StringVariable {
    constructor() {
        super(...arguments);
        this.validValues = ['DO_NOTHING', 'ROLLBACK', 'DELETE'];
    }
    assertType(value) {
        string_variable_1.assertString(value);
        if (!this.validValues.includes(value)) {
            throw new Error(`${value} is not a valid enum value`);
        }
    }
}
exports.OnFailureVariable = OnFailureVariable;
_b = JSII_RTTI_SYMBOL_1;
OnFailureVariable[_b] = { fqn: "cdk-ssm-documents.OnFailureVariable", version: "0.0.12" };
/**
 * AutomationStep implementation for aws:createStack
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-createstack.html
 */
class CreateStackStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        var _d, _e;
        super(scope, id, props);
        this.action = 'aws:createStack';
        this.stackName = props.stackName;
        this.capabilities = props.capabilities;
        this.clientRequestToken = props.clientRequestToken;
        this.onStackFailure = props.onStackFailure;
        this.notificationARNs = props.notificationARNs;
        this.parameters = props.parameters;
        this.resourceTypes = props.resourceTypes;
        this.roleArn = props.roleArn;
        if (((_d = props.stackPolicy) === null || _d === void 0 ? void 0 : _d.propType) === BodyOrUrlType.BODY) {
            this.stackPolicyBody = props.stackPolicy.value;
        }
        else {
            this.stackPolicyUrl = (_e = props.stackPolicy) === null || _e === void 0 ? void 0 : _e.value;
        }
        this.tags = props.tags;
        if (props.template.propType === BodyOrUrlType.BODY) {
            this.templateBody = props.template.value;
        }
        else {
            this.templateUrl = props.template.value;
        }
        this.timeoutInMinutes = props.timeoutInMinutes;
    }
    listOutputs() {
        return [{
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'StackId',
                selector: '$.StackId',
            }, {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'StackStatus',
                selector: '$.StackStatus',
            }, {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'StackStatusReason',
                selector: '$.StackStatusReason',
            }];
    }
    listInputs() {
        const inputs = [
            this.stackName,
            this.capabilities,
            this.clientRequestToken,
            this.notificationARNs,
            this.onStackFailure,
            this.parameters,
            this.resourceTypes,
            this.roleArn,
            this.stackPolicyBody,
            this.stackPolicyUrl,
            this.tags,
            this.templateBody,
            this.templateUrl,
            this.timeoutInMinutes,
        ];
        return inputs.flatMap(i => { var _d; return (_d = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _d !== void 0 ? _d : []; });
    }
    toSsmEntry() {
        return super.prepareSsmEntry(prune_and_transform_record_1.pruneAndTransformRecord({
            StackName: this.stackName,
            Capabilities: this.capabilities,
            ClientRequestToken: this.clientRequestToken,
            NotificationARNs: this.notificationARNs,
            OnFailure: this.onStackFailure,
            Parameters: this.parameters,
            ResourceTypes: this.resourceTypes,
            RoleARN: this.roleArn,
            StackPolicyBody: this.stackPolicyBody,
            StackPolicyURL: this.stackPolicyUrl,
            Tags: this.tags,
            TemplateBody: this.templateBody,
            TemplateURL: this.templateUrl,
            TimeoutInMinutes: this.timeoutInMinutes,
        }, x => x.print()));
    }
}
exports.CreateStackStep = CreateStackStep;
_c = JSII_RTTI_SYMBOL_1;
CreateStackStep[_c] = { fqn: "cdk-ssm-documents.CreateStackStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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