"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateImageStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const data_type_1 = require("../../domain/data-type");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implemenation for aws:createImage
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-create.html
 */
class CreateImageStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:createImage';
        this.instanceId = props.instanceId;
        this.imageName = props.imageName;
        this.imageDescription = props.imageDescription;
        this.noReboot = props.noReboot;
        this.blockDeviceMappings = props.blockDeviceMappings;
    }
    listOutputs() {
        return [{
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'ImageId',
                selector: '$.ImageId',
            }, {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'ImageState',
                selector: '$.ImageState',
            }];
    }
    listInputs() {
        const inputs = [
            this.instanceId,
            this.imageName,
            this.imageDescription,
            this.noReboot,
            this.blockDeviceMappings,
        ];
        return inputs.flatMap(i => { var _b; return (_b = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _b !== void 0 ? _b : []; });
    }
    toSsmEntry() {
        const entryMap = {
            InstanceId: this.instanceId,
            ImageName: this.imageName,
            ImageDescription: this.imageDescription,
            NoReboot: this.noReboot,
            BlockDeviceMappings: this.blockDeviceMappings,
        };
        const entries = prune_and_transform_record_1.pruneAndTransformRecord(entryMap, x => x.print());
        return super.prepareSsmEntry(entries);
    }
}
exports.CreateImageStep = CreateImageStep;
_a = JSII_RTTI_SYMBOL_1;
CreateImageStep[_a] = { fqn: "cdk-ssm-documents.CreateImageStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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