import { Construct } from 'constructs';
import { Output } from '../../domain/output';
import { IBooleanVariable } from '../../interface/variables/boolean-variable';
import { IStringMapVariable } from '../../interface/variables/string-map-variable';
import { IStringVariable } from '../../interface/variables/string-variable';
import { AutomationStep, AutomationStepProps } from '../automation-step';
/**
 * Properties for CreateImageStep
 */
export interface CreateImageStepProps extends AutomationStepProps {
    /**
     * The ID of the instance.
     */
    readonly instanceId: IStringVariable;
    /**
     * The name for the image.
     */
    readonly imageName: IStringVariable;
    /**
     * (Optional) A description of the image.
     */
    readonly imageDescription?: IStringVariable;
    /**
     * (Optional) By default, Amazon Elastic Compute Cloud (Amazon EC2) attempts to shut down and reboot the instance before creating the image. If the No Reboot option is set to true, Amazon EC2 doesn't shut down the instance before creating the image. When this option is used, file system integrity on the created image can't be guaranteed.
     * If you don't want the instance to run after you create an AMI from it, first use the aws:changeInstanceState – Change or assert instance state action to stop the instance, and then use this aws:createImage action with the NoReboot option set to true.
     */
    readonly noReboot?: IBooleanVariable;
    /**
     * (Optional) The block devices for the instance.
     */
    readonly blockDeviceMappings?: IStringMapVariable;
}
/**
 * AutomationStep implemenation for aws:createImage
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-create.html
 */
export declare class CreateImageStep extends AutomationStep {
    readonly action: string;
    readonly instanceId: IStringVariable;
    readonly imageName: IStringVariable;
    readonly imageDescription?: IStringVariable;
    readonly noReboot?: IBooleanVariable;
    readonly blockDeviceMappings?: IStringMapVariable;
    constructor(scope: Construct, id: string, props: CreateImageStepProps);
    listOutputs(): Output[];
    listInputs(): string[];
    toSsmEntry(): Record<string, any>;
}
