"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CopyImageStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const data_type_1 = require("../../domain/data-type");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implemenation for aws:copyImage
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-copyimage.html
 */
class CopyImageStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:copyImage';
        this.sourceRegion = props.sourceRegion;
        this.sourceImageId = props.sourceImageId;
        this.imageName = props.imageName;
        this.imageDescription = props.imageDescription;
        this.encrypted = props.encrypted;
        this.kmsKeyId = props.kmsKeyId;
        this.clientToken = props.clientToken;
    }
    listOutputs() {
        return [{
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'ImageId',
                selector: '$.ImageId',
            }, {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'ImageState',
                selector: '$.ImageState',
            }];
    }
    listInputs() {
        const inputs = [
            this.sourceRegion,
            this.sourceImageId,
            this.imageName,
            this.imageDescription,
            this.encrypted,
            this.kmsKeyId,
            this.clientToken,
        ];
        return inputs.flatMap(i => { var _b; return (_b = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _b !== void 0 ? _b : []; });
    }
    toSsmEntry() {
        const entryMap = {
            SourceRegion: this.sourceRegion,
            SourceImageId: this.sourceImageId,
            ImageName: this.imageName,
            ImageDescription: this.imageDescription,
            Encrypted: this.encrypted,
            KmsKeyId: this.kmsKeyId,
            ClientToken: this.clientToken,
        };
        const entries = prune_and_transform_record_1.pruneAndTransformRecord(entryMap, x => x.print());
        return super.prepareSsmEntry(entries);
    }
}
exports.CopyImageStep = CopyImageStep;
_a = JSII_RTTI_SYMBOL_1;
CopyImageStep[_a] = { fqn: "cdk-ssm-documents.CopyImageStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29weS1pbWFnZS1zdGVwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3BhcmVudC1zdGVwcy9hdXRvbWF0aW9uL2NvcHktaW1hZ2Utc3RlcC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLHNEQUFzRDtBQUt0RCx1RkFBaUY7QUFDakYsd0RBQXlFO0FBMkN6RTs7O0dBR0c7QUFDSCxNQUFhLGFBQWMsU0FBUSxnQ0FBYztJQVUvQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXlCO1FBQ2pFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBVmpCLFdBQU0sR0FBVyxlQUFlLENBQUM7UUFXeEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLGFBQWEsQ0FBQztRQUN6QyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztRQUMvQyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQy9CLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztJQUN2QyxDQUFDO0lBRU0sV0FBVztRQUNoQixPQUFPLENBQUM7Z0JBQ04sVUFBVSxFQUFFLHdCQUFZLENBQUMsTUFBTTtnQkFDL0IsSUFBSSxFQUFFLFNBQVM7Z0JBQ2YsUUFBUSxFQUFFLFdBQVc7YUFDdEIsRUFBRTtnQkFDRCxVQUFVLEVBQUUsd0JBQVksQ0FBQyxNQUFNO2dCQUMvQixJQUFJLEVBQUUsWUFBWTtnQkFDbEIsUUFBUSxFQUFFLGNBQWM7YUFDekIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVNLFVBQVU7UUFDZixNQUFNLE1BQU0sR0FBRztZQUNiLElBQUksQ0FBQyxZQUFZO1lBQ2pCLElBQUksQ0FBQyxhQUFhO1lBQ2xCLElBQUksQ0FBQyxTQUFTO1lBQ2QsSUFBSSxDQUFDLGdCQUFnQjtZQUNyQixJQUFJLENBQUMsU0FBUztZQUNkLElBQUksQ0FBQyxRQUFRO1lBQ2IsSUFBSSxDQUFDLFdBQVc7U0FDakIsQ0FBQztRQUVGLE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSx3QkFBQyxDQUFDLGFBQUQsQ0FBQyx1QkFBRCxDQUFDLENBQUUsY0FBYyxxQ0FBTSxFQUFFLEdBQUEsQ0FBQyxDQUFDO0lBQ3hELENBQUM7SUFFTSxVQUFVO1FBQ2YsTUFBTSxRQUFRLEdBQWlEO1lBQzdELFlBQVksRUFBRSxJQUFJLENBQUMsWUFBWTtZQUMvQixhQUFhLEVBQUUsSUFBSSxDQUFDLGFBQWE7WUFDakMsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLGdCQUFnQixFQUFFLElBQUksQ0FBQyxnQkFBZ0I7WUFDdkMsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7U0FDOUIsQ0FBQztRQUNGLE1BQU0sT0FBTyxHQUFHLG9EQUF1QixDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDO1FBQ2xFLE9BQU8sS0FBSyxDQUFDLGVBQWUsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUN4QyxDQUFDOztBQTNESCxzQ0E0REMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IERhdGFUeXBlRW51bSB9IGZyb20gJy4uLy4uL2RvbWFpbi9kYXRhLXR5cGUnO1xuaW1wb3J0IHsgT3V0cHV0IH0gZnJvbSAnLi4vLi4vZG9tYWluL291dHB1dCc7XG5pbXBvcnQgeyBJQm9vbGVhblZhcmlhYmxlIH0gZnJvbSAnLi4vLi4vaW50ZXJmYWNlL3ZhcmlhYmxlcy9ib29sZWFuLXZhcmlhYmxlJztcbmltcG9ydCB7IElTdHJpbmdWYXJpYWJsZSB9IGZyb20gJy4uLy4uL2ludGVyZmFjZS92YXJpYWJsZXMvc3RyaW5nLXZhcmlhYmxlJztcbmltcG9ydCB7IElHZW5lcmljVmFyaWFibGUgfSBmcm9tICcuLi8uLi9pbnRlcmZhY2UvdmFyaWFibGVzL3ZhcmlhYmxlJztcbmltcG9ydCB7IHBydW5lQW5kVHJhbnNmb3JtUmVjb3JkIH0gZnJvbSAnLi4vLi4vdXRpbHMvcHJ1bmUtYW5kLXRyYW5zZm9ybS1yZWNvcmQnO1xuaW1wb3J0IHsgQXV0b21hdGlvblN0ZXAsIEF1dG9tYXRpb25TdGVwUHJvcHMgfSBmcm9tICcuLi9hdXRvbWF0aW9uLXN0ZXAnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIENvcHlJbWFnZVN0ZXBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDb3B5SW1hZ2VTdGVwUHJvcHMgZXh0ZW5kcyBBdXRvbWF0aW9uU3RlcFByb3BzIHtcblxuICAvKipcbiAgICAgKiBUaGUgcmVnaW9uIHdoZXJlIHRoZSBzb3VyY2UgQU1JIGV4aXN0cy5cbiAgICAgKi9cbiAgcmVhZG9ubHkgc291cmNlUmVnaW9uOiBJU3RyaW5nVmFyaWFibGU7XG5cbiAgLyoqXG4gICAgICogVGhlIEFNSSBJRCB0byBjb3B5IGZyb20gdGhlIHNvdXJjZSBSZWdpb24uXG4gICAgICovXG4gIHJlYWRvbmx5IHNvdXJjZUltYWdlSWQ6IElTdHJpbmdWYXJpYWJsZTtcblxuICAvKipcbiAgICAgKiBUaGUgbmFtZSBmb3IgdGhlIGltYWdlLlxuICAgICAqL1xuICByZWFkb25seSBpbWFnZU5hbWU6IElTdHJpbmdWYXJpYWJsZTtcblxuICAvKipcbiAgICAgKiAoT3B0aW9uYWwpIEEgZGVzY3JpcHRpb24gb2YgdGhlIGltYWdlLlxuICAgICAqL1xuICByZWFkb25seSBpbWFnZURlc2NyaXB0aW9uPzogSVN0cmluZ1ZhcmlhYmxlO1xuXG4gIC8qKlxuICAgICAqIChPcHRpb25hbCkgRW5jcnlwdCB0aGUgdGFyZ2V0IEFNSS5cbiAgICAgKi9cbiAgcmVhZG9ubHkgZW5jcnlwdGVkPzogSUJvb2xlYW5WYXJpYWJsZTtcblxuICAvKipcbiAgICAgKiAoT3B0aW9uYWwpIFRoZSBmdWxsIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIG9mIHRoZSBBV1MgS01TIGtleSB0byB1c2Ugd2hlbiBlbmNyeXB0aW5nIHRoZSBzbmFwc2hvdHMgb2YgYW4gaW1hZ2UgZHVyaW5nIGEgY29weSBvcGVyYXRpb24uXG4gICAgICovXG4gIHJlYWRvbmx5IGttc0tleUlkPzogSVN0cmluZ1ZhcmlhYmxlO1xuXG4gIC8qKlxuICAgICAqIChPcHRpb25hbCkgQSB1bmlxdWUsIGNhc2Utc2Vuc2l0aXZlIGlkZW50aWZpZXIgdGhhdCB5b3UgcHJvdmlkZSB0byBlbnN1cmUgcmVxdWVzdCBpZGVtcG90ZW5jeS5cbiAgICAgKi9cbiAgcmVhZG9ubHkgY2xpZW50VG9rZW4/OiBJU3RyaW5nVmFyaWFibGU7XG59XG5cbi8qKlxuICogQXV0b21hdGlvblN0ZXAgaW1wbGVtZW5hdGlvbiBmb3IgYXdzOmNvcHlJbWFnZVxuICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3N5c3RlbXMtbWFuYWdlci9sYXRlc3QvdXNlcmd1aWRlL2F1dG9tYXRpb24tYWN0aW9uLWNvcHlpbWFnZS5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBDb3B5SW1hZ2VTdGVwIGV4dGVuZHMgQXV0b21hdGlvblN0ZXAge1xuICByZWFkb25seSBhY3Rpb246IHN0cmluZyA9ICdhd3M6Y29weUltYWdlJztcbiAgcmVhZG9ubHkgc291cmNlUmVnaW9uOiBJU3RyaW5nVmFyaWFibGU7XG4gIHJlYWRvbmx5IHNvdXJjZUltYWdlSWQ6IElTdHJpbmdWYXJpYWJsZTtcbiAgcmVhZG9ubHkgaW1hZ2VOYW1lOiBJU3RyaW5nVmFyaWFibGU7XG4gIHJlYWRvbmx5IGltYWdlRGVzY3JpcHRpb24/OiBJU3RyaW5nVmFyaWFibGU7XG4gIHJlYWRvbmx5IGVuY3J5cHRlZD86IElCb29sZWFuVmFyaWFibGU7XG4gIHJlYWRvbmx5IGttc0tleUlkPzogSVN0cmluZ1ZhcmlhYmxlO1xuICByZWFkb25seSBjbGllbnRUb2tlbj86IElTdHJpbmdWYXJpYWJsZTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ29weUltYWdlU3RlcFByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG4gICAgdGhpcy5zb3VyY2VSZWdpb24gPSBwcm9wcy5zb3VyY2VSZWdpb247XG4gICAgdGhpcy5zb3VyY2VJbWFnZUlkID0gcHJvcHMuc291cmNlSW1hZ2VJZDtcbiAgICB0aGlzLmltYWdlTmFtZSA9IHByb3BzLmltYWdlTmFtZTtcbiAgICB0aGlzLmltYWdlRGVzY3JpcHRpb24gPSBwcm9wcy5pbWFnZURlc2NyaXB0aW9uO1xuICAgIHRoaXMuZW5jcnlwdGVkID0gcHJvcHMuZW5jcnlwdGVkO1xuICAgIHRoaXMua21zS2V5SWQgPSBwcm9wcy5rbXNLZXlJZDtcbiAgICB0aGlzLmNsaWVudFRva2VuID0gcHJvcHMuY2xpZW50VG9rZW47XG4gIH1cblxuICBwdWJsaWMgbGlzdE91dHB1dHMoKTogT3V0cHV0W10ge1xuICAgIHJldHVybiBbe1xuICAgICAgb3V0cHV0VHlwZTogRGF0YVR5cGVFbnVtLlNUUklORyxcbiAgICAgIG5hbWU6ICdJbWFnZUlkJyxcbiAgICAgIHNlbGVjdG9yOiAnJC5JbWFnZUlkJyxcbiAgICB9LCB7XG4gICAgICBvdXRwdXRUeXBlOiBEYXRhVHlwZUVudW0uU1RSSU5HLFxuICAgICAgbmFtZTogJ0ltYWdlU3RhdGUnLFxuICAgICAgc2VsZWN0b3I6ICckLkltYWdlU3RhdGUnLFxuICAgIH1dO1xuICB9XG5cbiAgcHVibGljIGxpc3RJbnB1dHMoKTogc3RyaW5nW10ge1xuICAgIGNvbnN0IGlucHV0cyA9IFtcbiAgICAgIHRoaXMuc291cmNlUmVnaW9uLFxuICAgICAgdGhpcy5zb3VyY2VJbWFnZUlkLFxuICAgICAgdGhpcy5pbWFnZU5hbWUsXG4gICAgICB0aGlzLmltYWdlRGVzY3JpcHRpb24sXG4gICAgICB0aGlzLmVuY3J5cHRlZCxcbiAgICAgIHRoaXMua21zS2V5SWQsXG4gICAgICB0aGlzLmNsaWVudFRva2VuLFxuICAgIF07XG5cbiAgICByZXR1cm4gaW5wdXRzLmZsYXRNYXAoaSA9PiBpPy5yZXF1aXJlZElucHV0cygpID8/IFtdKTtcbiAgfVxuXG4gIHB1YmxpYyB0b1NzbUVudHJ5KCk6IFJlY29yZDxzdHJpbmcsIGFueT4ge1xuICAgIGNvbnN0IGVudHJ5TWFwOiBSZWNvcmQ8c3RyaW5nLCBJR2VuZXJpY1ZhcmlhYmxlIHwgdW5kZWZpbmVkPiA9IHtcbiAgICAgIFNvdXJjZVJlZ2lvbjogdGhpcy5zb3VyY2VSZWdpb24sXG4gICAgICBTb3VyY2VJbWFnZUlkOiB0aGlzLnNvdXJjZUltYWdlSWQsXG4gICAgICBJbWFnZU5hbWU6IHRoaXMuaW1hZ2VOYW1lLFxuICAgICAgSW1hZ2VEZXNjcmlwdGlvbjogdGhpcy5pbWFnZURlc2NyaXB0aW9uLFxuICAgICAgRW5jcnlwdGVkOiB0aGlzLmVuY3J5cHRlZCxcbiAgICAgIEttc0tleUlkOiB0aGlzLmttc0tleUlkLFxuICAgICAgQ2xpZW50VG9rZW46IHRoaXMuY2xpZW50VG9rZW4sXG4gICAgfTtcbiAgICBjb25zdCBlbnRyaWVzID0gcHJ1bmVBbmRUcmFuc2Zvcm1SZWNvcmQoZW50cnlNYXAsIHggPT4geC5wcmludCgpKTtcbiAgICByZXR1cm4gc3VwZXIucHJlcGFyZVNzbUVudHJ5KGVudHJpZXMpO1xuICB9XG59Il19