"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChangeInstanceStateStep = exports.DesiredStateVariable = exports.HardCodedDesiredState = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const string_variable_1 = require("../../interface/variables/string-variable");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
class HardCodedDesiredState extends string_variable_1.HardCodedString {
    constructor(val) {
        super(val);
    }
}
exports.HardCodedDesiredState = HardCodedDesiredState;
_a = JSII_RTTI_SYMBOL_1;
HardCodedDesiredState[_a] = { fqn: "cdk-ssm-documents.HardCodedDesiredState", version: "0.0.12" };
HardCodedDesiredState.RUNNING = new HardCodedDesiredState('running');
HardCodedDesiredState.STOPPED = new HardCodedDesiredState('stopped');
HardCodedDesiredState.TERMINATED = new HardCodedDesiredState('terminated');
class DesiredStateVariable extends string_variable_1.StringVariable {
    constructor() {
        super(...arguments);
        this.validValues = ['running', 'stopped', 'terminated'];
    }
    assertType(value) {
        string_variable_1.assertString(value);
        if (!this.validValues.includes(value)) {
            throw new Error(`${value} is not a valid enum value`);
        }
    }
}
exports.DesiredStateVariable = DesiredStateVariable;
_b = JSII_RTTI_SYMBOL_1;
DesiredStateVariable[_b] = { fqn: "cdk-ssm-documents.DesiredStateVariable", version: "0.0.12" };
/**
 * AutomationStep implemenation for aws:changeInstanceState
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-changestate.html
 */
class ChangeInstanceStateStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:changeInstanceState';
        this.instanceIds = props.instanceIds;
        this.desiredState = props.desiredState;
        this.checkStateOnly = props.checkStateOnly;
        this.force = props.force;
        this.additionalInfo = props.additionalInfo;
    }
    /**
       * This step has no outputs.
       */
    listOutputs() {
        return [];
    }
    listInputs() {
        const inputs = [
            this.instanceIds,
            this.desiredState,
            this.checkStateOnly,
            this.force,
            this.additionalInfo,
        ];
        return inputs.flatMap(i => { var _d; return (_d = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _d !== void 0 ? _d : []; });
    }
    toSsmEntry() {
        const entryMap = {
            InstanceIds: this.instanceIds,
            DesiredState: this.desiredState,
            CheckStateOnly: this.checkStateOnly,
            Force: this.force,
            AdditionalInfo: this.additionalInfo,
        };
        const entries = prune_and_transform_record_1.pruneAndTransformRecord(entryMap, x => x.print());
        return super.prepareSsmEntry(entries);
    }
}
exports.ChangeInstanceStateStep = ChangeInstanceStateStep;
_c = JSII_RTTI_SYMBOL_1;
ChangeInstanceStateStep[_c] = { fqn: "cdk-ssm-documents.ChangeInstanceStateStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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