"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsApiStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("../..");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implementation of aws:executeAwsApi
 */
class AwsApiStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.action = 'aws:executeAwsApi';
        this.service = props.service;
        this.pascalCaseApi = props.pascalCaseApi;
        this.apiParams = new __1.DictFormat(props.apiParams);
        this.outputs = props.outputs;
        this.javaScriptApi = (_b = props.javaScriptApi) !== null && _b !== void 0 ? _b : (this.pascalCaseApi.charAt(0).toLowerCase() + this.pascalCaseApi.slice(1));
    }
    /**
       * @returns Outputs as specified in params
       */
    listOutputs() {
        return this.outputs;
    }
    /**
       * Derives the inputs by parsing the apiParams to find matches for inputs in double circle braces ("{{INPUT}}").
       * @returns list of required inputs.
       */
    listInputs() {
        return this.apiParams.requiredInputs();
    }
    toSsmEntry() {
        return super.prepareSsmEntry({
            ...{
                Service: this.service,
                Api: this.pascalCaseApi,
            },
            ...this.apiParams.format,
        });
    }
}
exports.AwsApiStep = AwsApiStep;
_a = JSII_RTTI_SYMBOL_1;
AwsApiStep[_a] = { fqn: "cdk-ssm-documents.AwsApiStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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