"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssertAwsResourceStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_api_step_1 = require("./aws-api-step");
/**
 * AutomationStep implementation of aws:assertAwsResourceProperty.
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-assertAwsResourceProperty.html
 */
class AssertAwsResourceStep extends aws_api_step_1.AwsApiStep {
    constructor(scope, id, props) {
        super(scope, id, {
            ...{
                outputs: [],
            },
            ...props,
        });
        this.action = 'aws:assertAwsResourceProperty';
        this.selector = props.selector;
        this.desiredValues = props.desiredValues;
    }
    /**
       * There are no outputs for this step.
       * @returns empty list
       */
    listOutputs() {
        return [];
    }
    toSsmEntry() {
        return super.prepareSsmEntry({
            ...{
                Service: this.service,
                Api: this.pascalCaseApi,
                PropertySelector: this.selector,
                DesiredValues: this.desiredValues,
            },
            ...this.apiParams.format,
        });
    }
}
exports.AssertAwsResourceStep = AssertAwsResourceStep;
_a = JSII_RTTI_SYMBOL_1;
AssertAwsResourceStep[_a] = { fqn: "cdk-ssm-documents.AssertAwsResourceStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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