"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApproveStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const data_type_1 = require("../../domain/data-type");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implementation for aws:approve
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-approve.html
 */
class ApproveStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:approve';
        this.approvers = props.approvers;
        this.notificationArn = props.notificationArn;
        this.message = props.message;
        this.minRequiredApprovals = props.minRequiredApprovals;
    }
    listOutputs() {
        return [{
                outputType: data_type_1.DataTypeEnum.STRING,
                selector: '$.ApprovalStatus',
                name: 'ApprovalStatus',
            }, {
                outputType: data_type_1.DataTypeEnum.MAP_LIST,
                selector: '$.ApproverDecisions',
                name: 'ApproverDecisions',
            }];
    }
    listInputs() {
        const inputs = [
            this.approvers,
            this.notificationArn,
            this.message,
            this.minRequiredApprovals,
        ];
        return inputs.flatMap(i => { var _b; return (_b = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _b !== void 0 ? _b : []; });
    }
    toSsmEntry() {
        return super.prepareSsmEntry(prune_and_transform_record_1.pruneAndTransformRecord({
            Approvers: this.approvers,
            NotificationArn: this.notificationArn,
            Message: this.message,
            MinRequiredApprovals: this.minRequiredApprovals,
        }, x => x.print()));
    }
    /**
     * Override to mock the date the reviewer approved
     */
    provideDate() {
        return new Date();
    }
}
exports.ApproveStep = ApproveStep;
_a = JSII_RTTI_SYMBOL_1;
ApproveStep[_a] = { fqn: "cdk-ssm-documents.ApproveStep", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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