"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutomationStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("..");
const data_type_1 = require("../domain/data-type");
const step_1 = require("./step");
/**
 * Parent class for AutomationSteps. These steps are using in an AutomationDocument.
 * You can instantiate steps using the AutomationBuilder for convenience.
 * You can use these steps to simulate their execution (mimics the SSM run) AND to build their yaml/json declaration.
 * Control flow of the subsequent step is determined by the currently executing step.
 * The flow of the execution therefore follows a chain-of-responsibility pattern.
 * The inputs received into a step AND the outputs of previous steps are merged to form inputs of subsequent steps.
 */
class AutomationStep extends step_1.Step {
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id, props);
        this.maxAttempts = (_b = props.maxAttempts) !== null && _b !== void 0 ? _b : AutomationStep.DEFAULT_MAX_ATTEMPTS;
        this.timeoutSeconds = (_c = props.timeoutSeconds) !== null && _c !== void 0 ? _c : AutomationStep.DEFAULT_TIMEOUT;
        this.isEnd = (_d = props.isEnd) !== null && _d !== void 0 ? _d : false;
        this.onFailure = props.onFailure;
        this.onCancel = (_e = props.onCancel) !== null && _e !== void 0 ? _e : undefined;
    }
    addToDocument(doc) {
        doc.addStep(this);
    }
    prepareSsmEntry(inputs) {
        // Maps maintain insertion order
        const ssmDef = new Map();
        if (this.description) {
            ssmDef.set('description', this.description);
        }
        ssmDef.set('name', this.name);
        ssmDef.set('action', this.action);
        ssmDef.set('inputs', inputs);
        const formattedOutputs = this.listOutputs().map(output => this.formatOutput(output));
        if (this.listOutputs().length > 0) {
            ssmDef.set('outputs', formattedOutputs);
        }
        if (this.isEnd) {
            ssmDef.set('isEnd', true);
        }
        if (this.maxAttempts != AutomationStep.DEFAULT_MAX_ATTEMPTS) {
            ssmDef.set('maxAttempts', this.maxAttempts);
        }
        if (this.timeoutSeconds != AutomationStep.DEFAULT_TIMEOUT) {
            ssmDef.set('maxAttempts', this.timeoutSeconds);
        }
        if (this.onCancel) {
            ssmDef.set('onCancel', 'step:' + this.onCancel.name);
        }
        if (this.onFailure) {
            ssmDef.set('onCancel', 'step:' + this.onFailure.name);
        }
        const ssmDict = {};
        ssmDef.forEach((value, key) => {
            ssmDict[key] = value;
        });
        return ssmDict;
    }
    /**
       * Formats the provided output into an object that can be used to generate the SSM yaml/json representation.
       */
    formatOutput(output) {
        return {
            Name: output.name,
            Selector: output.selector,
            Type: new data_type_1.DataType(output.outputType).toSsmString(),
        };
    }
    variables() {
        return Object.assign({}, ...this.listOutputs()
            .map(out => ({ [out.name]: new __1.StringVariable(`${this.name}.${out.name}`) })));
    }
}
exports.AutomationStep = AutomationStep;
_a = JSII_RTTI_SYMBOL_1;
AutomationStep[_a] = { fqn: "cdk-ssm-documents.AutomationStep", version: "0.0.12" };
AutomationStep.DEFAULT_TIMEOUT = 3600;
AutomationStep.DEFAULT_MAX_ATTEMPTS = 1;
//# sourceMappingURL=data:application/json;base64,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