"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GenericVariable = exports.HardCodedValueBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class HardCodedValueBase {
    constructor(val) {
        this.assertType(val);
        this.val = val;
    }
    resolve(_inputs) {
        return this.val;
    }
    print() {
        return this.val;
    }
    requiredInputs() {
        return [];
    }
    toJSON() {
        return this.val;
    }
}
exports.HardCodedValueBase = HardCodedValueBase;
_a = JSII_RTTI_SYMBOL_1;
HardCodedValueBase[_a] = { fqn: "cdk-ssm-documents.HardCodedValueBase", version: "0.0.12" };
/**
 * Abstraction of SSM variables.
 * Variables are printed as using this syntax: {{myVariable}}
 * To resolve a variable, you must supply the available inputs and the variable will resolve the value.
 */
class GenericVariable {
    constructor(reference) {
        this.reference = reference;
    }
    resolve(inputs) {
        const result = inputs[this.reference];
        if (result === undefined) {
            return result;
        }
        this.assertType(result);
        return result;
    }
    print() {
        return this.toPlaceholder();
    }
    toPlaceholder() {
        return `{{${this.reference}}}`;
    }
    requiredInputs() {
        return [this.reference];
    }
    toJSON() {
        return this.toPlaceholder();
    }
}
exports.GenericVariable = GenericVariable;
_b = JSII_RTTI_SYMBOL_1;
GenericVariable[_b] = { fqn: "cdk-ssm-documents.GenericVariable", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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