"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.isString = exports.assertString = exports.DictFormat = exports.StringFormat = exports.StringVariable = exports.HardCodedString = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const variable_1 = require("./variable");
/**
 * A hard-coded string variable.
 * Used when not dependent on step inputs.
 */
class HardCodedString extends variable_1.HardCodedValueBase {
    static of(val) {
        return new HardCodedString(val);
    }
    resolveToString(inputs) {
        return this.resolve(inputs);
    }
    assertType(value) {
        assertString(value);
    }
}
exports.HardCodedString = HardCodedString;
_a = JSII_RTTI_SYMBOL_1;
HardCodedString[_a] = { fqn: "cdk-ssm-documents.HardCodedString", version: "0.0.12" };
/**
 * A string variable reference.
 * Used to resolve the value from step inputs.
 */
class StringVariable extends variable_1.GenericVariable {
    static of(reference) {
        return new StringVariable(reference);
    }
    resolveToString(inputs) {
        return this.resolve(inputs);
    }
    assertType(value) {
        assertString(value);
    }
}
exports.StringVariable = StringVariable;
_b = JSII_RTTI_SYMBOL_1;
StringVariable[_b] = { fqn: "cdk-ssm-documents.StringVariable", version: "0.0.12" };
/**
 * Replacement for strings using Java String format style "%s" replacements.
 * Example: new StringFormat("This %s a replacement: %s", [new HardCodedValue("is"), new ExportedVariable("myInput")]);
 * The supported variable strings are either:
 * 1. Implicit indices: "%s" where the first occurrence will match the first variable, the next will match the second...
 * 2. Explicit indices: Example: "%1$s"; where "%1$s" matches the first variable and "%1$s" matches the second.
 * Do not combine usage of implicit and explicit indices. Choose one per StringFormat instance.
 */
class StringFormat {
    constructor(format, variables) {
        this.format = format;
        this.variables = variables !== null && variables !== void 0 ? variables : [];
        const count = (format.match(/%s/g) || []).length;
        if (count != this.variables.length && format.includes('%s')) {
            throw new Error('Variable size must equal number of params expected using \"%s\".' +
                `${count} found, required ${this.variables.length}`);
        }
    }
    resolve(inputs) {
        let replaced = this.format;
        if (this.format.includes('%s')) {
            this.variables.forEach(variable => {
                replaced = replaced.replace('%s', variable.resolve(inputs));
            });
        }
        else {
            for (let i = 0; i < this.variables.length; i++) {
                const find = `%${i + 1}$s`;
                const re = new RegExp(find, 'g');
                replaced = replaced.replace(re, this.variables[i].resolve(inputs));
            }
        }
        return replaced;
    }
    print() {
        let replaced = this.format;
        if (this.format.includes('%s')) {
            this.variables.forEach(variable => {
                replaced = replaced.replace('%s', variable.print());
            });
        }
        else {
            for (let i = 0; i < this.variables.length; i++) {
                const find = `%${i + 1}$s`;
                const re = new RegExp(find, 'g');
                replaced = replaced.replace(re, this.variables[i].print());
            }
        }
        return replaced;
    }
    requiredInputs() {
        return this.variables.flatMap(v => v.requiredInputs());
    }
    toJSON() {
        return this.print();
    }
    resolveToString(inputs) {
        const result = this.resolve(inputs);
        assertString(result);
        return result;
    }
}
exports.StringFormat = StringFormat;
_c = JSII_RTTI_SYMBOL_1;
StringFormat[_c] = { fqn: "cdk-ssm-documents.StringFormat", version: "0.0.12" };
class DictFormat {
    constructor(format) {
        this.format = format;
    }
    resolveToDict(inputs) {
        return JSON.parse(this.resolve(inputs));
    }
    toJSON() {
        return this.print();
    }
    print() {
        return JSON.stringify(this.format);
    }
    requiredInputs() {
        var _e;
        return ((_e = JSON.stringify(this.format).match(/{{.*?}}/g)) === null || _e === void 0 ? void 0 : _e.map(match => match.slice(2, match.length - 2).trim())) || [];
    }
    resolve(inputs) {
        var _e;
        const inputWithVariables = JSON.stringify(this.format);
        let inputCopy = inputWithVariables;
        (_e = inputWithVariables.match(/{{.*?}}/g)) === null || _e === void 0 ? void 0 : _e.forEach(match => {
            const variable = match.slice(2, match.length - 2).trim();
            const replacement = inputs[variable];
            if (replacement == undefined) {
                throw new Error(`Input required but not found: ${variable}`);
            }
            if (typeof replacement === 'string') {
                inputCopy = inputCopy.replace(match, replacement);
            }
            else if (typeof replacement === 'number') {
                inputCopy = inputCopy.replace('\'' + match + '\'', replacement.toString());
                inputCopy = inputCopy.replace('"' + match + '"', replacement.toString());
            }
            else if (Array.isArray(replacement)) {
                inputCopy = inputCopy.replace(match, JSON.stringify(replacement));
                inputCopy = inputCopy.replace(match, JSON.stringify(replacement));
            }
            else {
                throw new Error(`Unsupported data type ${typeof replacement} for ${JSON.stringify(replacement)}`);
            }
        });
        return inputCopy;
    }
    resolveToString(inputs) {
        const result = this.resolve(inputs);
        assertString(result);
        return result;
    }
}
exports.DictFormat = DictFormat;
_d = JSII_RTTI_SYMBOL_1;
DictFormat[_d] = { fqn: "cdk-ssm-documents.DictFormat", version: "0.0.12" };
/**
 * Assert that the given value is a NullableString.
 * @param value value to assert
 */
function assertString(value) {
    if (!isString(value)) {
        throw new Error(`${value} is not a string`);
    }
}
exports.assertString = assertString;
/**
 * Whether the given value is a NullableString.
 * @param value value to check
 * @returns true if the value is a NullableString, otherwise false
 */
function isString(value) {
    if (value === null) {
        return true;
    }
    return typeof value === 'string' || value instanceof String;
}
exports.isString = isString;
//# sourceMappingURL=data:application/json;base64,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