"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SSMDocumentContent = exports.NameDoc = exports.ArnDoc = exports.DocumentSource = exports.S3Content = exports.HttpContent = exports.GitContent = exports.GitHubContent = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class GitHubContent {
    constructor(props) {
        this.sourceType = 'GitHub';
        this.owner = props.owner;
        this.repository = props.repository;
        this.path = props.path;
        this.tokenInfo = props.tokenInfo;
        this.branch = props.branch;
        this.commitId = props.commitId;
        if (this.branch != undefined && this.commitId != undefined) {
            throw new Error('May define either branch or commitId, not both');
        }
    }
    requiredInputs() {
        const inputs = [
            this.owner,
            this.repository,
            this.path,
            this.tokenInfo,
        ];
        return inputs.flatMap(i => { var _j; return (_j = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _j !== void 0 ? _j : []; });
    }
    formatSourceInfo() {
        const sourceInfo = {
            owner: this.owner,
            repository: this.repository,
            path: this.path,
            tokenInfo: this.tokenInfo,
        };
        if (this.branch != undefined) {
            sourceInfo.getOptions = `branch:${this.branch}`;
        }
        if (this.commitId != undefined) {
            sourceInfo.getOptions = `commitID:${this.commitId}`;
        }
        return sourceInfo;
    }
}
exports.GitHubContent = GitHubContent;
_a = JSII_RTTI_SYMBOL_1;
GitHubContent[_a] = { fqn: "cdk-ssm-documents.GitHubContent", version: "0.0.12" };
class GitContent {
    constructor(props) {
        this.sourceType = 'Git';
        this.userName = props.userName;
        this.password = props.password;
        this.repository = props.repository;
        this.privateSshKey = props.privateSshKey;
        this.skipHostKeyChecking = props.skipHostKeyChecking;
        this.branch = props.branch;
        this.commitId = props.commitId;
    }
    requiredInputs() {
        const inputs = [
            this.repository,
            this.skipHostKeyChecking,
        ];
        return inputs.flatMap(i => { var _j; return (_j = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _j !== void 0 ? _j : []; });
    }
    formatSourceInfo() {
        const sourceInfo = {
            repository: this.repository,
        };
        if (this.skipHostKeyChecking != undefined) {
            sourceInfo.skipHostKeyChecking = this.skipHostKeyChecking;
        }
        if (this.privateSshKey != undefined) {
            sourceInfo.privateSSHKey = this.privateSshKey;
        }
        if (this.userName != undefined) {
            sourceInfo.username = this.userName;
        }
        if (this.password != undefined) {
            sourceInfo.password = this.password;
        }
        if (this.branch != undefined) {
            sourceInfo.getOptions = `branch:${this.branch}`;
        }
        if (this.commitId != undefined) {
            sourceInfo.getOptions = `commitID:${this.commitId}`;
        }
        return sourceInfo;
    }
}
exports.GitContent = GitContent;
_b = JSII_RTTI_SYMBOL_1;
GitContent[_b] = { fqn: "cdk-ssm-documents.GitContent", version: "0.0.12" };
class HttpContent {
    constructor(props) {
        this.sourceType = 'HTTP';
        this.url = props.url;
        this.allowInsecureDownload = props.allowInsecureDownload;
        this.authMethod = props.authMethod;
    }
    requiredInputs() {
        var _j, _k;
        const inputs = [
            this.url,
            this.allowInsecureDownload,
        ];
        return [...inputs.flatMap(i => { var _j; return (_j = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _j !== void 0 ? _j : []; }), ...((_k = (_j = this.authMethod) === null || _j === void 0 ? void 0 : _j.requiredInputs()) !== null && _k !== void 0 ? _k : [])];
    }
    formatSourceInfo() {
        const sourceInfo = {
            url: this.url,
        };
        if (this.allowInsecureDownload != undefined) {
            sourceInfo.allowInsecureDownload = this.allowInsecureDownload;
        }
        if (this.authMethod != undefined) {
            return {
                ...sourceInfo,
                ...this.authMethod.toEntry(),
            };
        }
        return sourceInfo;
    }
}
exports.HttpContent = HttpContent;
_c = JSII_RTTI_SYMBOL_1;
HttpContent[_c] = { fqn: "cdk-ssm-documents.HttpContent", version: "0.0.12" };
class S3Content {
    constructor(props) {
        this.sourceType = 'S3';
        this.path = props.path;
    }
    requiredInputs() {
        const inputs = [
            this.path,
        ];
        return inputs.flatMap(i => { var _j; return (_j = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _j !== void 0 ? _j : []; });
    }
    formatSourceInfo() {
        return { path: this.path };
    }
}
exports.S3Content = S3Content;
_d = JSII_RTTI_SYMBOL_1;
S3Content[_d] = { fqn: "cdk-ssm-documents.S3Content", version: "0.0.12" };
class DocumentSource {
    static fromArn(arn) {
        return new ArnDoc(arn);
    }
    static fromName(name, version) {
        return new NameDoc(name, version);
    }
}
exports.DocumentSource = DocumentSource;
_e = JSII_RTTI_SYMBOL_1;
DocumentSource[_e] = { fqn: "cdk-ssm-documents.DocumentSource", version: "0.0.12" };
class ArnDoc extends DocumentSource {
    constructor(arn) {
        super();
        this.arn = arn;
    }
    formatRequest() {
        return { Name: this.arn };
    }
    requiredInputs() {
        return this.arn.requiredInputs();
    }
}
exports.ArnDoc = ArnDoc;
_f = JSII_RTTI_SYMBOL_1;
ArnDoc[_f] = { fqn: "cdk-ssm-documents.ArnDoc", version: "0.0.12" };
class NameDoc extends DocumentSource {
    constructor(name, version) {
        super();
        this.name = name;
        this.version = version;
    }
    formatRequest() {
        if (this.version != undefined) {
            return { Name: this.name.print() + ':' + this.version.print() };
        }
        return { Name: this.name };
    }
    requiredInputs() {
        var _j, _k;
        return [...this.name.requiredInputs(), ...(_k = (_j = this.version) === null || _j === void 0 ? void 0 : _j.requiredInputs()) !== null && _k !== void 0 ? _k : []];
    }
}
exports.NameDoc = NameDoc;
_g = JSII_RTTI_SYMBOL_1;
NameDoc[_g] = { fqn: "cdk-ssm-documents.NameDoc", version: "0.0.12" };
class SSMDocumentContent {
    constructor(props) {
        this.sourceType = 'SSMDocument';
        this.documentSource = props.documentSource;
    }
    formatSourceInfo() {
        return this.documentSource.formatRequest();
    }
    requiredInputs() {
        return this.documentSource.requiredInputs();
    }
}
exports.SSMDocumentContent = SSMDocumentContent;
_h = JSII_RTTI_SYMBOL_1;
SSMDocumentContent[_h] = { fqn: "cdk-ssm-documents.SSMDocumentContent", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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