"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsernamePasswordAuthMethod = exports.NoAuthMethod = exports.AuthMethod = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class AuthMethod {
    static ofNone() {
        return new NoAuthMethod();
    }
    static ofBasic(userName, password) {
        return new UsernamePasswordAuthMethod('Basic', userName, password);
    }
    static ofDigest(userName, password) {
        return new UsernamePasswordAuthMethod('Digest', userName, password);
    }
}
exports.AuthMethod = AuthMethod;
_a = JSII_RTTI_SYMBOL_1;
AuthMethod[_a] = { fqn: "cdk-ssm-documents.AuthMethod", version: "0.0.12" };
class NoAuthMethod extends AuthMethod {
    requiredInputs() {
        return [];
    }
    toEntry() {
        return {
            authMethod: 'None',
        };
    }
}
exports.NoAuthMethod = NoAuthMethod;
_b = JSII_RTTI_SYMBOL_1;
NoAuthMethod[_b] = { fqn: "cdk-ssm-documents.NoAuthMethod", version: "0.0.12" };
class UsernamePasswordAuthMethod extends AuthMethod {
    constructor(authMethod, userName, password) {
        super();
        this.authMethod = authMethod;
        this.userName = userName;
        this.password = password;
    }
    requiredInputs() {
        const inputs = [
            this.userName,
            this.password,
        ];
        return inputs.flatMap(i => { var _d; return (_d = i === null || i === void 0 ? void 0 : i.requiredInputs()) !== null && _d !== void 0 ? _d : []; });
    }
    toEntry() {
        return {
            authMethod: this.authMethod,
            username: this.userName,
            password: this.password,
        };
    }
}
exports.UsernamePasswordAuthMethod = UsernamePasswordAuthMethod;
_c = JSII_RTTI_SYMBOL_1;
UsernamePasswordAuthMethod[_c] = { fqn: "cdk-ssm-documents.UsernamePasswordAuthMethod", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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