"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Choice = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const operation_1 = require("./operation");
/**
 * Choices are supplied to the BranchStep to determine under which conditions to jump to which steps.
 */
class Choice {
    constructor(props) {
        this.operation = props.operation;
        this.constant = props.constant;
        this.variable = props.variable;
        this.jumpToStepName = props.jumpToStepName;
    }
    /**
       * @returns an object that can be used to print this choice into yaml/json format.
       */
    asSsmEntry() {
        const variableName = this.variable.print();
        return {
            NextStep: this.jumpToStepName,
            Variable: variableName,
            [new operation_1.OperationEvaluator(this.operation).toOperationName()]: this.constant,
        };
    }
    /**
       * Evaluates this choice against the provided inputs.
       * The value keyed on the inputToTest will be tested against the declared constant using the Operation specified.
       * @returns true if the evaluation is true. False otherwise.
       */
    evaluate(inputs) {
        const value = this.variable.resolve(inputs);
        return new operation_1.OperationEvaluator(this.operation).evaluate(value, this.constant);
    }
}
exports.Choice = Choice;
_a = JSII_RTTI_SYMBOL_1;
Choice[_a] = { fqn: "cdk-ssm-documents.Choice", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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