from autora.variable import DVInSilico, IVInSilico, IVTrial
from autora.variable.time import DVTime, IVTime
from autora.variable.tinkerforge import DVCurrent, DVVoltage, IVCurrent, IVVoltage

dv_labels = {
    "time_DV": (DVTime, "Time", "", "time_DV", "s", 0, (0, 3600)),
    "voltage0": (DVVoltage, "Voltage 0", "MjY", "voltage0", "mV", 1, (-3500, 3500)),
    "voltage1": (DVVoltage, "Voltage 1", "MjY", "voltage1", "mV", 1, (-3500, 3500)),
    "current0": (DVCurrent, "Current 0", "Hfg", "current0", "mA", 2, (0, 20)),
    "current1": (DVCurrent, "Current 1", "Hfg", "current1", "mA", 2, (0, 20)),
    "verbal_red": (
        DVInSilico,
        "Verbal Response Red",
        None,
        "verbal_red",
        "activation",
        0,
        (0, 1),
    ),
    "verbal_green": (
        DVInSilico,
        "Verbal Response Green",
        None,
        "verbal_green",
        "activation",
        0,
        (0, 1),
    ),
    "verbal_sample": (
        DVInSilico,
        "Verbal Response Sample",
        None,
        "verbal_sample",
        "class",
        0,
        (0, 1),
    ),
    "difference_detected": (
        DVInSilico,
        "Difference Detected",
        None,
        "difference_detected",
        "activation",
        0,
        (0, 1),
    ),
    "difference_detected_sample": (
        DVInSilico,
        "Difference Detected",
        None,
        "difference_detected_sample",
        "class",
        0,
        (0, 1),
    ),
    "learning_performance": (
        DVInSilico,
        "Accuracy",
        None,
        "learning_performance",
        "probability",
        0,
        (0, 1),
    ),
    "learning_performance_sample": (
        DVInSilico,
        "Accuracy Sample",
        None,
        "learning_performance_sample",
        "class",
        0,
        (0, 1),
    ),
    "dx1_lca": (
        DVInSilico,
        "dx1",
        None,
        "dx1_lca",
        "net input delta",
        0,
        (-1000, 1000),
    ),
}
iv_labels = {
    "time_IV": (IVTime, "Time", "", "time_IV", "s", 1, (0, 3600)),
    "trial": (IVTrial, "Trial", "", "trial", "trials", 0, (0, 10000000)),
    "source_voltage": (
        IVVoltage,
        "Source Voltage",
        "MST",
        "source_voltage",
        "mV",
        2,
        (0, 5000),
    ),
    "source_current": (
        IVCurrent,
        "Source Current",
        "MST",
        "source_current",
        "µA",
        2,
        (0, 20000),
    ),
    "color_red": (
        IVInSilico,
        "Color Unit Red",
        None,
        "color_red",
        "activation",
        0,
        (0, 1),
    ),
    "color_green": (
        IVInSilico,
        "Color Unit Green",
        None,
        "color_green",
        "activation",
        0,
        (0, 1),
    ),
    "word_red": (
        IVInSilico,
        "Word Unit Red",
        None,
        "word_red",
        "activation",
        0,
        (0, 1),
    ),
    "word_green": (
        IVInSilico,
        "Word Unit Green",
        None,
        "word_green",
        "activation",
        0,
        (0, 1),
    ),
    "task_color": (
        IVInSilico,
        "Task Unit Color Naming",
        None,
        "task_color",
        "activation",
        0,
        (0, 1),
    ),
    "task_word": (
        IVInSilico,
        "Task Unit Word Reading",
        None,
        "task_word",
        "activation",
        0,
        (0, 1),
    ),
    "S1": (IVInSilico, "Stimulus 1 Intensity", None, "S1", "activation", 0, (0, 5)),
    "S2": (IVInSilico, "Stimulus 2 Intensity", None, "S2", "activation", 0, (0, 5)),
    "learning_trial": (
        IVInSilico,
        "Trial",
        None,
        "learning_trial",
        "trial",
        0,
        (0, 1000),
    ),
    "P_initial": (
        IVInSilico,
        "Initial Performance",
        None,
        "P_initial",
        "probability",
        0,
        (0, 1),
    ),
    "P_asymptotic": (
        IVInSilico,
        "Best Performance",
        None,
        "P_asymptotic",
        "probability",
        0,
        (0, 1),
    ),
    "x1_lca": (IVInSilico, "x1", None, "x1_lca", "net input", 0, (-1000, 1000)),
    "x2_lca": (IVInSilico, "x2", None, "x2_lca", "net input", 0, (-1000, 1000)),
    "x3_lca": (IVInSilico, "x3", None, "x3_lca", "net input", 0, (-1000, 1000)),
}
