from enum import Enum


class GameType(Enum):
    GAME_NONE = -1
    GAME_SP_NEW = 0
    GAME_SP_SCENARIO = 1
    GAME_SP_LOAD = 2
    GAME_MP_NEW = 3
    GAME_MP_SCENARIO = 4
    GAME_MP_LOAD = 5
    GAME_HOTSEAT_NEW = 6
    GAME_HOTSEAT_SCENARIO = 7
    GAME_HOTSEAT_LOAD = 8
    GAME_PBEM_NEW = 9
    GAME_PBEM_SCENARIO = 10
    GAME_PBEM_LOAD = 11
    GAME_REPLAY = 12


class GameStateType(Enum):
    GAMESTATE_ON = 0
    GAMESTATE_OVER = 1
    GAMESTATE_EXTENDED = 2


class YieldType(Enum):
    NO_YIELD = -1
    YIELD_FOOD = 0
    YIELD_PRODUCTION = 1
    YIELD_COMMERCE = 2


class TraitType(Enum):
    NO_TRAIT = -1
    TRAIT_PHILOSOPHICAL = 0
    TRAIT_AGGRESSIVE = 1
    TRAIT_SPIRITUAL = 2
    TRAIT_EXPANSIVE = 3
    TRAIT_INDUSTRIOUS = 4
    TRAIT_CREATIVE = 5
    TRAIT_FINANCIAL = 6
    TRAIT_ORGANIZED = 7
    TRAIT_CHARISMATIC = 8
    TRAIT_PROTECTIVE = 9
    TRAIT_IMPERIALISTIC = 10


class TradeableItem(Enum):
    TRADE_ITEM_NONE = -1
    TRADE_GOLD = 0
    TRADE_GOLD_PER_TURN = 1
    TRADE_MAPS = 2
    TRADE_VASSAL = 3
    TRADE_SURRENDER = 4
    TRADE_OPEN_BORDERS = 5
    TRADE_DEFENSIVE_PACT = 6
    TRADE_PERMANENT_ALLIANCE = 7
    TRADE_PEACE_TREATY = 8
    TRADE_TECHNOLOGIES = 9
    TRADE_RESOURCES = 10
    TRADE_CITIES = 11
    TRADE_PEACE = 12
    TRADE_WAR = 13
    TRADE_EMBARGO = 14
    TRADE_CIVIC = 15
    TRADE_RELIGION = 16


class ReplayMessageType(Enum):
    MAJOR_EVENT = 0
    CITY_FOUNDED = 1
    PLOT_OWNER_CHANGE = 2


class PlotType(Enum):
    NO_PLOT = -1
    PLOT_PEAK = 0
    PLOT_HILLS = 1
    PLOT_LAND = 2
    PLOT_OCEAN = 3


class BuildingType(Enum):
    NO_BUILDING = -1
    BUILDING_PALACE = 0
    BUILDING_GREAT_PALACE = 1
    BUILDING_VERSAILLES = 2
    BUILDING_WALLS = 3
    BUILDING_CELTIC_DUN = 4
    BUILDING_CASTLE = 5
    BUILDING_SPANISH_CITADEL = 6
    BUILDING_BARRACKS = 7
    BUILDING_ZULU_IKHANDA = 8
    BUILDING_STABLE = 9
    BUILDING_MONGOL_GER = 10
    BUILDING_BUNKER = 11
    BUILDING_BOMB_SHELTER = 12
    BUILDING_GRANARY = 13
    BUILDING_INCAN_TERRACE = 14
    BUILDING_AQUEDUCT = 15
    BUILDING_OTTOMAN_HAMMAM = 16
    BUILDING_KHMER_BARAY = 17
    BUILDING_HOSPITAL = 18
    BUILDING_RECYCLING_CENTER = 19
    BUILDING_LIGHTHOUSE = 20
    BUILDING_VIKING_TRADING_POST = 21
    BUILDING_HARBOR = 22
    BUILDING_CARTHAGE_COTHON = 23
    BUILDING_CUSTOM_HOUSE = 24
    BUILDING_PORTUGAL_FEITORIA = 25
    BUILDING_DRYDOCK = 26
    BUILDING_AIRPORT = 27
    BUILDING_FORGE = 28
    BUILDING_MALI_MINT = 29
    BUILDING_FACTORY = 30
    BUILDING_GERMAN_ASSEMBLY_PLANT = 31
    BUILDING_COAL_PLANT = 32
    BUILDING_JAPANESE_SHALE_PLANT = 33
    BUILDING_HYDRO_PLANT = 34
    BUILDING_NUCLEAR_PLANT = 35
    BUILDING_INDUSTRIAL_PARK = 36
    BUILDING_OBELISK = 37
    BUILDING_EGYPTIAN_OBELISK = 38
    BUILDING_ETHIOPIAN_STELE = 39
    BUILDING_NATIVE_AMERICA_TOTEM = 40
    BUILDING_PUBLIC_TRANSPORTATION = 41
    BUILDING_ACADEMY = 42
    BUILDING_LIBRARY = 43
    BUILDING_ARABIAN_MADRASSA = 44
    BUILDING_UNIVERSITY = 45
    BUILDING_KOREAN_SEOWON = 46
    BUILDING_OBSERVATORY = 47
    BUILDING_FRENCH_SALON = 48
    BUILDING_LABORATORY = 49
    BUILDING_RUSSIAN_RESEARCH_INSTITUTE = 50
    BUILDING_THEATRE = 51
    BUILDING_CHINESE_PAVILLION = 52
    BUILDING_BYZANTINE_HIPPODROME = 53
    BUILDING_COLOSSEUM = 54
    BUILDING_GREEK_ODEON = 55
    BUILDING_MAYA_BALL_COURT = 56
    BUILDING_BABYLON_GARDEN = 57
    BUILDING_BROADCAST_TOWER = 58
    BUILDING_MARKET = 59
    BUILDING_ROMAN_FORUM = 60
    BUILDING_GROCER = 61
    BUILDING_PERSIAN_APOTHECARY = 62
    BUILDING_BANK = 63
    BUILDING_ENGLISH_STOCK_EXCHANGE = 64
    BUILDING_SUPERMARKET = 65
    BUILDING_AMERICAN_MALL = 66
    BUILDING_COURTHOUSE = 67
    BUILDING_AZTEC_SACRIFICIAL_ALTAR = 68
    BUILDING_HOLY_ROMAN_RATHAUS = 69
    BUILDING_SUMERIAN_ZIGGURAT = 70
    BUILDING_JAIL = 71
    BUILDING_INDIAN_MAUSOLEUM = 72
    BUILDING_LEVEE = 73
    BUILDING_NETHERLANDS_DIKE = 74
    BUILDING_INTELLIGENCE_AGENCY = 75
    BUILDING_NATIONAL_SECURITY = 76
    BUILDING_JEWISH_TEMPLE = 77
    BUILDING_JEWISH_CATHEDRAL = 78
    BUILDING_JEWISH_MONASTERY = 79
    BUILDING_JEWISH_SHRINE = 80
    BUILDING_CHRISTIAN_TEMPLE = 81
    BUILDING_CHRISTIAN_CATHEDRAL = 82
    BUILDING_CHRISTIAN_MONASTERY = 83
    BUILDING_CHRISTIAN_SHRINE = 84
    BUILDING_ISLAMIC_TEMPLE = 85
    BUILDING_ISLAMIC_CATHEDRAL = 86
    BUILDING_ISLAMIC_MONASTERY = 87
    BUILDING_ISLAMIC_SHRINE = 88
    BUILDING_HINDU_TEMPLE = 89
    BUILDING_HINDU_CATHEDRAL = 90
    BUILDING_HINDU_MONASTERY = 91
    BUILDING_HINDU_SHRINE = 92
    BUILDING_BUDDHIST_TEMPLE = 93
    BUILDING_BUDDHIST_CATHEDRAL = 94
    BUILDING_BUDDHIST_MONASTERY = 95
    BUILDING_BUDDHIST_SHRINE = 96
    BUILDING_CONFUCIAN_TEMPLE = 97
    BUILDING_CONFUCIAN_CATHEDRAL = 98
    BUILDING_CONFUCIAN_MONASTERY = 99
    BUILDING_CONFUCIAN_SHRINE = 100
    BUILDING_TAOIST_TEMPLE = 101
    BUILDING_TAOIST_CATHEDRAL = 102
    BUILDING_TAOIST_MONASTERY = 103
    BUILDING_TAOIST_SHRINE = 104
    BUILDING_HEROIC_EPIC = 105
    BUILDING_NATIONAL_EPIC = 106
    BUILDING_GLOBE_THEATRE = 107
    BUILDING_NATIONAL_PARK = 108
    BUILDING_HERMITAGE = 109
    BUILDING_OXFORD_UNIVERSITY = 110
    BUILDING_WALL_STREET = 111
    BUILDING_IRON_WORKS = 112
    BUILDING_WEST_POINT = 113
    BUILDING_MT_RUSHMORE = 114
    BUILDING_RED_CROSS = 115
    BUILDING_SCOTLAND_YARD = 116
    BUILDING_PYRAMID = 117
    BUILDING_STONEHENGE = 118
    BUILDING_GREAT_LIBRARY = 119
    BUILDING_GREAT_LIGHTHOUSE = 120
    BUILDING_HANGING_GARDEN = 121
    BUILDING_COLOSSUS = 122
    BUILDING_ORACLE = 123
    BUILDING_PARTHENON = 124
    BUILDING_ANGKOR_WAT = 125
    BUILDING_HAGIA_SOPHIA = 126
    BUILDING_CHICHEN_ITZA = 127
    BUILDING_SISTINE_CHAPEL = 128
    BUILDING_SPIRAL_MINARET = 129
    BUILDING_NOTRE_DAME = 130
    BUILDING_TAJ_MAHAL = 131
    BUILDING_KREMLIN = 132
    BUILDING_EIFFEL_TOWER = 133
    BUILDING_STATUE_OF_LIBERTY = 134
    BUILDING_BROADWAY = 135
    BUILDING_ROCKNROLL = 136
    BUILDING_HOLLYWOOD = 137
    BUILDING_GREAT_DAM = 138
    BUILDING_PENTAGON = 139
    BUILDING_UNITED_NATIONS = 140
    BUILDING_SPACE_ELEVATOR = 141
    BUILDING_MILITARY_ACADEMY = 142
    BUILDING_ARTEMIS = 143
    BUILDING_SANKORE = 144
    BUILDING_GREAT_WALL = 145
    BUILDING_STATUE_OF_ZEUS = 146
    BUILDING_MAUSOLEUM_OF_MAUSSOLLOS = 147
    BUILDING_CRISTO_REDENTOR = 148
    BUILDING_SHWEDAGON_PAYA = 149
    BUILDING_MOAI_STATUES = 150
    BUILDING_CORPORATION_1 = 151
    BUILDING_CORPORATION_2 = 152
    BUILDING_CORPORATION_3 = 153
    BUILDING_CORPORATION_4 = 154
    BUILDING_CORPORATION_5 = 155
    BUILDING_CORPORATION_6 = 156
    BUILDING_CORPORATION_7 = 157
    BUILDING_APOSTOLIC_PALACE = 158


class BuildingClassType(Enum):
    NO_BUILDINGCLASS = -1
    BUILDINGCLASS_PALACE = 0
    BUILDINGCLASS_GREAT_PALACE = 1
    BUILDINGCLASS_VERSAILLES = 2
    BUILDINGCLASS_WALLS = 3
    BUILDINGCLASS_CASTLE = 4
    BUILDINGCLASS_BARRACKS = 5
    BUILDINGCLASS_STABLE = 6
    BUILDINGCLASS_BUNKER = 7
    BUILDINGCLASS_BOMB_SHELTER = 8
    BUILDINGCLASS_GRANARY = 9
    BUILDINGCLASS_AQUEDUCT = 10
    BUILDINGCLASS_HOSPITAL = 11
    BUILDINGCLASS_RECYCLING_CENTER = 12
    BUILDINGCLASS_LIGHTHOUSE = 13
    BUILDINGCLASS_HARBOR = 14
    BUILDINGCLASS_CUSTOM_HOUSE = 15
    BUILDINGCLASS_DRYDOCK = 16
    BUILDINGCLASS_AIRPORT = 17
    BUILDINGCLASS_FORGE = 18
    BUILDINGCLASS_FACTORY = 19
    BUILDINGCLASS_COAL_PLANT = 20
    BUILDINGCLASS_HYDRO_PLANT = 21
    BUILDINGCLASS_NUCLEAR_PLANT = 22
    BUILDINGCLASS_INDUSTRIAL_PARK = 23
    BUILDINGCLASS_OBELISK = 24
    BUILDINGCLASS_PUBLIC_TRANSPORTATION = 25
    BUILDINGCLASS_ACADEMY = 26
    BUILDINGCLASS_LIBRARY = 27
    BUILDINGCLASS_UNIVERSITY = 28
    BUILDINGCLASS_OBSERVATORY = 29
    BUILDINGCLASS_LABORATORY = 30
    BUILDINGCLASS_THEATRE = 31
    BUILDINGCLASS_COLOSSEUM = 32
    BUILDINGCLASS_BROADCAST_TOWER = 33
    BUILDINGCLASS_MARKET = 34
    BUILDINGCLASS_GROCER = 35
    BUILDINGCLASS_BANK = 36
    BUILDINGCLASS_SUPERMARKET = 37
    BUILDINGCLASS_COURTHOUSE = 38
    BUILDINGCLASS_JAIL = 39
    BUILDINGCLASS_LEVEE = 40
    BUILDINGCLASS_INTELLIGENCE_AGENCY = 41
    BUILDINGCLASS_NATIONAL_SECURITY = 42
    BUILDINGCLASS_JEWISH_TEMPLE = 43
    BUILDINGCLASS_JEWISH_CATHEDRAL = 44
    BUILDINGCLASS_JEWISH_MONASTERY = 45
    BUILDINGCLASS_JEWISH_SHRINE = 46
    BUILDINGCLASS_CHRISTIAN_TEMPLE = 47
    BUILDINGCLASS_CHRISTIAN_CATHEDRAL = 48
    BUILDINGCLASS_CHRISTIAN_MONASTERY = 49
    BUILDINGCLASS_CHRISTIAN_SHRINE = 50
    BUILDINGCLASS_ISLAMIC_TEMPLE = 51
    BUILDINGCLASS_ISLAMIC_CATHEDRAL = 52
    BUILDINGCLASS_ISLAMIC_MONASTERY = 53
    BUILDINGCLASS_ISLAMIC_SHRINE = 54
    BUILDINGCLASS_HINDU_TEMPLE = 55
    BUILDINGCLASS_HINDU_CATHEDRAL = 56
    BUILDINGCLASS_HINDU_MONASTERY = 57
    BUILDINGCLASS_HINDU_SHRINE = 58
    BUILDINGCLASS_BUDDHIST_TEMPLE = 59
    BUILDINGCLASS_BUDDHIST_CATHEDRAL = 60
    BUILDINGCLASS_BUDDHIST_MONASTERY = 61
    BUILDINGCLASS_BUDDHIST_SHRINE = 62
    BUILDINGCLASS_CONFUCIAN_TEMPLE = 63
    BUILDINGCLASS_CONFUCIAN_CATHEDRAL = 64
    BUILDINGCLASS_CONFUCIAN_MONASTERY = 65
    BUILDINGCLASS_CONFUCIAN_SHRINE = 66
    BUILDINGCLASS_TAOIST_TEMPLE = 67
    BUILDINGCLASS_TAOIST_CATHEDRAL = 68
    BUILDINGCLASS_TAOIST_MONASTERY = 69
    BUILDINGCLASS_TAOIST_SHRINE = 70
    BUILDINGCLASS_HEROIC_EPIC = 71
    BUILDINGCLASS_NATIONAL_EPIC = 72
    BUILDINGCLASS_GLOBE_THEATRE = 73
    BUILDINGCLASS_NATIONAL_PARK = 74
    BUILDINGCLASS_HERMITAGE = 75
    BUILDINGCLASS_OXFORD_UNIVERSITY = 76
    BUILDINGCLASS_WALL_STREET = 77
    BUILDINGCLASS_IRON_WORKS = 78
    BUILDINGCLASS_WEST_POINT = 79
    BUILDINGCLASS_MT_RUSHMORE = 80
    BUILDINGCLASS_RED_CROSS = 81
    BUILDINGCLASS_SCOTLAND_YARD = 82
    BUILDINGCLASS_PYRAMID = 83
    BUILDINGCLASS_STONEHENGE = 84
    BUILDINGCLASS_GREAT_LIBRARY = 85
    BUILDINGCLASS_GREAT_LIGHTHOUSE = 86
    BUILDINGCLASS_HANGING_GARDEN = 87
    BUILDINGCLASS_COLOSSUS = 88
    BUILDINGCLASS_ORACLE = 89
    BUILDINGCLASS_PARTHENON = 90
    BUILDINGCLASS_ANGKOR_WAT = 91
    BUILDINGCLASS_HAGIA_SOPHIA = 92
    BUILDINGCLASS_CHICHEN_ITZA = 93
    BUILDINGCLASS_SISTINE_CHAPEL = 94
    BUILDINGCLASS_NOTRE_DAME = 95
    BUILDINGCLASS_SPIRAL_MINARET = 96
    BUILDINGCLASS_TAJ_MAHAL = 97
    BUILDINGCLASS_KREMLIN = 98
    BUILDINGCLASS_EIFFEL_TOWER = 99
    BUILDINGCLASS_STATUE_OF_LIBERTY = 100
    BUILDINGCLASS_BROADWAY = 101
    BUILDINGCLASS_ROCKNROLL = 102
    BUILDINGCLASS_HOLLYWOOD = 103
    BUILDINGCLASS_GREAT_DAM = 104
    BUILDINGCLASS_PENTAGON = 105
    BUILDINGCLASS_UNITED_NATIONS = 106
    BUILDINGCLASS_SPACE_ELEVATOR = 107
    BUILDINGCLASS_MILITARY_ACADEMY = 108
    BUILDINGCLASS_ARTEMIS = 109
    BUILDINGCLASS_SANKORE = 110
    BUILDINGCLASS_GREAT_WALL = 111
    BUILDINGCLASS_STATUE_OF_ZEUS = 112
    BUILDINGCLASS_MAUSOLEUM_OF_MAUSSOLLOS = 113
    BUILDINGCLASS_CRISTO_REDENTOR = 114
    BUILDINGCLASS_SHWEDAGON_PAYA = 115
    BUILDINGCLASS_MOAI_STATUES = 116
    BUILDINGCLASS_CORPORATION_1 = 117
    BUILDINGCLASS_CORPORATION_2 = 118
    BUILDINGCLASS_CORPORATION_3 = 119
    BUILDINGCLASS_CORPORATION_4 = 120
    BUILDINGCLASS_CORPORATION_5 = 121
    BUILDINGCLASS_CORPORATION_6 = 122
    BUILDINGCLASS_CORPORATION_7 = 123
    BUILDINGCLASS_APOSTOLIC_PALACE = 124


class SpecialBuildingType(Enum):
    NO_SPECIALBUILDING = -1
    SPECIALBUILDING_BOMB_SHELTER = 0
    SPECIALBUILDING_TEMPLE = 1
    SPECIALBUILDING_CATHEDRAL = 2
    SPECIALBUILDING_MONASTERY = 3


class AiSurvivorBuildingType(Enum):
    NO_BUILDING = -1
    BUILDING_PALACE = 0
    BUILDING_GREAT_PALACE = 1
    BUILDING_VERSAILLES = 2
    BUILDING_WALLS = 3
    BUILDING_CELTIC_DUN = 4
    BUILDING_CASTLE = 5
    BUILDING_SPANISH_CITADEL = 6
    BUILDING_BARRACKS = 7
    BUILDING_ZULU_IKHANDA = 8
    BUILDING_STABLE = 9
    BUILDING_MONGOL_GER = 10
    BUILDING_BUNKER = 11
    BUILDING_BOMB_SHELTER = 12
    BUILDING_GRANARY = 13
    BUILDING_INCAN_TERRACE = 14
    BUILDING_AQUEDUCT = 15
    BUILDING_OTTOMAN_HAMMAM = 16
    BUILDING_KHMER_BARAY = 17
    BUILDING_HOSPITAL = 18
    BUILDING_RECYCLING_CENTER = 19
    BUILDING_LIGHTHOUSE = 20
    BUILDING_VIKING_TRADING_POST = 21
    BUILDING_HARBOR = 22
    BUILDING_CARTHAGE_COTHON = 23
    BUILDING_CUSTOM_HOUSE = 24
    BUILDING_PORTUGAL_FEITORIA = 25
    BUILDING_DRYDOCK = 26
    BUILDING_AIRPORT = 27
    BUILDING_FORGE = 28
    BUILDING_MALI_MINT = 29
    BUILDING_FACTORY = 30
    BUILDING_GERMAN_ASSEMBLY_PLANT = 31
    BUILDING_COAL_PLANT = 32
    BUILDING_JAPANESE_SHALE_PLANT = 33
    BUILDING_HYDRO_PLANT = 34
    BUILDING_NUCLEAR_PLANT = 35
    BUILDING_INDUSTRIAL_PARK = 36
    BUILDING_OBELISK = 37
    BUILDING_EGYPTIAN_OBELISK = 38
    BUILDING_ETHIOPIAN_STELE = 39
    BUILDING_NATIVE_AMERICA_TOTEM = 40
    BUILDING_PUBLIC_TRANSPORTATION = 41
    BUILDING_ACADEMY = 42
    BUILDING_LIBRARY = 43
    BUILDING_ARABIAN_MADRASSA = 44
    BUILDING_UNIVERSITY = 45
    BUILDING_KOREAN_SEOWON = 46
    BUILDING_OBSERVATORY = 47
    BUILDING_FRENCH_SALON = 48
    BUILDING_LABORATORY = 49
    BUILDING_RUSSIAN_RESEARCH_INSTITUTE = 50
    BUILDING_THEATRE = 51
    BUILDING_CHINESE_PAVILLION = 52
    BUILDING_BYZANTINE_HIPPODROME = 53
    BUILDING_COLOSSEUM = 54
    BUILDING_GREEK_ODEON = 55
    BUILDING_MAYA_BALL_COURT = 56
    BUILDING_BABYLON_GARDEN = 57
    BUILDING_BROADCAST_TOWER = 58
    BUILDING_MARKET = 59
    BUILDING_ROMAN_FORUM = 60
    BUILDING_GROCER = 61
    BUILDING_PERSIAN_APOTHECARY = 62
    BUILDING_BANK = 63
    BUILDING_ENGLISH_STOCK_EXCHANGE = 64
    BUILDING_SUPERMARKET = 65
    BUILDING_AMERICAN_MALL = 66
    BUILDING_COURTHOUSE = 67
    BUILDING_AZTEC_SACRIFICIAL_ALTAR = 68
    BUILDING_HOLY_ROMAN_RATHAUS = 69
    BUILDING_SUMERIAN_ZIGGURAT = 70
    BUILDING_JAIL = 71
    BUILDING_INDIAN_MAUSOLEUM = 72
    BUILDING_LEVEE = 73
    BUILDING_NETHERLANDS_DIKE = 74
    BUILDING_INTELLIGENCE_AGENCY = 75
    BUILDING_NATIONAL_SECURITY = 76
    BUILDING_JEWISH_TEMPLE = 77
    BUILDING_JEWISH_CATHEDRAL = 78
    BUILDING_JEWISH_MONASTERY = 79
    BUILDING_JEWISH_SHRINE = 80
    BUILDING_CHRISTIAN_TEMPLE = 81
    BUILDING_CHRISTIAN_CATHEDRAL = 82
    BUILDING_CHRISTIAN_MONASTERY = 83
    BUILDING_CHRISTIAN_SHRINE = 84
    BUILDING_ISLAMIC_TEMPLE = 85
    BUILDING_ISLAMIC_CATHEDRAL = 86
    BUILDING_ISLAMIC_MONASTERY = 87
    BUILDING_ISLAMIC_SHRINE = 88
    BUILDING_HINDU_TEMPLE = 89
    BUILDING_HINDU_CATHEDRAL = 90
    BUILDING_HINDU_MONASTERY = 91
    BUILDING_HINDU_SHRINE = 92
    BUILDING_BUDDHIST_TEMPLE = 93
    BUILDING_BUDDHIST_CATHEDRAL = 94
    BUILDING_BUDDHIST_MONASTERY = 95
    BUILDING_BUDDHIST_SHRINE = 96
    BUILDING_CONFUCIAN_TEMPLE = 97
    BUILDING_CONFUCIAN_CATHEDRAL = 98
    BUILDING_CONFUCIAN_MONASTERY = 99
    BUILDING_CONFUCIAN_SHRINE = 100
    BUILDING_TAOIST_TEMPLE = 101
    BUILDING_TAOIST_CATHEDRAL = 102
    BUILDING_TAOIST_MONASTERY = 103
    BUILDING_TAOIST_SHRINE = 104
    BUILDING_HEROIC_EPIC = 105
    BUILDING_NATIONAL_EPIC = 106
    BUILDING_GLOBE_THEATRE = 107
    BUILDING_NATIONAL_PARK = 108
    BUILDING_HERMITAGE = 109
    BUILDING_OXFORD_UNIVERSITY = 110
    BUILDING_WALL_STREET = 111
    BUILDING_IRON_WORKS = 112
    BUILDING_WEST_POINT = 113
    BUILDING_MT_RUSHMORE = 114
    BUILDING_RED_CROSS = 115
    BUILDING_SCOTLAND_YARD = 116
    BUILDING_PYRAMID = 117
    BUILDING_STONEHENGE = 118
    BUILDING_GREAT_LIBRARY = 119
    BUILDING_GREAT_LIGHTHOUSE = 120
    BUILDING_HANGING_GARDEN = 121
    BUILDING_COLOSSUS = 122
    BUILDING_ORACLE = 123
    BUILDING_PARTHENON = 124
    BUILDING_ANGKOR_WAT = 125
    BUILDING_HAGIA_SOPHIA = 126
    BUILDING_CHICHEN_ITZA = 127
    BUILDING_SISTINE_CHAPEL = 128
    BUILDING_SPIRAL_MINARET = 129
    BUILDING_NOTRE_DAME = 130
    BUILDING_TAJ_MAHAL = 131
    BUILDING_KREMLIN = 132
    BUILDING_EIFFEL_TOWER = 133
    BUILDING_STATUE_OF_LIBERTY = 134
    BUILDING_BROADWAY = 135
    BUILDING_ROCKNROLL = 136
    BUILDING_HOLLYWOOD = 137
    BUILDING_GREAT_DAM = 138
    BUILDING_PENTAGON = 139
    BUILDING_UNITED_NATIONS = 140
    BUILDING_SPACE_ELEVATOR = 141
    BUILDING_MILITARY_ACADEMY = 142
    BUILDING_ARTEMIS = 143
    BUILDING_SANKORE = 144
    BUILDING_GREAT_WALL = 145
    BUILDING_STATUE_OF_ZEUS = 146
    BUILDING_MAUSOLEUM_OF_MAUSSOLLOS = 147
    BUILDING_CRISTO_REDENTOR = 148
    BUILDING_SHWEDAGON_PAYA = 149
    BUILDING_MOAI_STATUES = 150
    BUILDING_CORPORATION_1 = 151
    BUILDING_CORPORATION_2 = 152
    BUILDING_CORPORATION_3 = 153
    BUILDING_CORPORATION_4 = 154
    BUILDING_CORPORATION_5 = 155
    BUILDING_CORPORATION_6 = 156
    BUILDING_CORPORATION_7 = 157


class CivilizationType(Enum):
    NO_CIVILIZATION = -1
    CIVILIZATION_AMERICA = 0
    CIVILIZATION_ARABIA = 1
    CIVILIZATION_AZTEC = 2
    CIVILIZATION_BABYLON = 3
    CIVILIZATION_BYZANTIUM = 4
    CIVILIZATION_CARTHAGE = 5
    CIVILIZATION_CELT = 6
    CIVILIZATION_CHINA = 7
    CIVILIZATION_EGYPT = 8
    CIVILIZATION_ENGLAND = 9
    CIVILIZATION_ETHIOPIA = 10
    CIVILIZATION_FRANCE = 11
    CIVILIZATION_GERMANY = 12
    CIVILIZATION_GREECE = 13
    CIVILIZATION_HOLY_ROMAN = 14
    CIVILIZATION_INCA = 15
    CIVILIZATION_INDIA = 16
    CIVILIZATION_JAPAN = 17
    CIVILIZATION_KHMER = 18
    CIVILIZATION_KOREA = 19
    CIVILIZATION_MALI = 20
    CIVILIZATION_MAYA = 21
    CIVILIZATION_MONGOL = 22
    CIVILIZATION_NATIVE_AMERICA = 23
    CIVILIZATION_NETHERLANDS = 24
    CIVILIZATION_OTTOMAN = 25
    CIVILIZATION_PERSIA = 26
    CIVILIZATION_PORTUGAL = 27
    CIVILIZATION_ROME = 28
    CIVILIZATION_RUSSIA = 29
    CIVILIZATION_SPAIN = 30
    CIVILIZATION_SUMERIA = 31
    CIVILIZATION_VIKING = 32
    CIVILIZATION_ZULU = 33
    CIVILIZATION_MINOR = 34
    CIVILIZATION_BARBARIAN = 35


class LeaderHeadType(Enum):
    NO_LEADER = -1
    LEADER_BARBARIAN = 0
    LEADER_ALEXANDER = 1
    LEADER_ASOKA = 2
    LEADER_AUGUSTUS = 3
    LEADER_BISMARCK = 4
    LEADER_BOUDICA = 5
    LEADER_BRENNUS = 6
    LEADER_CATHERINE = 7
    LEADER_CHARLEMAGNE = 8
    LEADER_CHURCHILL = 9
    LEADER_CYRUS = 10
    LEADER_DARIUS = 11
    LEADER_DE_GAULLE = 12
    LEADER_ELIZABETH = 13
    LEADER_FREDERICK = 14
    LEADER_GANDHI = 15
    LEADER_GENGHIS_KHAN = 16
    LEADER_GILGAMESH = 17
    LEADER_HAMMURABI = 18
    LEADER_HANNIBAL = 19
    LEADER_HATSHEPSUT = 20
    LEADER_HUAYNA_CAPAC = 21
    LEADER_ISABELLA = 22
    LEADER_JOAO = 23
    LEADER_JULIUS_CAESAR = 24
    LEADER_JUSTINIAN = 25
    LEADER_KUBLAI_KHAN = 26
    LEADER_LINCOLN = 27
    LEADER_LOUIS_XIV = 28
    LEADER_MANSA_MUSA = 29
    LEADER_CHINESE_LEADER = 30
    LEADER_MEHMED = 31
    LEADER_MONTEZUMA = 32
    LEADER_NAPOLEON = 33
    LEADER_PACAL = 34
    LEADER_PERICLES = 35
    LEADER_PETER = 36
    LEADER_QIN_SHI_HUANG = 37
    LEADER_RAMESSES = 38
    LEADER_RAGNAR = 39
    LEADER_FRANKLIN_ROOSEVELT = 40
    LEADER_SALADIN = 41
    LEADER_SHAKA = 42
    LEADER_SITTING_BULL = 43
    LEADER_STALIN = 44
    LEADER_SULEIMAN = 45
    LEADER_SURYAVARMAN = 46
    LEADER_TOKUGAWA = 47
    LEADER_VICTORIA = 48
    LEADER_WANGKON = 49
    LEADER_WASHINGTON = 50
    LEADER_WILLEM_VAN_ORANJE = 51
    LEADER_ZARA_YAQOB = 52


class EventType(Enum):
    NO_EVENT = -1
    EVENT_FOREST_FIRE_1 = 0
    EVENT_FOREST_FIRE_2 = 1
    EVENT_FOREST_FIRE_3 = 2
    EVENT_CITY_RUINS_1 = 3
    EVENT_CITY_RUINS_2 = 4
    EVENT_CITY_RUINS_3 = 5
    EVENT_HAPPY_HUNTING_1 = 6
    EVENT_MOTHER_LODE_1 = 7
    EVENT_WASHED_OUT_1 = 8
    EVENT_WASHED_OUT_2 = 9
    EVENT_AT_THE_SWORD_1 = 10
    EVENT_MAN_NAMED_JED_1 = 11
    EVENT_MAN_NAMED_JED_2 = 12
    EVENT_INSPIRED_MISSION_1 = 13
    EVENT_INSPIRED_MISSION_2 = 14
    EVENT_INSPIRED_MISSION_3 = 15
    EVENT_HYMNS_AND_SCULPTURES_1 = 16
    EVENT_CARELESS_APPRENTICE_1 = 17
    EVENT_CARELESS_APPRENTICE_2 = 18
    EVENT_CARELESS_APPRENTICE_3 = 19
    EVENT_FAMINE_1 = 20
    EVENT_FAMINE_2 = 21
    EVENT_FAMINE_3 = 22
    EVENT_SLAVE_REVOLT_1 = 23
    EVENT_SLAVE_REVOLT_2 = 24
    EVENT_SLAVE_REVOLT_3 = 25
    EVENT_BLESSED_SEA_1 = 26
    EVENT_BLESSED_SEA_DONE_1 = 27
    EVENT_BLESSED_SEA_DONE_2 = 28
    EVENT_BLESSED_SEA_DONE_3 = 29
    EVENT_AIRLINER_CRASH_1 = 30
    EVENT_AIRLINER_CRASH_2 = 31
    EVENT_AIRLINER_CRASH_3 = 32
    EVENT_AIRLINER_CRASH_4 = 33
    EVENT_FARM_BANDITS_1 = 34
    EVENT_FARM_BANDITS_2 = 35
    EVENT_FARM_BANDITS_3 = 36
    EVENT_HOLY_MOUNTAIN_1 = 37
    EVENT_HOLY_MOUNTAIN_DONE_1 = 38
    EVENT_HOLY_MOUNTAIN_REVEALED_1 = 39
    EVENT_HORTICULTURE_1 = 40
    EVENT_HORTICULTURE_2 = 41
    EVENT_HORTICULTURE_3 = 42
    EVENT_FUGITIVE_1 = 43
    EVENT_FUGITIVE_2 = 44
    EVENT_FUGITIVE_3 = 45
    EVENT_FUGITIVE_4 = 46
    EVENT_FUGITIVE_5 = 47
    EVENT_PESTILENCE_1 = 48
    EVENT_MARATHON_1 = 49
    EVENT_FAUX_PAS_1 = 50
    EVENT_JOYOUS_WEDDING_1 = 51
    EVENT_JOYOUS_WEDDING_2 = 52
    EVENT_JOYOUS_WEDDING_3 = 53
    EVENT_WEDDING_FEUD_1 = 54
    EVENT_WEDDING_FEUD_2 = 55
    EVENT_WEDDING_FEUD_3 = 56
    EVENT_LEFT_AT_ALTAR_1 = 57
    EVENT_SPICY_1 = 58
    EVENT_SPICY_2 = 59
    EVENT_TORNADO_1 = 60
    EVENT_BABY_BOOM_1 = 61
    EVENT_BARDS_TALE_1 = 62
    EVENT_BARDS_TALE_2 = 63
    EVENT_BARDS_TALE_3 = 64
    EVENT_LOOTERS_1 = 65
    EVENT_LOOTERS_2 = 66
    EVENT_LOOTERS_3 = 67
    EVENT_LOOTERS_4 = 68
    EVENT_BROTHERS_IN_NEED_1 = 69
    EVENT_BROTHERS_IN_NEED_2 = 70
    EVENT_BROTHERS_IN_NEED_3 = 71
    EVENT_BROTHERS_IN_NEED_4 = 72
    EVENT_BROTHERS_IN_NEED_5 = 73
    EVENT_BROTHERS_IN_NEED_6 = 74
    EVENT_BROTHERS_IN_NEED_7 = 75
    EVENT_HURRICANE_1 = 76
    EVENT_HURRICANE_2 = 77
    EVENT_CYCLONE_1 = 78
    EVENT_CYCLONE_2 = 79
    EVENT_TSUNAMI_1 = 80
    EVENT_TSUNAMI_2 = 81
    EVENT_MONSOON_1 = 82
    EVENT_MONSOON_2 = 83
    EVENT_BLIZZARD_1 = 84
    EVENT_BLIZZARD_2 = 85
    EVENT_VOLCANO_1 = 86
    EVENT_DUSTBOWL_1 = 87
    EVENT_DUSTBOWL_2 = 88
    EVENT_PARROTS_1 = 89
    EVENT_JADE_1 = 90
    EVENT_BLACK_PEARLS_1 = 91
    EVENT_SALTPETER_1 = 92
    EVENT_CLUNKER_COAL_1 = 93
    EVENT_SOUR_CRUDE_1 = 94
    EVENT_TRUFFLES_1 = 95
    EVENT_SEA_TURTLES_1 = 96
    EVENT_TIN_1 = 97
    EVENT_PRAIRIE_DOGS_1 = 98
    EVENT_ICE_SCULPTURE_1 = 99
    EVENT_ICE_SCULPTURE_2 = 100
    EVENT_APPLESEED_1 = 101
    EVENT_MINING_ACCIDENT_1 = 102
    EVENT_MINING_ACCIDENT_2 = 103
    EVENT_MINING_ACCIDENT_3 = 104
    EVENT_BREAKTHROUGH_1 = 105
    EVENT_SETBACK_1 = 106
    EVENT_RUNNING_BULLS_1 = 107
    EVENT_RUNNING_BULLS_2 = 108
    EVENT_GREAT_DEPRESSION_1 = 109
    EVENT_BERMUDA_TRIANGLE_1 = 110
    EVENT_PATRON_OF_KNOWLEDGE_1 = 111
    EVENT_PATRON_OF_KNOWLEDGE_2 = 112
    EVENT_MASTER_SMITH_1 = 113
    EVENT_RURAL_FARMERS_1 = 114
    EVENT_MONEY_CHANGERS_1 = 115
    EVENT_BOWYER_1 = 116
    EVENT_HORSESHOE_1 = 117
    EVENT_CHAMPION_1 = 118
    EVENT_MOTOR_OIL_1 = 119
    EVENT_MOTOR_OIL_2 = 120
    EVENT_FEDERAL_RESERVE_1 = 121
    EVENT_FEDERAL_RESERVE_2 = 122
    EVENT_ELECTRIC_COMPANY_1 = 123
    EVENT_HINDENBERG_1 = 124
    EVENT_HINDENBERG_2 = 125
    EVENT_COMET_FRAGMENT_1 = 126
    EVENT_SUBWAY_1 = 127
    EVENT_GOLD_RUSH_1 = 128
    EVENT_GOLD_RUSH_2 = 129
    EVENT_INFLUENZA_1 = 130
    EVENT_INFLUENZA_2 = 131
    EVENT_SOLO_FLIGHT_1 = 132
    EVENT_ANTELOPE_1 = 133
    EVENT_ANTELOPE_2 = 134
    EVENT_WHALEOFATHING_1 = 135
    EVENT_HIYOSILVER_1 = 136
    EVENT_HIYOSILVER_2 = 137
    EVENT_WININGMONKS_1 = 138
    EVENT_WININGMONKS_2 = 139
    EVENT_INDEPENDENTFILMS_1 = 140
    EVENT_ANCIENTOLYMPICS_1 = 141
    EVENT_ANCIENTOLYMPICS_2 = 142
    EVENT_MODERNOLYMPICS_1 = 143
    EVENT_INTERSTATE_1 = 144
    EVENT_EARTHDAY_1 = 145
    EVENT_EARTHDAY_2 = 146
    EVENT_FREEDOMCONCERT_1 = 147
    EVENT_FREEDOMCONCERT_2 = 148
    EVENT_AXE_HAFT_1 = 149
    EVENT_TOWER_SHIELD_1 = 150
    EVENT_SMOKELESS_POWDER_1 = 151
    EVENT_STRONGER_FITTINGS_1 = 152
    EVENT_FIRING_PINS_1 = 153
    EVENT_RIFLED_CANNON_1 = 154
    EVENT_METAL_DECKS_1 = 155
    EVENT_LONG_RANGE_FIGHTERS_1 = 156
    EVENT_HALBERD_1 = 157
    EVENT_REINFORCED_HULL_1 = 158
    EVENT_CIGARETTE_SMOKER_1 = 159
    EVENT_CIGARETTE_SMOKER_2 = 160
    EVENT_CIGARETTE_SMOKER_3 = 161
    EVENT_HEROIC_GESTURE_1 = 162
    EVENT_HEROIC_GESTURE_2 = 163
    EVENT_GREAT_MEDIATOR_1 = 164
    EVENT_GREAT_MEDIATOR_2 = 165
    EVENT_FORTY_THIEVES_1 = 166
    EVENT_ANCIENT_TEXTS_1 = 167
    EVENT_ANCIENT_TEXTS_2 = 168
    EVENT_WATERS_OF_LIFE_1 = 169
    EVENT_IMPACT_CRATER_1 = 170
    EVENT_IMPACT_CRATER_2 = 171
    EVENT_THE_HUNS_1 = 172
    EVENT_THE_VANDALS_1 = 173
    EVENT_THE_GOTHS_1 = 174
    EVENT_THE_PHILISTINES_1 = 175
    EVENT_THE_VEDIC_ARYANS_1 = 176
    EVENT_HOLY_RITUAL_1 = 177
    EVENT_SECURITY_TAX_1 = 178
    EVENT_LITERACY_1 = 179
    EVENT_FARM_PLOWS_1 = 180
    EVENT_STAINED_GLASS_1 = 181
    EVENT_MARBLE_STATUES_1 = 182
    EVENT_CRAB_CAKES_1 = 183
    EVENT_BOILERS_1 = 184
    EVENT_PERSONAL_COMPUTERS_1 = 185
    EVENT_FUEL_ADDITIVES_1 = 186
    EVENT_HAMBURGER_JOINT_1 = 187
    EVENT_TEA_1 = 188
    EVENT_FASHION_1 = 189
    EVENT_THOROUGHBRED_1 = 190
    EVENT_GIRLS_BEST_FRIEND_1 = 191
    EVENT_BANANA_SPLIT_1 = 192
    EVENT_HORSE_WHISPERING_1 = 193
    EVENT_HORSE_WHISPERING_DONE_1 = 194
    EVENT_HORSE_WHISPERING_DONE_2 = 195
    EVENT_HORSE_WHISPERING_DONE_3 = 196
    EVENT_HARBORMASTER_1 = 197
    EVENT_HARBORMASTER_DONE_1 = 198
    EVENT_HARBORMASTER_DONE_2 = 199
    EVENT_HARBORMASTER_DONE_3 = 200
    EVENT_CLASSIC_LITERATURE_1 = 201
    EVENT_CLASSIC_LITERATURE_DONE_1 = 202
    EVENT_CLASSIC_LITERATURE_DONE_2 = 203
    EVENT_CLASSIC_LITERATURE_DONE_3 = 204
    EVENT_MASTER_BLACKSMITH_1 = 205
    EVENT_MASTER_BLACKSMITH_DONE_1 = 206
    EVENT_MASTER_BLACKSMITH_DONE_2 = 207
    EVENT_MASTER_BLACKSMITH_DONE_3 = 208
    EVENT_BEST_DEFENSE_1 = 209
    EVENT_BEST_DEFENSE_DONE_1 = 210
    EVENT_BEST_DEFENSE_DONE_2 = 211
    EVENT_BEST_DEFENSE_DONE_3 = 212
    EVENT_SPORTS_LEAGUE_1 = 213
    EVENT_SPORTS_LEAGUE_DONE_1 = 214
    EVENT_SPORTS_LEAGUE_DONE_2 = 215
    EVENT_SPORTS_LEAGUE_DONE_3 = 216
    EVENT_CRUSADE_1 = 217
    EVENT_CRUSADE_DONE_1 = 218
    EVENT_CRUSADE_DONE_2 = 219
    EVENT_CRUSADE_DONE_3 = 220
    EVENT_MIRACLE_1 = 221
    EVENT_MIRACLE_2 = 222
    EVENT_ESTEEMED_PLAYWRIGHT_1 = 223
    EVENT_ESTEEMED_PLAYWRIGHT_2 = 224
    EVENT_FAVORITE_SON_1 = 225
    EVENT_FAVORITE_SON_2 = 226
    EVENT_SECRET_KNOWLEDGE_1 = 227
    EVENT_SECRET_KNOWLEDGE_2 = 228
    EVENT_HIGH_WARLORD_1 = 229
    EVENT_HIGH_WARLORD_2 = 230
    EVENT_HIGH_WARLORD_3 = 231
    EVENT_SPOILED_GRAIN_1 = 232
    EVENT_SPOILED_GRAIN_2 = 233
    EVENT_ANGEL_OF_MERCY_1 = 234
    EVENT_ANGEL_OF_MERCY_2 = 235
    EVENT_CHILLY_FLIGHT_1 = 236
    EVENT_INDUSTRIAL_FIRE_1 = 237
    EVENT_INDUSTRIAL_FIRE_2 = 238
    EVENT_LABORATORY_1 = 239
    EVENT_EXPERIENCED_CAPTAIN_1 = 240
    EVENT_EXPERIENCED_CAPTAIN_2 = 241
    EVENT_HERESY_1 = 242
    EVENT_HERESY_2 = 243
    EVENT_HERESY_3 = 244
    EVENT_PARTISANS_1 = 245
    EVENT_PARTISANS_2 = 246
    EVENT_NEW_DYNASTY_1 = 247
    EVENT_NEW_DYNASTY_2 = 248
    EVENT_NEW_DYNASTY_3 = 249
    EVENT_CRISIS_IN_THE_SENATE_1 = 250
    EVENT_CRISIS_IN_THE_SENATE_2 = 251
    EVENT_CRISIS_IN_THE_SENATE_3 = 252
    EVENT_TOO_CLOSE_TO_CALL_1 = 253
    EVENT_TOO_CLOSE_TO_CALL_2 = 254
    EVENT_CHARISMATIC_1 = 255
    EVENT_CHARISMATIC_2 = 256
    EVENT_FRIENDLY_LOCALS_1 = 257
    EVENT_GREED_1 = 258
    EVENT_GREED_DONE_1 = 259
    EVENT_WAR_CHARIOTS_1 = 260
    EVENT_WAR_CHARIOTS_DONE_1 = 261
    EVENT_WAR_CHARIOTS_DONE_2 = 262
    EVENT_ELITE_SWORDS_1 = 263
    EVENT_ELITE_SWORDS_DONE_1 = 264
    EVENT_ELITE_SWORDS_DONE_2 = 265
    EVENT_WARSHIPS_1 = 266
    EVENT_WARSHIPS_DONE_1 = 267
    EVENT_WARSHIPS_DONE_2 = 268
    EVENT_GUNS_BUTTER_1 = 269
    EVENT_GUNS_BUTTER_DONE_1 = 270
    EVENT_GUNS_BUTTER_DONE_2 = 271
    EVENT_GUNS_BUTTER_DONE_3 = 272
    EVENT_NOBLE_KNIGHTS_1 = 273
    EVENT_NOBLE_KNIGHTS_DONE_1 = 274
    EVENT_NOBLE_KNIGHTS_DONE_2 = 275
    EVENT_NOBLE_KNIGHTS_DONE_3 = 276
    EVENT_OVERWHELM_1 = 277
    EVENT_OVERWHELM_DONE_1 = 278
    EVENT_OVERWHELM_DONE_2 = 279
    EVENT_OVERWHELM_DONE_3 = 280
    EVENT_CORPORATE_EXPANSION_1 = 281
    EVENT_CORPORATE_EXPANSION_DONE_1 = 282
    EVENT_HOSTILE_TAKEOVER_1 = 283
    EVENT_HOSTILE_TAKEOVER_DONE_1 = 284
    EVENT_CIV_GAME_1 = 285
    EVENT_CIV_GAME_2 = 286
    EVENT_CIV_GAME_3 = 287
    EVENT_SLAVE_REVOLT_WARNING = 288
    EVENT_IMMIGRANTS_1 = 289
    EVENT_HEALING_PLANT_1 = 290
    EVENT_HEALING_PLANT_2 = 291
    EVENT_HEALING_PLANT_3 = 292
    EVENT_HEALING_PLANT_4 = 293
    EVENT_HEALING_PLANT_5 = 294
    EVENT_HEALING_PLANT_6 = 295
    EVENT_GREAT_BEAST_1 = 296
    EVENT_GREAT_BEAST_2 = 297
    EVENT_GREAT_BEAST_3 = 298
    EVENT_CONTROVERSIAL_PHILOSOPHER_1 = 299
    EVENT_CONTROVERSIAL_PHILOSOPHER_2 = 300
    EVENT_CONTROVERSIAL_PHILOSOPHER_3 = 301
    EVENT_DEFECTING_AGENT_1 = 302
    EVENT_DEFECTING_AGENT_2 = 303
    EVENT_DEFECTING_AGENT_3 = 304
    EVENT_JAIL_1 = 305
    EVENT_JAIL_2 = 306
    EVENT_SPY_DISCOVERED_1 = 307
    EVENT_SPY_DISCOVERED_2 = 308
    EVENT_SPY_DISCOVERED_3 = 309
    EVENT_NUCLEAR_PROTEST_1 = 310
    EVENT_NUCLEAR_PROTEST_2 = 311
    EVENT_NUCLEAR_PROTEST_3 = 312
    EVENT_BETTER_COAL_1 = 313
    EVENT_BETTER_COAL_2 = 314
    EVENT_BROKEN_DAM_1 = 315
    EVENT_BROKEN_DAM_2 = 316
    EVENT_BROKEN_DAM_3 = 317
    EVENT_RABBI_1 = 318
    EVENT_RABBI_2 = 319
    EVENT_RABBI_3 = 320
    EVENT_GOLDEN_BUDDHA_1 = 321
    EVENT_GOLDEN_BUDDHA_2 = 322
    EVENT_GOLDEN_BUDDHA_3 = 323
    EVENT_PREACHING_RESEARCHER_1 = 324
    EVENT_PREACHING_RESEARCHER_2 = 325
    EVENT_TOXCATL_1 = 326
    EVENT_TOXCATL_2 = 327
    EVENT_DISSIDENT_PRIEST_1 = 328
    EVENT_DISSIDENT_PRIEST_2 = 329
    EVENT_DISSIDENT_PRIEST_3 = 330
    EVENT_PASTURE_BUILT_1 = 331
    EVENT_ROGUE_STATION_1 = 332
    EVENT_ROGUE_STATION_2 = 333
    EVENT_ROGUE_STATION_3 = 334
    EVENT_ANTIMONARCHISTS_1 = 335
    EVENT_ANTIMONARCHISTS_2 = 336
    EVENT_IMPEACHMENT_1 = 337
    EVENT_IMPEACHMENT_2 = 338


class EventTriggerType(Enum):
    NO_EVENTTRIGGER = -1
    EVENTTRIGGER_FOREST_FIRE = 0
    EVENTTRIGGER_CITY_RUINS_ANCIENT = 1
    EVENTTRIGGER_HAPPY_HUNTING = 2
    EVENTTRIGGER_MOTHER_LODE = 3
    EVENTTRIGGER_WASHED_OUT = 4
    EVENTTRIGGER_AT_THE_SWORD = 5
    EVENTTRIGGER_MAN_NAMED_JED = 6
    EVENTTRIGGER_INSPIRED_MISSION = 7
    EVENTTRIGGER_HYMNS_AND_SCULPTURES = 8
    EVENTTRIGGER_CARELESS_APPRENTICE = 9
    EVENTTRIGGER_FAMINE = 10
    EVENTTRIGGER_SLAVE_REVOLT = 11
    EVENTTRIGGER_SLAVE_REVOLT_AGAIN = 12
    EVENTTRIGGER_BLESSED_SEA = 13
    EVENTTRIGGER_BLESSED_SEA_DONE = 14
    EVENTTRIGGER_AIRLINER_CRASH = 15
    EVENTTRIGGER_FARM_BANDITS = 16
    EVENTTRIGGER_FARM_BANDITS_AGAIN = 17
    EVENTTRIGGER_HOLY_MOUNTAIN = 18
    EVENTTRIGGER_HOLY_MOUNTAIN_DONE = 19
    EVENTTRIGGER_HOLY_MOUNTAIN_REVEALED = 20
    EVENTTRIGGER_HORTICULTURE = 21
    EVENTTRIGGER_FUGITIVE = 22
    EVENTTRIGGER_PESTILENCE = 23
    EVENTTRIGGER_PESTILENCE_2 = 24
    EVENTTRIGGER_MARATHON = 25
    EVENTTRIGGER_FAUX_PAS = 26
    EVENTTRIGGER_JOYOUS_WEDDING = 27
    EVENTTRIGGER_WEDDING_FEUD = 28
    EVENTTRIGGER_LEFT_AT_ALTAR = 29
    EVENTTRIGGER_SPICY = 30
    EVENTTRIGGER_TORNADO = 31
    EVENTTRIGGER_BABY_BOOM = 32
    EVENTTRIGGER_BARDS_TALE = 33
    EVENTTRIGGER_LOOTERS = 34
    EVENTTRIGGER_BROTHERS_IN_NEED = 35
    EVENTTRIGGER_HURRICANE = 36
    EVENTTRIGGER_CYCLONE = 37
    EVENTTRIGGER_TSUNAMI = 38
    EVENTTRIGGER_MONSOON = 39
    EVENTTRIGGER_BLIZZARD = 40
    EVENTTRIGGER_VOLCANO = 41
    EVENTTRIGGER_DUSTBOWL = 42
    EVENTTRIGGER_DUSTBOWL_CONT = 43
    EVENTTRIGGER_PARROTS = 44
    EVENTTRIGGER_JADE = 45
    EVENTTRIGGER_BLACK_PEARLS = 46
    EVENTTRIGGER_SALTPETER = 47
    EVENTTRIGGER_CLUNKER_COAL = 48
    EVENTTRIGGER_SOUR_CRUDE = 49
    EVENTTRIGGER_TRUFFLES = 50
    EVENTTRIGGER_SEA_TURTLES = 51
    EVENTTRIGGER_TIN = 52
    EVENTTRIGGER_PRAIRIE_DOGS = 53
    EVENTTRIGGER_ICE_SCULPTURE = 54
    EVENTTRIGGER_APPLESEED = 55
    EVENTTRIGGER_MINING_ACCIDENT = 56
    EVENTTRIGGER_BREAKTHROUGH = 57
    EVENTTRIGGER_SETBACK = 58
    EVENTTRIGGER_RUNNING_BULLS = 59
    EVENTTRIGGER_GREAT_DEPRESSION = 60
    EVENTTRIGGER_BERMUDA_TRIANGLE = 61
    EVENTTRIGGER_PATRON_OF_KNOWLEDGE = 62
    EVENTTRIGGER_MASTER_SMITH = 63
    EVENTTRIGGER_RURAL_FARMERS = 64
    EVENTTRIGGER_MONEY_CHANGERS = 65
    EVENTTRIGGER_BOWYER = 66
    EVENTTRIGGER_HORSESHOE = 67
    EVENTTRIGGER_CHAMPION = 68
    EVENTTRIGGER_MOTOR_OIL = 69
    EVENTTRIGGER_FEDERAL_RESERVE = 70
    EVENTTRIGGER_ELECTRIC_COMPANY = 71
    EVENTTRIGGER_HINDENBERG = 72
    EVENTTRIGGER_COMET_FRAGMENT = 73
    EVENTTRIGGER_SUBWAY = 74
    EVENTTRIGGER_GOLD_RUSH = 75
    EVENTTRIGGER_INFLUENZA = 76
    EVENTTRIGGER_SOLO_FLIGHT = 77
    EVENTTRIGGER_ANTELOPE = 78
    EVENTTRIGGER_WHALEOFATHING = 79
    EVENTTRIGGER_HIYOSILVER = 80
    EVENTTRIGGER_WININGMONKS = 81
    EVENTTRIGGER_INDEPENDENTFILMS = 82
    EVENTTRIGGER_ANCIENTOLYMPICS = 83
    EVENTTRIGGER_MODERNOLYMPICS = 84
    EVENTTRIGGER_INTERSTATE = 85
    EVENTTRIGGER_EARTHDAY = 86
    EVENTTRIGGER_FREEDOMCONCERT = 87
    EVENTTRIGGER_AXE_HAFT = 88
    EVENTTRIGGER_TOWER_SHIELD = 89
    EVENTTRIGGER_SMOKELESS_POWDER = 90
    EVENTTRIGGER_STRONGER_FITTINGS = 91
    EVENTTRIGGER_FIRING_PINS = 92
    EVENTTRIGGER_RIFLED_CANNON = 93
    EVENTTRIGGER_METAL_DECKS = 94
    EVENTTRIGGER_LONG_RANGE_FIGHTERS = 95
    EVENTTRIGGER_HALBERD = 96
    EVENTTRIGGER_REINFORCED_HULL = 97
    EVENTTRIGGER_CIGARETTE_SMOKER = 98
    EVENTTRIGGER_HEROIC_GESTURE = 99
    EVENTTRIGGER_GREAT_MEDIATOR = 100
    EVENTTRIGGER_FORTY_THIEVES = 101
    EVENTTRIGGER_ANCIENT_TEXTS = 102
    EVENTTRIGGER_WATERS_OF_LIFE = 103
    EVENTTRIGGER_IMPACT_CRATER = 104
    EVENTTRIGGER_THE_HUNS = 105
    EVENTTRIGGER_THE_VANDALS = 106
    EVENTTRIGGER_THE_GOTHS = 107
    EVENTTRIGGER_THE_PHILISTINES = 108
    EVENTTRIGGER_THE_VEDIC_ARYANS = 109
    EVENTTRIGGER_HOLY_RITUAL = 110
    EVENTTRIGGER_SECURITY_TAX = 111
    EVENTTRIGGER_LITERACY = 112
    EVENTTRIGGER_FARM_PLOWS = 113
    EVENTTRIGGER_STAINED_GLASS = 114
    EVENTTRIGGER_MARBLE_STATUES = 115
    EVENTTRIGGER_CRAB_CAKES = 116
    EVENTTRIGGER_BOILERS = 117
    EVENTTRIGGER_PERSONAL_COMPUTERS = 118
    EVENTTRIGGER_FUEL_ADDITIVES = 119
    EVENTTRIGGER_HAMBURGER_JOINT = 120
    EVENTTRIGGER_TEA = 121
    EVENTTRIGGER_FASHION = 122
    EVENTTRIGGER_THOROUGHBRED = 123
    EVENTTRIGGER_GIRLS_BEST_FRIEND = 124
    EVENTTRIGGER_BANANA_SPLIT = 125
    EVENTTRIGGER_HORSE_WHISPERING = 126
    EVENTTRIGGER_HORSE_WHISPERING_DONE = 127
    EVENTTRIGGER_HARBORMASTER = 128
    EVENTTRIGGER_HARBORMASTER_DONE = 129
    EVENTTRIGGER_CLASSIC_LITERATURE = 130
    EVENTTRIGGER_CLASSIC_LITERATURE_DONE = 131
    EVENTTRIGGER_MASTER_BLACKSMITH = 132
    EVENTTRIGGER_MASTER_BLACKSMITH_DONE = 133
    EVENTTRIGGER_BEST_DEFENSE = 134
    EVENTTRIGGER_BEST_DEFENSE_DONE = 135
    EVENTTRIGGER_SPORTS_LEAGUE = 136
    EVENTTRIGGER_SPORTS_LEAGUE_DONE = 137
    EVENTTRIGGER_CRUSADE = 138
    EVENTTRIGGER_CRUSADE_DONE = 139
    EVENTTRIGGER_MIRACLE = 140
    EVENTTRIGGER_ESTEEMED_PLAYWRIGHT = 141
    EVENTTRIGGER_FAVORITE_SON = 142
    EVENTTRIGGER_SECRET_KNOWLEDGE = 143
    EVENTTRIGGER_HIGH_WARLORD = 144
    EVENTTRIGGER_SPOILED_GRAIN = 145
    EVENTTRIGGER_ANGEL_OF_MERCY = 146
    EVENTTRIGGER_CHILLY_FLIGHT = 147
    EVENTTRIGGER_INDUSTRIAL_FIRE = 148
    EVENTTRIGGER_LABORATORY = 149
    EVENTTRIGGER_EXPERIENCED_CAPTAIN = 150
    EVENTTRIGGER_HERESY = 151
    EVENTTRIGGER_PARTISANS = 152
    EVENTTRIGGER_NEW_DYNASTY = 153
    EVENTTRIGGER_CRISIS_IN_THE_SENATE = 154
    EVENTTRIGGER_TOO_CLOSE_TO_CALL = 155
    EVENTTRIGGER_CHARISMATIC = 156
    EVENTTRIGGER_FRIENDLY_LOCALS = 157
    EVENTTRIGGER_GREED = 158
    EVENTTRIGGER_GREED_DONE = 159
    EVENTTRIGGER_WAR_CHARIOTS = 160
    EVENTTRIGGER_WAR_CHARIOTS_DONE = 161
    EVENTTRIGGER_ELITE_SWORDS = 162
    EVENTTRIGGER_ELITE_SWORDS_DONE = 163
    EVENTTRIGGER_WARSHIPS = 164
    EVENTTRIGGER_WARSHIPS_DONE = 165
    EVENTTRIGGER_GUNS_BUTTER = 166
    EVENTTRIGGER_GUNS_BUTTER_DONE = 167
    EVENTTRIGGER_NOBLE_KNIGHTS = 168
    EVENTTRIGGER_NOBLE_KNIGHTS_DONE = 169
    EVENTTRIGGER_OVERWHELM = 170
    EVENTTRIGGER_OVERWHELM_DONE = 171
    EVENTTRIGGER_CORPORATE_EXPANSION = 172
    EVENTTRIGGER_CORPORATE_EXPANSION_DONE = 173
    EVENTTRIGGER_HOSTILE_TAKEOVER = 174
    EVENTTRIGGER_HOSTILE_TAKEOVER_DONE = 175
    EVENTTRIGGER_CIV_GAME = 176
    EVENTTRIGGER_SLAVE_REVOLT_WARNING = 177
    EVENTTRIGGER_IMMIGRANTS = 178
    EVENTTRIGGER_HEALING_PLANT = 179
    EVENTTRIGGER_GREAT_BEAST = 180
    EVENTTRIGGER_CONTROVERSIAL_PHILOSOPHER = 181
    EVENTTRIGGER_DEFECTING_AGENT = 182
    EVENTTRIGGER_JAIL = 183
    EVENTTRIGGER_SPY_DISCOVERED = 184
    EVENTTRIGGER_NUCLEAR_PROTEST = 185
    EVENTTRIGGER_BETTER_COAL = 186
    EVENTTRIGGER_BROKEN_DAM = 187
    EVENTTRIGGER_RABBI = 188
    EVENTTRIGGER_GOLDEN_BUDDHA = 189
    EVENTTRIGGER_PREACHING_RESEARCHER = 190
    EVENTTRIGGER_TOXCATL = 191
    EVENTTRIGGER_DISSIDENT_PRIEST = 192
    EVENTTRIGGER_PASTURE_BUILT = 193
    EVENTTRIGGER_ROGUE_STATION = 194
    EVENTTRIGGER_ANTIMONARCHISTS = 195
    EVENTTRIGGER_IMPEACHMENT = 196


class ClimateType(Enum):
    NO_CLIMATE = -1
    CLIMATE_TEMPERATE = 0
    CLIMATE_TROPICAL = 1
    CLIMATE_ARID = 2
    CLIMATE_ROCKY = 3
    CLIMATE_COLD = 4


class CivicType(Enum):
    NO_CIVIC = -1
    CIVIC_DESPOTISM = 0
    CIVIC_HEREDITARY_RULE = 1
    CIVIC_REPRESENTATION = 2
    CIVIC_POLICE_STATE = 3
    CIVIC_UNIVERSAL_SUFFRAGE = 4
    CIVIC_BARBARISM = 5
    CIVIC_VASSALAGE = 6
    CIVIC_BUREAUCRACY = 7
    CIVIC_NATIONHOOD = 8
    CIVIC_FREE_SPEECH = 9
    CIVIC_TRIBALISM = 10
    CIVIC_SLAVERY = 11
    CIVIC_SERFDOM = 12
    CIVIC_CASTE_SYSTEM = 13
    CIVIC_EMANCIPATION = 14
    CIVIC_DECENTRALIZATION = 15
    CIVIC_MERCANTILISM = 16
    CIVIC_FREE_MARKET = 17
    CIVIC_STATE_PROPERTY = 18
    CIVIC_ENVIRONMENTALISM = 19
    CIVIC_PAGANISM = 20
    CIVIC_ORGANIZED_RELIGION = 21
    CIVIC_THEOCRACY = 22
    CIVIC_PACIFISM = 23
    CIVIC_FREE_RELIGION = 24


class CommerceType(Enum):
    NO_COMMERCE = -1
    COMMERCE_GOLD = 0
    COMMERCE_RESEARCH = 1
    COMMERCE_CULTURE = 2
    COMMERCE_ESPIONAGE = 3


class CorporationType(Enum):
    NO_CORPORATION = -1
    CORPORATION_1 = 0
    CORPORATION_2 = 1
    CORPORATION_3 = 2
    CORPORATION_4 = 3
    CORPORATION_5 = 4
    CORPORATION_6 = 5
    CORPORATION_7 = 6


class CultureLevelType(Enum):
    NO_CULTURELEVEL = -1
    CULTURELEVEL_NONE = 0
    CULTURELEVEL_POOR = 1
    CULTURELEVEL_FLEDGLING = 2
    CULTURELEVEL_DEVELOPING = 3
    CULTURELEVEL_REFINED = 4
    CULTURELEVEL_INFLUENTIAL = 5
    CULTURELEVEL_LEGENDARY = 6


class DiploCommentType(Enum):
    NO_DIPLOCOMMENT = -1
    AI_DIPLOCOMMENT_DECLARE_WAR = 0
    AI_DIPLOCOMMENT_NO_VASSAL = 1
    AI_DIPLOCOMMENT_OFFER_VASSAL = 2
    AI_DIPLOCOMMENT_FIRST_CONTACT = 3
    AI_DIPLOCOMMENT_REFUSE_TO_TALK = 4
    AI_DIPLOCOMMENT_PEACE = 5
    AI_DIPLOCOMMENT_NO_PEACE = 6
    AI_DIPLOCOMMENT_GREETINGS = 7
    AI_DIPLOCOMMENT_TRADING = 8
    AI_DIPLOCOMMENT_ACCEPT = 9
    AI_DIPLOCOMMENT_REJECT = 10
    AI_DIPLOCOMMENT_GLAD = 11
    AI_DIPLOCOMMENT_SORRY = 12
    AI_DIPLOCOMMENT_TRY_THIS_DEAL = 13
    AI_DIPLOCOMMENT_NO_DEAL = 14
    AI_DIPLOCOMMENT_OFFER_PEACE = 15
    AI_DIPLOCOMMENT_OFFER_CITY = 16
    AI_DIPLOCOMMENT_OFFER_DEAL = 17
    AI_DIPLOCOMMENT_CANCEL_DEAL = 18
    AI_DIPLOCOMMENT_THANKS = 19
    AI_DIPLOCOMMENT_CURRENT_DEALS = 20
    AI_DIPLOCOMMENT_ACCEPT_ASK = 21
    AI_DIPLOCOMMENT_REJECT_ASK = 22
    AI_DIPLOCOMMENT_ACCEPT_DEMAND = 23
    AI_DIPLOCOMMENT_REJECT_DEMAND = 24
    AI_DIPLOCOMMENT_ACCEPT_DEMAND_TEAM = 25
    AI_DIPLOCOMMENT_GIVE_HELP = 26
    AI_DIPLOCOMMENT_ASK_FOR_HELP = 27
    AI_DIPLOCOMMENT_HELP_REFUSED = 28
    AI_DIPLOCOMMENT_DEMAND_TRIBUTE = 29
    AI_DIPLOCOMMENT_DEMAND_REJECTED = 30
    AI_DIPLOCOMMENT_RELIGION_PRESSURE = 31
    AI_DIPLOCOMMENT_RELIGION_DENIED = 32
    AI_DIPLOCOMMENT_CIVIC_PRESSURE = 33
    AI_DIPLOCOMMENT_CIVIC_DENIED = 34
    AI_DIPLOCOMMENT_JOIN_WAR = 35
    AI_DIPLOCOMMENT_JOIN_DENIED = 36
    AI_DIPLOCOMMENT_STOP_TRADING = 37
    AI_DIPLOCOMMENT_STOP_DENIED = 38
    AI_DIPLOCOMMENT_UNIT_BRAG = 39
    AI_DIPLOCOMMENT_NUKES = 40
    AI_DIPLOCOMMENT_WORST_ENEMY = 41
    AI_DIPLOCOMMENT_WORST_ENEMY_TRADING = 42
    AI_DIPLOCOMMENT_SOMETHING_ELSE = 43
    AI_DIPLOCOMMENT_RESEARCH = 44
    AI_DIPLOCOMMENT_RESEARCH_TECH = 45
    AI_DIPLOCOMMENT_ATTITUDE = 46
    AI_DIPLOCOMMENT_ATTITUDE_PLAYER_FURIOUS = 47
    AI_DIPLOCOMMENT_ATTITUDE_PLAYER_ANNOYED = 48
    AI_DIPLOCOMMENT_ATTITUDE_PLAYER_CAUTIOUS = 49
    AI_DIPLOCOMMENT_ATTITUDE_PLAYER_PLEASED = 50
    AI_DIPLOCOMMENT_ATTITUDE_PLAYER_FRIENDLY = 51
    AI_DIPLOCOMMENT_TARGET = 52
    AI_DIPLOCOMMENT_TARGET_CITY = 53
    AI_DIPLOCOMMENT_WELL = 54
    USER_DIPLOCOMMENT_WAR_RESPONSE = 55
    USER_DIPLOCOMMENT_PEACE = 56
    USER_DIPLOCOMMENT_WAR = 57
    USER_DIPLOCOMMENT_PROPOSE = 58
    USER_DIPLOCOMMENT_ACCEPT = 59
    USER_DIPLOCOMMENT_REJECT = 60
    USER_DIPLOCOMMENT_OFFER = 61
    USER_DIPLOCOMMENT_GIFT = 62
    USER_DIPLOCOMMENT_NEVERMIND = 63
    USER_DIPLOCOMMENT_PROPOSAL = 64
    USER_DIPLOCOMMENT_COMPLETE_DEAL = 65
    USER_DIPLOCOMMENT_FISH_FOR_DEAL = 66
    USER_DIPLOCOMMENT_SUGGEST_PEACE = 67
    USER_DIPLOCOMMENT_OFFER_PEACE = 68
    USER_DIPLOCOMMENT_CURRENT_DEALS = 69
    USER_DIPLOCOMMENT_ASK = 70
    USER_DIPLOCOMMENT_DEMAND = 71
    USER_DIPLOCOMMENT_VASSAL_TRIBUTE = 72
    USER_DIPLOCOMMENT_DEMAND_TEAM = 73
    USER_DIPLOCOMMENT_ACCEPT_OFFER = 74
    USER_DIPLOCOMMENT_REJECT_OFFER = 75
    USER_DIPLOCOMMENT_RENEGOTIATE = 76
    USER_DIPLOCOMMENT_NO_RENEGOTIATE = 77
    USER_DIPLOCOMMENT_GIVE_HELP = 78
    USER_DIPLOCOMMENT_REFUSE_HELP = 79
    USER_DIPLOCOMMENT_ACCEPT_DEMAND = 80
    USER_DIPLOCOMMENT_REJECT_DEMAND = 81
    USER_DIPLOCOMMENT_CONVERT = 82
    USER_DIPLOCOMMENT_NO_CONVERT = 83
    USER_DIPLOCOMMENT_REVOLUTION = 84
    USER_DIPLOCOMMENT_NO_REVOLUTION = 85
    USER_DIPLOCOMMENT_JOIN_WAR = 86
    USER_DIPLOCOMMENT_NO_JOIN_WAR = 87
    USER_DIPLOCOMMENT_STOP_TRADING = 88
    USER_DIPLOCOMMENT_NO_STOP_TRADING = 89
    USER_DIPLOCOMMENT_SOMETHING_ELSE = 90
    USER_DIPLOCOMMENT_RESEARCH = 91
    USER_DIPLOCOMMENT_RESEARCH_TECH = 92
    USER_DIPLOCOMMENT_ATTITUDE = 93
    USER_DIPLOCOMMENT_ATTITUDE_PLAYER = 94
    USER_DIPLOCOMMENT_TARGET = 95
    USER_DIPLOCOMMENT_TARGET_CITY = 96
    USER_DIPLOCOMMENT_EXIT = 97


class EraType(Enum):
    NO_ERA = -1
    ERA_ANCIENT = 0
    ERA_CLASSICAL = 1
    ERA_MEDIEVAL = 2
    ERA_RENAISSANCE = 3
    ERA_INDUSTRIAL = 4
    ERA_MODERN = 5
    ERA_FUTURE = 6


class EspionageMissionType(Enum):
    NO_ESPIONAGEMISSION = -1
    ESPIONAGEMISSION_SEE_DEMOGRAPHICS = 0
    ESPIONAGEMISSION_CITY_VISIBILITY = 1
    ESPIONAGEMISSION_INVESTIGATE_CITY = 2
    ESPIONAGEMISSION_SEE_RESEARCH = 3
    ESPIONAGEMISSION_NO_ACTIVE_MISSIONS = 4
    ESPIONAGEMISSION_DESTROY_IMPROVEMENT = 5
    ESPIONAGEMISSION_DESTROY_BUILDING = 6
    ESPIONAGEMISSION_DESTROY_PROJECT = 7
    ESPIONAGEMISSION_DESTROY_PRODUCTION = 8
    ESPIONAGEMISSION_STEAL_TREASURY = 9
    ESPIONAGEMISSION_CITY_INSERT_CULTURE = 10
    ESPIONAGEMISSION_CITY_POISON_WATER = 11
    ESPIONAGEMISSION_CITY_UNHAPPINESS = 12
    ESPIONAGEMISSION_CITY_REVOLT = 13
    ESPIONAGEMISSION_BUY_TECH = 14
    ESPIONAGEMISSION_SWITCH_CIVIC = 15
    ESPIONAGEMISSION_SWITCH_RELIGION = 16
    ESPIONAGEMISSION_COUNTERESPIONAGE = 17


class GameOptionType(Enum):
    NO_GAMEOPTION = -1
    GAMEOPTION_ADVANCED_START = 0
    GAMEOPTION_NO_CITY_RAZING = 1
    GAMEOPTION_NO_CITY_FLIPPING = 2
    GAMEOPTION_FLIPPING_AFTER_CONQUEST = 3
    GAMEOPTION_NO_BARBARIANS = 4
    GAMEOPTION_RAGING_BARBARIANS = 5
    GAMEOPTION_AGGRESSIVE_AI = 6
    GAMEOPTION_LEAD_ANY_CIV = 7
    GAMEOPTION_RANDOM_PERSONALITIES = 8
    GAMEOPTION_PICK_RELIGION = 9
    GAMEOPTION_NO_TECH_TRADING = 10
    GAMEOPTION_NO_TECH_BROKERING = 11
    GAMEOPTION_PERMANENT_ALLIANCES = 12
    GAMEOPTION_ALWAYS_WAR = 13
    GAMEOPTION_ALWAYS_PEACE = 14
    GAMEOPTION_ONE_CITY_CHALLENGE = 15
    GAMEOPTION_NO_CHANGING_WAR_PEACE = 16
    GAMEOPTION_NEW_RANDOM_SEED = 17
    GAMEOPTION_LOCK_MODS = 18
    GAMEOPTION_COMPLETE_KILLS = 19
    GAMEOPTION_NO_VASSAL_STATES = 20
    GAMEOPTION_NO_GOODY_HUTS = 21
    GAMEOPTION_NO_EVENTS = 22
    GAMEOPTION_NO_ESPIONAGE = 23


class GameSpeedType(Enum):
    NO_GAMESPEED = -1
    GAMESPEED_MARATHON = 0
    GAMESPEED_EPIC = 1
    GAMESPEED_NORMAL = 2
    GAMESPEED_QUICK = 3


class HandicapType(Enum):
    NO_HANDICAP = -1
    HANDICAP_SETTLER = 0
    HANDICAP_CHIEFTAIN = 1
    HANDICAP_WARLORD = 2
    HANDICAP_NOBLE = 3
    HANDICAP_PRINCE = 4
    HANDICAP_MONARCH = 5
    HANDICAP_EMPEROR = 6
    HANDICAP_IMMORTAL = 7
    HANDICAP_DEITY = 8


class MultiplayerOptionType(Enum):
    NO_MPOPTION = -1
    MPOPTION_SIMULTANEOUS_TURNS = 0
    MPOPTION_TAKEOVER_AI = 1
    MPOPTION_SHUFFLE_TEAMS = 2
    MPOPTION_ANONYMOUS = 3
    MPOPTION_TURN_TIMER = 4


class ProjectType(Enum):
    NO_PROJECT = -1
    PROJECT_MANHATTAN_PROJECT = 0
    PROJECT_THE_INTERNET = 1
    PROJECT_SDI = 2
    PROJECT_APOLLO_PROGRAM = 3
    PROJECT_SS_COCKPIT = 4
    PROJECT_SS_LIFE_SUPPORT = 5
    PROJECT_SS_STASIS_CHAMBER = 6
    PROJECT_SS_DOCKING_BAY = 7
    PROJECT_SS_ENGINE = 8
    PROJECT_SS_CASING = 9
    PROJECT_SS_THRUSTERS = 10


class ReligionType(Enum):
    NO_RELIGION = -1
    RELIGION_JUDAISM = 0
    RELIGION_CHRISTIANITY = 1
    RELIGION_ISLAM = 2
    RELIGION_HINDUISM = 3
    RELIGION_BUDDHISM = 4
    RELIGION_CONFUCIANISM = 5
    RELIGION_TAOISM = 6


class SeaLevelType(Enum):
    NO_SEALEVEL = -1
    SEALEVEL_LOW = 0
    SEALEVEL_MEDIUM = 1
    SEALEVEL_HIGH = 2


class SpecialistType(Enum):
    NO_SPECIALIST = -1
    SPECIALIST_CITIZEN = 0
    SPECIALIST_PRIEST = 1
    SPECIALIST_ARTIST = 2
    SPECIALIST_SCIENTIST = 3
    SPECIALIST_MERCHANT = 4
    SPECIALIST_ENGINEER = 5
    SPECIALIST_SPY = 6
    SPECIALIST_GREAT_PRIEST = 7
    SPECIALIST_GREAT_ARTIST = 8
    SPECIALIST_GREAT_SCIENTIST = 9
    SPECIALIST_GREAT_MERCHANT = 10
    SPECIALIST_GREAT_ENGINEER = 11
    SPECIALIST_GREAT_GENERAL = 12
    SPECIALIST_GREAT_SPY = 13


class VictoryType(Enum):
    NO_VICTORY = -1
    VICTORY_SCORE = 0
    VICTORY_TIME = 1
    VICTORY_CONQUEST = 2
    VICTORY_DOMINATION = 3
    VICTORY_CULTURAL = 4
    VICTORY_SPACE_RACE = 5
    VICTORY_DIPLOMATIC = 6


class VoteType(Enum):
    NO_VOTE = -1
    VOTE_SECRETARY_GENERAL = 0
    VOTE_VICTORY = 1
    VOTE_SINGLE_CURRENCY = 2
    VOTE_FREE_TRADE = 3
    VOTE_NO_NUKES = 4
    VOTE_UNIVERSAL_SUFFRAGE = 5
    VOTE_FREE_SPEECH = 6
    VOTE_EMANCIPATION = 7
    VOTE_ENVIRONMENTALISM = 8
    VOTE_FREE_RELIGION = 9
    VOTE_UN_FORCE_PEACE = 10
    VOTE_UN_FORCE_NO_TRADE = 11
    VOTE_UN_FORCE_WAR = 12
    VOTE_UN_ASSIGN_CITY = 13
    VOTE_POPE = 14
    VOTE_RELIGIOUS_VICTORY = 15
    VOTE_OPEN_BORDERS = 16
    VOTE_DEFENSIVE_PACT = 17
    VOTE_FORCE_PEACE = 18
    VOTE_FORCE_NO_TRADE = 19
    VOTE_FORCE_WAR = 20
    VOTE_ASSIGN_CITY = 21


class VoteSourceType(Enum):
    NO_VOTESOURCE = -1
    DIPLOVOTE_UN = 0
    DIPLOVOTE_POPE = 1


class WorldSizeType(Enum):
    NO_WORLDSIZE = -1
    WORLDSIZE_DUEL = 0
    WORLDSIZE_TINY = 1
    WORLDSIZE_SMALL = 2
    WORLDSIZE_STANDARD = 3
    WORLDSIZE_LARGE = 4
    WORLDSIZE_HUGE = 5


class BuildType(Enum):
    NO_BUILD = -1
    BUILD_ROAD = 0
    BUILD_RAILROAD = 1
    BUILD_FARM = 2
    BUILD_FISHING_BOATS = 3
    BUILD_WHALING_BOATS = 4
    BUILD_MINE = 5
    BUILD_WORKSHOP = 6
    BUILD_LUMBERMILL = 7
    BUILD_WINDMILL = 8
    BUILD_WATERMILL = 9
    BUILD_PLANTATION = 10
    BUILD_QUARRY = 11
    BUILD_PASTURE = 12
    BUILD_CAMP = 13
    BUILD_WELL = 14
    BUILD_OFFSHORE_PLATFORM = 15
    BUILD_WINERY = 16
    BUILD_COTTAGE = 17
    BUILD_FORT = 18
    BUILD_REMOVE_JUNGLE = 19
    BUILD_REMOVE_FOREST = 20
    BUILD_SCRUB_FALLOUT = 21
    BUILD_FOREST_PRESERVE = 22


class MissionType(Enum):
    NO_MISSION = -1
    MISSION_MOVE_TO = 0
    MISSION_ROUTE_TO = 1
    MISSION_MOVE_TO_UNIT = 2
    MISSION_SKIP = 3
    MISSION_SLEEP = 4
    MISSION_FORTIFY = 5
    MISSION_PLUNDER = 6
    MISSION_AIRPATROL = 7
    MISSION_SEAPATROL = 8
    MISSION_HEAL = 9
    MISSION_SENTRY = 10
    MISSION_AIRLIFT = 11
    MISSION_NUKE = 12
    MISSION_RECON = 13
    MISSION_PARADROP = 14
    MISSION_AIRBOMB = 15
    MISSION_RANGE_ATTACK = 16
    MISSION_BOMBARD = 17
    MISSION_PILLAGE = 18
    MISSION_SABOTAGE = 19
    MISSION_DESTROY = 20
    MISSION_STEAL_PLANS = 21
    MISSION_FOUND = 22
    MISSION_SPREAD = 23
    MISSION_SPREAD_CORPORATION = 24
    MISSION_JOIN = 25
    MISSION_CONSTRUCT = 26
    MISSION_DISCOVER = 27
    MISSION_HURRY = 28
    MISSION_TRADE = 29
    MISSION_GREAT_WORK = 30
    MISSION_INFILTRATE = 31
    MISSION_GOLDEN_AGE = 32
    MISSION_BUILD = 33
    MISSION_LEAD = 34
    MISSION_ESPIONAGE = 35
    MISSION_DIE_ANIMATION = 36
    MISSION_BEGIN_COMBAT = 37
    MISSION_END_COMBAT = 38
    MISSION_AIRSTRIKE = 39
    MISSION_SURRENDER = 40
    MISSION_CAPTURED = 41
    MISSION_IDLE = 42
    MISSION_DIE = 43
    MISSION_DAMAGE = 44
    MISSION_MULTI_SELECT = 45
    MISSION_MULTI_DESELECT = 46


class PromotionType(Enum):
    NO_PROMOTION = -1
    PROMOTION_COMBAT1 = 0
    PROMOTION_COMBAT2 = 1
    PROMOTION_COMBAT3 = 2
    PROMOTION_COMBAT4 = 3
    PROMOTION_COMBAT5 = 4
    PROMOTION_COVER = 5
    PROMOTION_SHOCK = 6
    PROMOTION_PINCH = 7
    PROMOTION_FORMATION = 8
    PROMOTION_CHARGE = 9
    PROMOTION_AMBUSH = 10
    PROMOTION_AMPHIBIOUS = 11
    PROMOTION_MARCH = 12
    PROMOTION_BLITZ = 13
    PROMOTION_COMMANDO = 14
    PROMOTION_MEDIC1 = 15
    PROMOTION_MEDIC2 = 16
    PROMOTION_GUERILLA1 = 17
    PROMOTION_GUERILLA2 = 18
    PROMOTION_GUERILLA3 = 19
    PROMOTION_WOODSMAN1 = 20
    PROMOTION_WOODSMAN2 = 21
    PROMOTION_WOODSMAN3 = 22
    PROMOTION_CITY_RAIDER1 = 23
    PROMOTION_CITY_RAIDER2 = 24
    PROMOTION_CITY_RAIDER3 = 25
    PROMOTION_CITY_GARRISON1 = 26
    PROMOTION_CITY_GARRISON2 = 27
    PROMOTION_CITY_GARRISON3 = 28
    PROMOTION_DRILL1 = 29
    PROMOTION_DRILL2 = 30
    PROMOTION_DRILL3 = 31
    PROMOTION_DRILL4 = 32
    PROMOTION_BARRAGE1 = 33
    PROMOTION_BARRAGE2 = 34
    PROMOTION_BARRAGE3 = 35
    PROMOTION_ACCURACY = 36
    PROMOTION_FLANKING1 = 37
    PROMOTION_FLANKING2 = 38
    PROMOTION_SENTRY = 39
    PROMOTION_MOBILITY = 40
    PROMOTION_NAVIGATION1 = 41
    PROMOTION_NAVIGATION2 = 42
    PROMOTION_LEADER = 43
    PROMOTION_LEADERSHIP = 44
    PROMOTION_TACTICS = 45
    PROMOTION_COMBAT6 = 46
    PROMOTION_MORALE = 47
    PROMOTION_MEDIC3 = 48
    PROMOTION_RANGE1 = 49
    PROMOTION_RANGE2 = 50
    PROMOTION_INTERCEPTION1 = 51
    PROMOTION_INTERCEPTION2 = 52
    PROMOTION_ACE = 53


class SpecialUnitType(Enum):
    NO_SPECIALUNIT = -1
    SPECIALUNIT_FIGHTER = 0
    SPECIALUNIT_PEOPLE = 1
    SPECIALUNIT_MISSILE = 2


class UnitType(Enum):
    NO_UNIT = -1
    UNIT_LION = 0
    UNIT_BEAR = 1
    UNIT_PANTHER = 2
    UNIT_WOLF = 3
    UNIT_SETTLER = 4
    UNIT_WORKER = 5
    UNIT_INDIAN_FAST_WORKER = 6
    UNIT_SCOUT = 7
    UNIT_EXPLORER = 8
    UNIT_SPY = 9
    UNIT_EXECUTIVE_1 = 10
    UNIT_EXECUTIVE_2 = 11
    UNIT_EXECUTIVE_3 = 12
    UNIT_EXECUTIVE_4 = 13
    UNIT_EXECUTIVE_5 = 14
    UNIT_EXECUTIVE_6 = 15
    UNIT_EXECUTIVE_7 = 16
    UNIT_JEWISH_MISSIONARY = 17
    UNIT_CHRISTIAN_MISSIONARY = 18
    UNIT_ISLAMIC_MISSIONARY = 19
    UNIT_HINDU_MISSIONARY = 20
    UNIT_BUDDHIST_MISSIONARY = 21
    UNIT_CONFUCIAN_MISSIONARY = 22
    UNIT_TAOIST_MISSIONARY = 23
    UNIT_WARRIOR = 24
    UNIT_INCAN_QUECHUA = 25
    UNIT_SWORDSMAN = 26
    UNIT_AZTEC_JAGUAR = 27
    UNIT_CELTIC_GALLIC_WARRIOR = 28
    UNIT_ROME_PRAETORIAN = 29
    UNIT_AXEMAN = 30
    UNIT_GREEK_PHALANX = 31
    UNIT_SUMERIAN_VULTURE = 32
    UNIT_NATIVE_AMERICA_DOG_SOLDIER = 33
    UNIT_MACEMAN = 34
    UNIT_JAPAN_SAMURAI = 35
    UNIT_VIKING_BESERKER = 36
    UNIT_SPEARMAN = 37
    UNIT_ZULU_IMPI = 38
    UNIT_MAYA_HOLKAN = 39
    UNIT_PIKEMAN = 40
    UNIT_HOLY_ROMAN_LANDSKNECHT = 41
    UNIT_MUSKETMAN = 42
    UNIT_FRENCH_MUSKETEER = 43
    UNIT_OTTOMAN_JANISSARY = 44
    UNIT_ETHIOPIAN_OROMO_WARRIOR = 45
    UNIT_RIFLEMAN = 46
    UNIT_ENGLISH_REDCOAT = 47
    UNIT_GRENADIER = 48
    UNIT_AT_INFANTRY = 49
    UNIT_INFANTRY = 50
    UNIT_SAM_INFANTRY = 51
    UNIT_MOBILE_SAM = 52
    UNIT_MARINE = 53
    UNIT_AMERICAN_NAVY_SEAL = 54
    UNIT_PARATROOPER = 55
    UNIT_MECHANIZED_INFANTRY = 56
    UNIT_ARCHER = 57
    UNIT_MALI_SKIRMISHER = 58
    UNIT_BABYLON_BOWMAN = 59
    UNIT_LONGBOWMAN = 60
    UNIT_CROSSBOWMAN = 61
    UNIT_CHINA_CHOKONU = 62
    UNIT_CHARIOT = 63
    UNIT_EGYPT_WARCHARIOT = 64
    UNIT_PERSIA_IMMORTAL = 65
    UNIT_HORSE_ARCHER = 66
    UNIT_CARTHAGE_NUMIDIAN_CAVALRY = 67
    UNIT_MONGOL_KESHIK = 68
    UNIT_KNIGHT = 69
    UNIT_ARABIA_CAMELARCHER = 70
    UNIT_BYZANTINE_CATAPHRACT = 71
    UNIT_SPANISH_CONQUISTADOR = 72
    UNIT_CUIRASSIER = 73
    UNIT_CAVALRY = 74
    UNIT_RUSSIA_COSSACK = 75
    UNIT_WAR_ELEPHANT = 76
    UNIT_KHMER_BALLISTA_ELEPHANT = 77
    UNIT_TANK = 78
    UNIT_GERMAN_PANZER = 79
    UNIT_MODERN_ARMOR = 80
    UNIT_GUNSHIP = 81
    UNIT_CATAPULT = 82
    UNIT_KOREAN_HWACHA = 83
    UNIT_TREBUCHET = 84
    UNIT_CANNON = 85
    UNIT_MACHINE_GUN = 86
    UNIT_ARTILLERY = 87
    UNIT_MOBILE_ARTILLERY = 88
    UNIT_WORKBOAT = 89
    UNIT_GALLEY = 90
    UNIT_TRIREME = 91
    UNIT_CARAVEL = 92
    UNIT_PORTUGAL_CARRACK = 93
    UNIT_GALLEON = 94
    UNIT_NETHERLANDS_OOSTINDIEVAARDER = 95
    UNIT_PRIVATEER = 96
    UNIT_FRIGATE = 97
    UNIT_SHIP_OF_THE_LINE = 98
    UNIT_IRONCLAD = 99
    UNIT_TRANSPORT = 100
    UNIT_DESTROYER = 101
    UNIT_BATTLESHIP = 102
    UNIT_MISSILE_CRUISER = 103
    UNIT_STEALTH_DESTROYER = 104
    UNIT_SUBMARINE = 105
    UNIT_ATTACK_SUBMARINE = 106
    UNIT_CARRIER = 107
    UNIT_AIRSHIP = 108
    UNIT_FIGHTER = 109
    UNIT_JET_FIGHTER = 110
    UNIT_BOMBER = 111
    UNIT_STEALTH_BOMBER = 112
    UNIT_GUIDED_MISSILE = 113
    UNIT_TACTICAL_NUKE = 114
    UNIT_ICBM = 115
    UNIT_PROPHET = 116
    UNIT_ARTIST = 117
    UNIT_SCIENTIST = 118
    UNIT_MERCHANT = 119
    UNIT_ENGINEER = 120
    UNIT_GREAT_GENERAL = 121
    UNIT_GREAT_SPY = 122


class UnitClassType(Enum):
    NO_UNITCLASS = -1
    UNITCLASS_LION = 0
    UNITCLASS_BEAR = 1
    UNITCLASS_PANTHER = 2
    UNITCLASS_WOLF = 3
    UNITCLASS_SETTLER = 4
    UNITCLASS_WORKER = 5
    UNITCLASS_SCOUT = 6
    UNITCLASS_EXPLORER = 7
    UNITCLASS_SPY = 8
    UNITCLASS_EXECUTIVE_1 = 9
    UNITCLASS_EXECUTIVE_2 = 10
    UNITCLASS_EXECUTIVE_3 = 11
    UNITCLASS_EXECUTIVE_4 = 12
    UNITCLASS_EXECUTIVE_5 = 13
    UNITCLASS_EXECUTIVE_6 = 14
    UNITCLASS_EXECUTIVE_7 = 15
    UNITCLASS_JEWISH_MISSIONARY = 16
    UNITCLASS_CHRISTIAN_MISSIONARY = 17
    UNITCLASS_ISLAMIC_MISSIONARY = 18
    UNITCLASS_HINDU_MISSIONARY = 19
    UNITCLASS_BUDDHIST_MISSIONARY = 20
    UNITCLASS_CONFUCIAN_MISSIONARY = 21
    UNITCLASS_TAOIST_MISSIONARY = 22
    UNITCLASS_WARRIOR = 23
    UNITCLASS_SWORDSMAN = 24
    UNITCLASS_AXEMAN = 25
    UNITCLASS_MACEMAN = 26
    UNITCLASS_SPEARMAN = 27
    UNITCLASS_PIKEMAN = 28
    UNITCLASS_MUSKETMAN = 29
    UNITCLASS_RIFLEMAN = 30
    UNITCLASS_GRENADIER = 31
    UNITCLASS_INFANTRY = 32
    UNITCLASS_AT_INFANTRY = 33
    UNITCLASS_SAM_INFANTRY = 34
    UNITCLASS_MOBILE_SAM = 35
    UNITCLASS_MARINE = 36
    UNITCLASS_PARATROOPER = 37
    UNITCLASS_MECHANIZED_INFANTRY = 38
    UNITCLASS_ARCHER = 39
    UNITCLASS_LONGBOWMAN = 40
    UNITCLASS_CROSSBOWMAN = 41
    UNITCLASS_CHARIOT = 42
    UNITCLASS_HORSE_ARCHER = 43
    UNITCLASS_KNIGHT = 44
    UNITCLASS_CUIRASSIER = 45
    UNITCLASS_CAVALRY = 46
    UNITCLASS_WAR_ELEPHANT = 47
    UNITCLASS_TANK = 48
    UNITCLASS_MODERN_ARMOR = 49
    UNITCLASS_GUNSHIP = 50
    UNITCLASS_CATAPULT = 51
    UNITCLASS_TREBUCHET = 52
    UNITCLASS_CANNON = 53
    UNITCLASS_MACHINE_GUN = 54
    UNITCLASS_ARTILLERY = 55
    UNITCLASS_MOBILE_ARTILLERY = 56
    UNITCLASS_WORKBOAT = 57
    UNITCLASS_GALLEY = 58
    UNITCLASS_TRIREME = 59
    UNITCLASS_CARAVEL = 60
    UNITCLASS_GALLEON = 61
    UNITCLASS_PRIVATEER = 62
    UNITCLASS_FRIGATE = 63
    UNITCLASS_SHIP_OF_THE_LINE = 64
    UNITCLASS_IRONCLAD = 65
    UNITCLASS_TRANSPORT = 66
    UNITCLASS_DESTROYER = 67
    UNITCLASS_STEALTH_DESTROYER = 68
    UNITCLASS_BATTLESHIP = 69
    UNITCLASS_MISSILE_CRUISER = 70
    UNITCLASS_SUBMARINE = 71
    UNITCLASS_ATTACK_SUBMARINE = 72
    UNITCLASS_CARRIER = 73
    UNITCLASS_AIRSHIP = 74
    UNITCLASS_FIGHTER = 75
    UNITCLASS_JET_FIGHTER = 76
    UNITCLASS_BOMBER = 77
    UNITCLASS_STEALTH_BOMBER = 78
    UNITCLASS_GUIDED_MISSILE = 79
    UNITCLASS_ICBM = 80
    UNITCLASS_TACTICAL_NUKE = 81
    UNITCLASS_PROPHET = 82
    UNITCLASS_ARTIST = 83
    UNITCLASS_SCIENTIST = 84
    UNITCLASS_MERCHANT = 85
    UNITCLASS_ENGINEER = 86
    UNITCLASS_GREAT_GENERAL = 87
    UNITCLASS_GREAT_SPY = 88


class BonusType(Enum):
    NO_BONUS = -1
    BONUS_ALUMINUM = 0
    BONUS_COAL = 1
    BONUS_COPPER = 2
    BONUS_HORSE = 3
    BONUS_IRON = 4
    BONUS_MARBLE = 5
    BONUS_OIL = 6
    BONUS_STONE = 7
    BONUS_URANIUM = 8
    BONUS_BANANA = 9
    BONUS_CLAM = 10
    BONUS_CORN = 11
    BONUS_COW = 12
    BONUS_CRAB = 13
    BONUS_DEER = 14
    BONUS_FISH = 15
    BONUS_PIG = 16
    BONUS_RICE = 17
    BONUS_SHEEP = 18
    BONUS_WHEAT = 19
    BONUS_DYE = 20
    BONUS_FUR = 21
    BONUS_GEMS = 22
    BONUS_GOLD = 23
    BONUS_INCENSE = 24
    BONUS_IVORY = 25
    BONUS_SILK = 26
    BONUS_SILVER = 27
    BONUS_SPICES = 28
    BONUS_SUGAR = 29
    BONUS_WINE = 30
    BONUS_WHALE = 31
    BONUS_DRAMA = 32
    BONUS_MUSIC = 33
    BONUS_MOVIES = 34


class FeatureType(Enum):
    NO_FEATURE = -1
    FEATURE_ICE = 0
    FEATURE_JUNGLE = 1
    FEATURE_OASIS = 2
    FEATURE_FLOOD_PLAINS = 3
    FEATURE_FOREST = 4
    FEATURE_FALLOUT = 5


class ImprovementType(Enum):
    NO_IMPROVEMENT = -1
    IMPROVEMENT_LAND_WORKED = 0
    IMPROVEMENT_WATER_WORKED = 1
    IMPROVEMENT_CITY_RUINS = 2
    IMPROVEMENT_GOODY_HUT = 3
    IMPROVEMENT_FARM = 4
    IMPROVEMENT_FISHING_BOATS = 5
    IMPROVEMENT_WHALING_BOATS = 6
    IMPROVEMENT_MINE = 7
    IMPROVEMENT_WORKSHOP = 8
    IMPROVEMENT_LUMBERMILL = 9
    IMPROVEMENT_WINDMILL = 10
    IMPROVEMENT_WATERMILL = 11
    IMPROVEMENT_PLANTATION = 12
    IMPROVEMENT_QUARRY = 13
    IMPROVEMENT_PASTURE = 14
    IMPROVEMENT_CAMP = 15
    IMPROVEMENT_WELL = 16
    IMPROVEMENT_OFFSHORE_PLATFORM = 17
    IMPROVEMENT_WINERY = 18
    IMPROVEMENT_COTTAGE = 19
    IMPROVEMENT_HAMLET = 20
    IMPROVEMENT_VILLAGE = 21
    IMPROVEMENT_TOWN = 22
    IMPROVEMENT_FORT = 23
    IMPROVEMENT_FOREST_PRESERVE = 24


class TerrainType(Enum):
    NO_TERRAIN = -1
    TERRAIN_GRASS = 0
    TERRAIN_PLAINS = 1
    TERRAIN_DESERT = 2
    TERRAIN_TUNDRA = 3
    TERRAIN_SNOW = 4
    TERRAIN_COAST = 5
    TERRAIN_OCEAN = 6
    TERRAIN_PEAK = 7
    TERRAIN_HILL = 8
