# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UserUpdateRequest(Model):
    """Request to update an existing user.

    All required parameters must be populated in order to send to Azure.

    :param first_name: Required. The user's first name
    :type first_name: str
    :param last_name: Required. The user's last name
    :type last_name: str
    :param email: Required. User's email
    :type email: str
    :param phone_number: User's phone number, formatted as (###) ###-####
    :type phone_number: str
    :param phone_confirmation_code: Confirmation code from text message sent
     to user's phone. Must be included if changing a user's PhoneNumber
    :type phone_confirmation_code: str
    :param is_approved: Required. If the user is approved to access
     SmartDiagnostics or not. Requester must be a corporation or
     location level admin to edit.
    :type is_approved: bool
    :param application_role_code: Required. The user's role. Must be one of
     the following:
     - ApplicationUser
     - SaasAdmin (Requester must be Saas)
     - Sales (Requester must be at least Sales)
     - Sentry (Requester must be at least Sentry). Possible values include:
     'Invalid', 'SaasAdmin', 'AccountAdmin', 'ApplicationUser', 'Technician',
     'User', 'SystemProcess', 'Sentry', 'Sales', 'CorporationAdmin',
     'CorporationUser', 'CorporationNone'
    :type application_role_code: str or ~smartdiagnostics_sdk.models.enum
    :param corporations: The corporations the user belongs to. Saas users
     should not belong to any corporations
    :type corporations:
     list[~smartdiagnostics_sdk.models.UserRequestCorporationChild]
    :param locations: The locations the user belongs to. Saas users should not
     belong to any locations
    :type locations:
     list[~smartdiagnostics_sdk.models.UserRequestLocationChild]
    """

    _validation = {
        'first_name': {'required': True, 'max_length': 100, 'min_length': 1},
        'last_name': {'required': True, 'max_length': 100, 'min_length': 1},
        'email': {'required': True, 'max_length': 256},
        'phone_number': {'pattern': r'\(\d{3}\)\s\d{3}-\d{4}'},
        'is_approved': {'required': True},
        'application_role_code': {'required': True},
    }

    _attribute_map = {
        'first_name': {'key': 'FirstName', 'type': 'str'},
        'last_name': {'key': 'LastName', 'type': 'str'},
        'email': {'key': 'Email', 'type': 'str'},
        'phone_number': {'key': 'PhoneNumber', 'type': 'str'},
        'phone_confirmation_code': {'key': 'PhoneConfirmationCode', 'type': 'str'},
        'is_approved': {'key': 'IsApproved', 'type': 'bool'},
        'application_role_code': {'key': 'ApplicationRoleCode', 'type': 'str'},
        'corporations': {'key': 'Corporations', 'type': '[UserRequestCorporationChild]'},
        'locations': {'key': 'Locations', 'type': '[UserRequestLocationChild]'},
    }

    def __init__(self, **kwargs):
        super(UserUpdateRequest, self).__init__(**kwargs)
        self.first_name = kwargs.get('first_name', None)
        self.last_name = kwargs.get('last_name', None)
        self.email = kwargs.get('email', None)
        self.phone_number = kwargs.get('phone_number', None)
        self.phone_confirmation_code = kwargs.get('phone_confirmation_code', None)
        self.is_approved = kwargs.get('is_approved', None)
        self.application_role_code = kwargs.get('application_role_code', None)
        self.corporations = kwargs.get('corporations', None)
        self.locations = kwargs.get('locations', None)
