# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UserResponse(Model):
    """UserResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param first_name: Required.
    :type first_name: str
    :param last_name: Required.
    :type last_name: str
    :param email: Required.
    :type email: str
    :param phone_number:
    :type phone_number: str
    :param application_role_code: Required. Possible values include:
     'Invalid', 'SaasAdmin', 'AccountAdmin', 'ApplicationUser', 'Technician',
     'User', 'SystemProcess', 'Sentry', 'Sales', 'CorporationAdmin',
     'CorporationUser', 'CorporationNone'
    :type application_role_code: str or ~smartdiagnostics_sdk.models.enum
    :param is_approved: Required.
    :type is_approved: bool
    :param accepted_eula: Required.
    :type accepted_eula: bool
    :param last_login:
    :type last_login: datetime
    :param locked_out: Required. This is only relevant to non-SSO users, even
     if it is {true}
    :type locked_out: bool
    :param corporations: Required.
    :type corporations:
     list[~smartdiagnostics_sdk.models.UserCorporationChild]
    :param locations: Required.
    :type locations: list[~smartdiagnostics_sdk.models.UserLocationChild]
    """

    _validation = {
        'id': {'required': True},
        'first_name': {'required': True},
        'last_name': {'required': True},
        'email': {'required': True},
        'application_role_code': {'required': True},
        'is_approved': {'required': True},
        'accepted_eula': {'required': True},
        'locked_out': {'required': True},
        'corporations': {'required': True},
        'locations': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'first_name': {'key': 'FirstName', 'type': 'str'},
        'last_name': {'key': 'LastName', 'type': 'str'},
        'email': {'key': 'Email', 'type': 'str'},
        'phone_number': {'key': 'PhoneNumber', 'type': 'str'},
        'application_role_code': {'key': 'ApplicationRoleCode', 'type': 'str'},
        'is_approved': {'key': 'IsApproved', 'type': 'bool'},
        'accepted_eula': {'key': 'AcceptedEula', 'type': 'bool'},
        'last_login': {'key': 'LastLogin', 'type': 'iso-8601'},
        'locked_out': {'key': 'LockedOut', 'type': 'bool'},
        'corporations': {'key': 'Corporations', 'type': '[UserCorporationChild]'},
        'locations': {'key': 'Locations', 'type': '[UserLocationChild]'},
    }

    def __init__(self, **kwargs):
        super(UserResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.first_name = kwargs.get('first_name', None)
        self.last_name = kwargs.get('last_name', None)
        self.email = kwargs.get('email', None)
        self.phone_number = kwargs.get('phone_number', None)
        self.application_role_code = kwargs.get('application_role_code', None)
        self.is_approved = kwargs.get('is_approved', None)
        self.accepted_eula = kwargs.get('accepted_eula', None)
        self.last_login = kwargs.get('last_login', None)
        self.locked_out = kwargs.get('locked_out', None)
        self.corporations = kwargs.get('corporations', None)
        self.locations = kwargs.get('locations', None)
