# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class StatisticsReportRequest(Model):
    """StatisticsReportRequest.

    All required parameters must be populated in order to send to Azure.

    :param include_percent_time_in_alarm: Whether or not to include percent
     time in alarm in the calculations
    :type include_percent_time_in_alarm: bool
    :param include_percent_time_in_warning: Whether or not to include percent
     time in warning in the calculations
    :type include_percent_time_in_warning: bool
    :param include_percent_on_time: Whether or not to include percent on time
     in the calculations
    :type include_percent_on_time: bool
    :param include_seconds_in_alarm: Whether or not to include time in alarm
     in the calculations
    :type include_seconds_in_alarm: bool
    :param include_average_value: Whether or not to include the average value
     in the calculations
    :type include_average_value: bool
    :param include_max_value: Whether or not to include the max value in the
     calculations
    :type include_max_value: bool
    :param filter_id: The filter to use. Optional
    :type filter_id: str
    :param start_date: Required. The start date of the time range to get the
     report for. Nullable so Required can catch nulls, will not
     be null later.
    :type start_date: datetime
    :param end_date: Required. The end date of the time range to get the
     values for. Nullable so Required can catch nulls, will not
     be null later.
    :type end_date: datetime
    :param file_name: Required. The filename to use for the report
    :type file_name: str
    """

    _validation = {
        'start_date': {'required': True},
        'end_date': {'required': True},
        'file_name': {'required': True},
    }

    _attribute_map = {
        'include_percent_time_in_alarm': {'key': 'IncludePercentTimeInAlarm', 'type': 'bool'},
        'include_percent_time_in_warning': {'key': 'IncludePercentTimeInWarning', 'type': 'bool'},
        'include_percent_on_time': {'key': 'IncludePercentOnTime', 'type': 'bool'},
        'include_seconds_in_alarm': {'key': 'IncludeSecondsInAlarm', 'type': 'bool'},
        'include_average_value': {'key': 'IncludeAverageValue', 'type': 'bool'},
        'include_max_value': {'key': 'IncludeMaxValue', 'type': 'bool'},
        'filter_id': {'key': 'FilterId', 'type': 'str'},
        'start_date': {'key': 'StartDate', 'type': 'iso-8601'},
        'end_date': {'key': 'EndDate', 'type': 'iso-8601'},
        'file_name': {'key': 'FileName', 'type': 'str'},
    }

    def __init__(self, *, start_date, end_date, file_name: str, include_percent_time_in_alarm: bool=None, include_percent_time_in_warning: bool=None, include_percent_on_time: bool=None, include_seconds_in_alarm: bool=None, include_average_value: bool=None, include_max_value: bool=None, filter_id: str=None, **kwargs) -> None:
        super(StatisticsReportRequest, self).__init__(**kwargs)
        self.include_percent_time_in_alarm = include_percent_time_in_alarm
        self.include_percent_time_in_warning = include_percent_time_in_warning
        self.include_percent_on_time = include_percent_on_time
        self.include_seconds_in_alarm = include_seconds_in_alarm
        self.include_average_value = include_average_value
        self.include_max_value = include_max_value
        self.filter_id = filter_id
        self.start_date = start_date
        self.end_date = end_date
        self.file_name = file_name
