# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ActivityEventDetailResponse(Model):
    """ActivityEventDetailResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Activity event id
    :type id: str
    :param title: Required. The title of activity event
    :type title: str
    :param description: The description of what occurred during the activity
     event.
    :type description: str
    :param note: Note for activity event
    :type note: str
    :param start_date_time: Required. Activity event start date / time
    :type start_date_time: datetime
    :param end_date_time: Activity event end date / time (if available)
    :type end_date_time: datetime
    :param document:
    :type document: ~smartdiagnostics_sdk.models.DocumentChild
    :param category: Required.
    :type category: ~smartdiagnostics_sdk.models.ActivityEventCategoryChild
    :param subcategories: List of subcategories
    :type subcategories:
     list[~smartdiagnostics_sdk.models.ActivityEventSubcategoryChild]
    :param binds: List of binds (entity associations)
    :type binds: list[~smartdiagnostics_sdk.models.ActivityEventBindChild]
    :param fields: List of field / field entries
    :type fields:
     list[~smartdiagnostics_sdk.models.ActivityEventFieldEntryChild]
    :param assignments: List of assignments (created, updated)
    :type assignments:
     list[~smartdiagnostics_sdk.models.ActivityEventAssignmentChild]
    """

    _validation = {
        'id': {'required': True},
        'title': {'required': True},
        'start_date_time': {'required': True},
        'category': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'title': {'key': 'Title', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'note': {'key': 'Note', 'type': 'str'},
        'start_date_time': {'key': 'StartDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'EndDateTime', 'type': 'iso-8601'},
        'document': {'key': 'Document', 'type': 'DocumentChild'},
        'category': {'key': 'Category', 'type': 'ActivityEventCategoryChild'},
        'subcategories': {'key': 'Subcategories', 'type': '[ActivityEventSubcategoryChild]'},
        'binds': {'key': 'Binds', 'type': '[ActivityEventBindChild]'},
        'fields': {'key': 'Fields', 'type': '[ActivityEventFieldEntryChild]'},
        'assignments': {'key': 'Assignments', 'type': '[ActivityEventAssignmentChild]'},
    }

    def __init__(self, *, id: str, title: str, start_date_time, category, description: str=None, note: str=None, end_date_time=None, document=None, subcategories=None, binds=None, fields=None, assignments=None, **kwargs) -> None:
        super(ActivityEventDetailResponse, self).__init__(**kwargs)
        self.id = id
        self.title = title
        self.description = description
        self.note = note
        self.start_date_time = start_date_time
        self.end_date_time = end_date_time
        self.document = document
        self.category = category
        self.subcategories = subcategories
        self.binds = binds
        self.fields = fields
        self.assignments = assignments
