# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ActivityEventCreateRequest(Model):
    """ActivityEventCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param location_id: Required. Location of the activity event.
    :type location_id: str
    :param category_id: Activity Event category id
     <remarks>
     Use either a CategoryId or CategoryCode, not both. One is required.
     </remarks>
    :type category_id: int
    :param category_code: Activity Event category code. Will be used to lookup
     the category instead of id.
     Some examples of category codes:
     <list type="bullet">
     ** <item><description>fault</description></item>
     ** <item><description>correctivemaintenance</description></item>
     ** <item><description>machineiq.fault</description></item></list><remarks>
     Use either a CategoryId or CategoryCode, not both. One is required.
     </remarks>
    :type category_code: str
    :param title: Required. Activity event title
    :type title: str
    :param description:
    :type description: str
    :param note:
    :type note: str
    :param start_date_time:
    :type start_date_time: datetime
    :param end_date_time:
    :type end_date_time: datetime
    :param document:
    :type document: ~smartdiagnostics_sdk.models.ActivityEventDocumentRequest
    :param subcategories:
    :type subcategories:
     list[~smartdiagnostics_sdk.models.ActivityEventSubcategoryEntryRequest]
    :param binds:
    :type binds: list[~smartdiagnostics_sdk.models.ActivityEventBindRequest]
    :param fields:
    :type fields:
     list[~smartdiagnostics_sdk.models.ActivityEventFieldEntryRequest]
    """

    _validation = {
        'location_id': {'required': True},
        'title': {'required': True, 'max_length': 50, 'min_length': 0},
        'description': {'max_length': 1000, 'min_length': 0},
        'note': {'max_length': 1000, 'min_length': 0},
    }

    _attribute_map = {
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'category_id': {'key': 'CategoryId', 'type': 'int'},
        'category_code': {'key': 'CategoryCode', 'type': 'str'},
        'title': {'key': 'Title', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'note': {'key': 'Note', 'type': 'str'},
        'start_date_time': {'key': 'StartDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'EndDateTime', 'type': 'iso-8601'},
        'document': {'key': 'Document', 'type': 'ActivityEventDocumentRequest'},
        'subcategories': {'key': 'Subcategories', 'type': '[ActivityEventSubcategoryEntryRequest]'},
        'binds': {'key': 'Binds', 'type': '[ActivityEventBindRequest]'},
        'fields': {'key': 'Fields', 'type': '[ActivityEventFieldEntryRequest]'},
    }

    def __init__(self, *, location_id: str, title: str, category_id: int=None, category_code: str=None, description: str=None, note: str=None, start_date_time=None, end_date_time=None, document=None, subcategories=None, binds=None, fields=None, **kwargs) -> None:
        super(ActivityEventCreateRequest, self).__init__(**kwargs)
        self.location_id = location_id
        self.category_id = category_id
        self.category_code = category_code
        self.title = title
        self.description = description
        self.note = note
        self.start_date_time = start_date_time
        self.end_date_time = end_date_time
        self.document = document
        self.subcategories = subcategories
        self.binds = binds
        self.fields = fields
