import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PersonalAccessTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * The token expires at midnight UTC on that date. The date must be in the format YYYY-MM-DD. Default is never.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/personal_access_token#expires_at PersonalAccessToken#expires_at}
    */
    readonly expiresAt?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/personal_access_token#id PersonalAccessToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the personal access token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/personal_access_token#name PersonalAccessToken#name}
    */
    readonly name: string;
    /**
    * The scope for the personal access token. It determines the actions which can be performed when authenticating with this token. Valid values are: `api`, `read_user`, `read_api`, `read_repository`, `write_repository`, `read_registry`, `write_registry`, `sudo`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/personal_access_token#scopes PersonalAccessToken#scopes}
    */
    readonly scopes: string[];
    /**
    * The id of the user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/personal_access_token#user_id PersonalAccessToken#user_id}
    */
    readonly userId: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/personal_access_token gitlab_personal_access_token}
*/
export declare class PersonalAccessToken extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_personal_access_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/personal_access_token gitlab_personal_access_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PersonalAccessTokenConfig
    */
    constructor(scope: Construct, id: string, config: PersonalAccessTokenConfig);
    get active(): cdktf.IResolvable;
    get createdAt(): string;
    private _expiresAt?;
    get expiresAt(): string;
    set expiresAt(value: string);
    resetExpiresAt(): void;
    get expiresAtInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get revoked(): cdktf.IResolvable;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
    get token(): string;
    private _userId?;
    get userId(): number;
    set userId(value: number);
    get userIdInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=personal-access-token.d.ts.map