/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import technology.tabula.Page;
import technology.tabula.Rectangle;
import technology.tabula.Ruling;

public class ProjectionProfile {
    public static final int DECIMAL_PLACES = 1;
    private final Page area;
    private final Rectangle textBounds;
    private float[] verticalProjection;
    private float[] horizontalProjection;
    private final double areaWidth;
    private final double areaHeight;
    private final double areaTop;
    private final double areaLeft;
    private float minCharWidth = Float.MAX_VALUE;
    private float minCharHeight = Float.MAX_VALUE;
    private float horizontalKernelSize;
    private float verticalKernelSize;
    private float maxHorizontalProjection = 0.0f;
    private float maxVerticalProjection = 0.0f;

    public ProjectionProfile(Page area, List<? extends Rectangle> elements, float horizontalKernelSize, float verticalKernelSize) {
        this.area = area;
        this.areaWidth = area.getWidth();
        this.areaHeight = area.getHeight();
        this.areaTop = area.getTop();
        this.areaLeft = area.getLeft();
        this.verticalProjection = new float[ProjectionProfile.toFixed(this.areaHeight)];
        this.horizontalProjection = new float[ProjectionProfile.toFixed(this.areaWidth)];
        this.horizontalKernelSize = horizontalKernelSize;
        this.verticalKernelSize = verticalKernelSize;
        this.textBounds = area.getTextBounds();
        for (Rectangle rectangle : elements) {
            if (rectangle.getWidth() / this.textBounds.getWidth() > 0.8) continue;
            this.addRectangle(rectangle);
        }
        this.verticalProjection = ProjectionProfile.smooth(this.verticalProjection, ProjectionProfile.toFixed(verticalKernelSize));
        this.horizontalProjection = ProjectionProfile.smooth(this.horizontalProjection, ProjectionProfile.toFixed(horizontalKernelSize));
    }

    private void addRectangle(Rectangle element) {
        int k;
        if (!this.area.contains(element)) {
            return;
        }
        this.minCharHeight = (float)Math.min((double)this.minCharHeight, element.getHeight());
        this.minCharWidth = (float)Math.min((double)this.minCharWidth, element.getWidth());
        for (k = ProjectionProfile.toFixed(element.getLeft()); k < ProjectionProfile.toFixed(element.getRight()); ++k) {
            int n = k - ProjectionProfile.toFixed(this.areaLeft);
            this.horizontalProjection[n] = (float)((double)this.horizontalProjection[n] + element.getHeight());
            this.maxHorizontalProjection = Math.max(this.maxHorizontalProjection, this.horizontalProjection[k - ProjectionProfile.toFixed(this.areaLeft)]);
        }
        for (k = ProjectionProfile.toFixed(element.getTop()); k < ProjectionProfile.toFixed(element.getBottom()); ++k) {
            int n = k - ProjectionProfile.toFixed(this.areaTop);
            this.verticalProjection[n] = (float)((double)this.verticalProjection[n] + element.getWidth());
            this.maxVerticalProjection = Math.max(this.maxVerticalProjection, this.verticalProjection[k - ProjectionProfile.toFixed(this.areaTop)]);
        }
    }

    public float[] getVerticalProjection() {
        return this.verticalProjection;
    }

    public float[] getHorizontalProjection() {
        return this.horizontalProjection;
    }

    public float[] findVerticalSeparators(float minColumnWidth) {
        boolean foundNarrower = false;
        ArrayList<Integer> verticalSeparators = new ArrayList<Integer>();
        for (Ruling ruling : this.area.getVerticalRulings()) {
            if (!(ruling.length() / this.textBounds.getHeight() >= 0.95)) continue;
            verticalSeparators.add(ProjectionProfile.toFixed((double)ruling.getPosition() - this.areaLeft));
        }
        List<Integer> seps = ProjectionProfile.findSeparatorsFromProjection(ProjectionProfile.filter(ProjectionProfile.getFirstDeriv(this.horizontalProjection), 0.1f));
        for (Integer foundSep : seps) {
            for (Integer explicitSep : verticalSeparators) {
                if (!(Math.abs(ProjectionProfile.toDouble(foundSep - explicitSep)) <= (double)minColumnWidth)) continue;
                foundNarrower = true;
                break;
            }
            if (!foundNarrower) {
                verticalSeparators.add(foundSep);
            }
            foundNarrower = false;
        }
        Collections.sort(verticalSeparators);
        float[] fArray = new float[verticalSeparators.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)ProjectionProfile.toDouble((Integer)verticalSeparators.get(i));
        }
        return fArray;
    }

    public float[] findHorizontalSeparators(float minRowHeight) {
        boolean foundShorter = false;
        ArrayList<Integer> horizontalSeparators = new ArrayList<Integer>();
        for (Ruling ruling : this.area.getHorizontalRulings()) {
            System.out.println(ruling.length() / this.textBounds.getWidth());
            if (!(ruling.length() / this.textBounds.getWidth() >= 0.95)) continue;
            horizontalSeparators.add(ProjectionProfile.toFixed((double)ruling.getPosition() - this.areaTop));
        }
        List<Integer> seps = ProjectionProfile.findSeparatorsFromProjection(ProjectionProfile.filter(ProjectionProfile.getFirstDeriv(this.verticalProjection), 0.1f));
        for (Integer foundSep : seps) {
            for (Integer explicitSep : horizontalSeparators) {
                if (!(Math.abs(ProjectionProfile.toDouble(foundSep - explicitSep)) <= (double)minRowHeight)) continue;
                foundShorter = true;
                break;
            }
            if (!foundShorter) {
                horizontalSeparators.add(foundSep);
            }
            foundShorter = false;
        }
        Collections.sort(horizontalSeparators);
        float[] fArray = new float[horizontalSeparators.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)ProjectionProfile.toDouble((Integer)horizontalSeparators.get(i));
        }
        return fArray;
    }

    private static List<Integer> findSeparatorsFromProjection(float[] derivative) {
        ArrayList<Integer> separators = new ArrayList<Integer>();
        Integer lastNeg = null;
        boolean positiveSlope = false;
        for (int i = 0; i < derivative.length; ++i) {
            float s = derivative[i];
            if (s > 0.0f && !positiveSlope) {
                positiveSlope = true;
                separators.add(lastNeg != null ? lastNeg : i);
                continue;
            }
            if (!(s < 0.0f)) continue;
            lastNeg = i;
            positiveSlope = false;
        }
        return separators;
    }

    public static float[] smooth(float[] data, int kernelSize) {
        float[] rv = new float[data.length];
        for (int pass = 0; pass < 1; ++pass) {
            for (int i = 0; i < data.length; ++i) {
                float s = 0.0f;
                for (int j = Math.max(0, i - kernelSize / 2); j < Math.min(i + kernelSize / 2, data.length); ++j) {
                    s += data[j];
                }
                rv[i] = (float)Math.floor(s / (float)kernelSize);
            }
        }
        return rv;
    }

    public static float[] filter(float[] data, float alpha) {
        float[] rv = new float[data.length];
        rv[0] = data[0];
        for (int i = 1; i < data.length; ++i) {
            rv[i] = rv[i - 1] + alpha * (data[i] - rv[i - 1]);
        }
        return rv;
    }

    public static float[] getAutocorrelation(float[] projection) {
        float[] rv = new float[projection.length - 1];
        for (int i = 1; i < projection.length - 1; ++i) {
            rv[i] = projection[i] * projection[i - 1] / 100.0f;
        }
        return rv;
    }

    public static float[] getFirstDeriv(float[] projection) {
        float[] rv = new float[projection.length];
        rv[0] = projection[1] - projection[0];
        for (int i = 1; i < projection.length - 1; ++i) {
            rv[i] = projection[i + 1] - projection[i - 1];
        }
        rv[projection.length - 1] = projection[projection.length - 1] - projection[projection.length - 2];
        return rv;
    }

    private static int toFixed(double value) {
        return (int)Math.round(value * Math.pow(10.0, 1.0));
    }

    private static double toDouble(int value) {
        return (double)value / Math.pow(10.0, 1.0);
    }
}

