# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/05_rpy.ipynb (unless otherwise specified).

__all__ = ['warnError', 'rPrint', 'R_CONSOLE', 'import_rpy2', 'pkg_name', 'utils', 'lib_loc', 'libPaths', 'SUPERPOWER',
           'types', 'DTYPES', 'AS_DTYPE', 'Result', 'RFunction', 'RMixins']

# Cell
import time, os, datetime
import pandas as pd
import numpy as np
from IPython.display import display, Javascript, HTML
from collections import UserDict
from pathlib import Path

# Cell
from .log import getLogger, WIDGET_HANDLER
from .config import CONFIG

# Cell
import rpy2
from rpy2 import rinterface, robjects, situation
rpy2.rinterface.initr()

from rpy2.robjects import packages, numpy2ri, pandas2ri, conversion
rpy2.robjects.numpy2ri.activate()
rpy2.robjects.numpy2ri.activate()

# Cell
R_CONSOLE = getLogger('r.console')
def warnError(msg):
    R_CONSOLE.error(msg)

def rPrint(msg):
    R_CONSOLE.info(msg)

rpy2.rinterface_lib.callbacks.consolewrite_warnerror = warnError
rpy2.rinterface_lib.callbacks.consolewrite_print = rPrint

# Cell
def import_rpy2():
    global rpy2
    return rpy2

# Cell
pkg_name = 'Superpower'
utils = rpy2.robjects.packages.importr('utils')
lib_loc = CONFIG['R']['lib_loc']
libPaths = list(rpy2.robjects.r['.libPaths']())
libPaths.insert(0, CONFIG['R']['lib_loc'])
SUPERPOWER = None

for lib_path in libPaths:
    try:
        R_CONSOLE.info('Attempting Superpower import from %s...' % lib_path)
        SUPERPOWER = rpy2.robjects.packages.importr(pkg_name, lib_loc)
        if SUPERPOWER:
            R_CONSOLE.info('Import successful!')
            break
    except:
        pass
if not SUPERPOWER:
    R_CONSOLE.exception('Import failed.')
    R_CONSOLE.info('Using source file %s' % lib_loc)
    R_CONSOLE.info('Attempting install to %s' % lib_loc)
    try:
        kwargs = {}
        kwargs['pkgs'] = CONFIG['R']['source']
        kwargs['repos'] = rpy2.rinterface.NULL
        kwargs['type'] = 'source'
        kwargs['lib'] = lib_loc
        utils.install_packages(**kwargs)
        SUPERPOWER = rpy2.robjects.packages.importr(pkg_name, lib_loc)
    except Exception as e:
        R_CONSOLE.exception('Install failed with message: %s' % str(e))
        raise Exception('Fatal. Superpower could not be imported or installed.')
    if SUPERPOWER:
        R_CONSOLE.info('Install successful!')
    else:
        raise Exception('Install failed.')

# Cell
types = (('int', rpy2.rinterface.IntSexpVector([])), ('bool', rpy2.rinterface.BoolSexpVector([])), ('string', rpy2.rinterface.StrSexpVector([])), ('float', rpy2.rinterface.FloatSexpVector([])))
DTYPES = {}
AS_DTYPE = {}
for py_type, r_vector in types:
    np_array = np.asarray(r_vector)
    DTYPES[py_type] = np_array.dtype
    AS_DTYPE[py_type] = getattr(np, str(np_array.dtype))

# Cell
class Result(UserDict):

    def _repr_pretty_(self, p, cycle):
        with p.group(4, self.data['name'] +'([', '])'):
            p.breakable()
            for key, value in self.data.items():
                if key != 'name':
                    p.text(key  + ': ')
                    if isinstance(value, dict):
                        with p.group(4, '{', '}'):
                            for k, v in value.items():
                                p.text(k + ': ')
                                p.pretty(v)
                                p.text(', ')
                                p.breakable()
                    elif isinstance(value, pd.DataFrame):
                        p.pretty('See above data frame.')
                        display(HTML(value.to_html()))
                    else:
                        p.pretty(value)
                        p.text(',')
                    p.breakable()

# Cell
class RFunction():
    ''' The class used to create a model for any R function, and only one R function.
    This class abstracts away all rpy2 calls to make interaction with the SUPERPOWER library
    easy.
    '''

    def __init__(self, name, argNames=None):
        self.name = name
        self.function = getattr(SUPERPOWER, name)
        self.defaults = self.getDefaultKwargs()
        self.setArgNames(argNames)

    def setArgNames(self, argNames=None):
        '''Sets the names of all accepted arguments. Overrides previous.'''
        if argNames is None:
            self.getDefaultArgNames(self)
        else:
            if all(name in self.argNames for name in argNames):
                self.argNames = argNames
            else:
                raise Exception('All argNames must be valid arguments for the given R function')

    def setKwargs(self, **kwargs):
        """Adds kwargs if and only if the key is is a valid function argument.
        """
        self.kwargs = {k:v for (k, v) in kwargs.items() if k in self.argNames}

    def setDefaultArg(self, argName):
        self.kwargs[argName] = self.defaults[argName]

    def getDefaultArgNames(self):
        '''Gets the names of all accepted arguments'''
        formals = rpy2.robjects.r['formals']
        default = formals(self.function)
        return default.names

    def getDefaultKwargs(self):
        '''This method gets a dictionary of default arguments provided by the R function'''
        formals = rpy2.robjects.r['formals']
        default = formals(self.function)
        args = {}
        for i, name in enumerate(default.names):
            if len(default[i]) > 0 and default[i][0] != rpy2.robjects.r("NULL"):
                ary = np.asarray(default[i])
                if len(ary) > 1:
                    args[name] = ary
                else:
                    args[name] = ary[0]
        return args

    def run(self, alert=True, **kwargs):
        '''This method runs the R function associated with the model. The run will be
        timed and the runtime and results are added to the results dictionary. You should
        not have to modify this function to run your custom Model
        '''
        if kwargs:
            self.setKwargs(**kwargs)
        try:
            R_CONSOLE.info('Running %s with kwargs...' % self.name)
            for key, value in self.kwargs.items():
                R_CONSOLE.info('\t%s: %s' % (key, str(value).replace("\n", "")))
            ret = {}
            startTime = time.time()
            ret['name'] = self.name
            ret['kwargs'] = self.kwargs
            ret['df'] = self.function(**self.kwargs)
            if isinstance(ret['df'], rpy2.robjects.vectors.ListVector):
                ret['df'] = self.listVector_to_DataFrame(ret['df'])
            ret['df'] = self.convert_to_pandas(ret['df'])
            ret['runtime'] = (time.time() - startTime)
            ret['id'] = int(round(time.time() * 1000))
            ret['date'] = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')
            R_CONSOLE.info('ID: %i, Date: %s, Runtime: %s' % (ret['id'], str(ret['date']), str(ret['runtime'])))
            R_CONSOLE.info('Results:\n%s' % ret['df'].to_string())
            return Result(ret)
        except Exception as e:
            if alert:
                e = str(e).replace('\n', ' ').replace('\n', '').replace('"','\\"')
                display(Javascript('alert("' + e + '");'))
                return None
            else:
                raise e

    def listVector_to_DataFrame(self, result):
        df_dict = {}
        for i in range(len(result.names)):
            df_dict[result.names[i]] = result[i]
        return rpy2.robjects.DataFrame(df_dict)

    def convert_to_pandas(self, df):
        with rpy2.robjects.conversion.localconverter(rpy2.robjects.default_converter + rpy2.robjects.pandas2ri.converter):
            return rpy2.robjects.conversion.rpy2py(df)

    def attr_dict(self):
        keys = ['name', 'result', 'packageName', 'runtime', 'id', 'kwargs', 'defaults']
        return {key: value for key, value in self.__dict__.items() if key in keys}

    def _repr_pretty_(self, p, cycle):
        with p.group(4, str(self.name) +'([', '])'):
            p.breakable()
            for key, value in self.attr_dict().items():
                if key != 'name':
                    p.text(key  + ': ')
                    if isinstance(value, dict):
                        with p.group(4, '{', '}'):
                            for k, v in value.items():
                                p.text(k + ': ')
                                p.pretty(v)
                                p.text(',')
                                p.breakable()
                    else:
                        p.pretty(value)
                        p.text(',')
                        p.breakable()
                    p.breakable()

# Cell
class RMixins():

    def __init__(self):
        self.matrix_func = rpy2.robjects.baseenv['matrix']