# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/07_mvc.ipynb (unless otherwise specified).

__all__ = ['Model', 'Controller', 'MiniView']

# Cell
from traitlets import HasTraits, Int, Unicode, List, observe, link
import ipywidgets as ipyw

# Cell
from .widget_containers import HBox, WidgetList
from .widgets import Text, Dropdown

# Cell
class Model(HasTraits):

    def __init__(self, **kwargs):
        if not kwargs:
            self.setLanding()
        else:
            self.setTraits(**kwargs)
        super().__init__(**kwargs)

    def initTraits(self):
        for trait in self.traits().keys():
            getattr(self, trait)

    def setTraits(self, **kwargs):
        with self.hold_trait_notifications():
            for key, value in kwargs.items():
                setattr(self, key, value)

    def getTraits(self, traits=None):
        ret = {}
        if not traits:
            traits = self.traits().keys()
            self.initTraits()
        for trait in traits:
            ret[trait] = self._trait_values[trait]
        return ret

    def run(self):
        raise NotImplementedError('All Model subclasses must implement a run method')

    def setLanding(self, **kwargs):
        raise NotImplementedError('All Model subclasses must implement a setLanding method')

    def setEstimates(self, **kwargs):
        raise NotImplementedError('All Model subclasses must implement a setEstimates method')

    def _repr_pretty_(self, p, cycle):
        class_name = self.__class__.__name__
        with p.group(4, str(class_name) +'(', ')'):
            p.breakable()
            for trait, value in self._trait_values.items():
                if not trait.startswith('_'):
                    p.text(trait + ': ')
                    p.pretty(value)
                    p.text(',')
                    p.breakable()

# Cell
class Controller():

    def initialize(self):
        raise NotImplementedError()

    def setLanding(self):
        self.model.setLanding()
        self.initialize()

    def setEstimates(self):
        self.model.setEstimates()
        self.initialize()

# Cell
class MiniView(HBox):

    def __init__(self, model, **kwargs):
        super().__init__(**kwargs)

        self.model = model

        ''' layouts '''
        nameLayout = ipyw.Layout( max_width = '160px')
        levelsLayouts = [ipyw.Layout( max_width = '62px') for i in range(0, self.model.max_n)]
        levelsLayouts[0].max_width  = '150px'
        dropdownLayout = ipyw.Layout(width='135px')

        ''' rowBox widgets'''
        self.name = Text(description='Name:', layout=nameLayout, value = self.model.name)
        options=[i for i in range(2, self.model.max_n + 1)]
        self.n = Dropdown(description='Number:', layout=ipyw.Layout(width='135px'), options=options, value=self.model.n)

        levels = [ Text(description = 'Levels:', layout=levelsLayouts[0], value=self.model.levels[0])]
        levels += [ Text(layout=levelsLayouts[i], value=self.model.levels[i]) for i in range(1, self.model.n)]
        levels += [ Text(layout=levelsLayouts[i]) for i in range(self.model.n, self.model.max_n)]
        self.levels = WidgetList(levels)

        levelNames = [ Text(description = 'LevelNames:', layout=levelsLayouts[0], value=self.model.levels[0])]
        levelNames += [ Text(layout=levelsLayouts[i], value=self.model.levels[i]) for i in range(1, self.model.n)]
        levelNames += [ Text(layout=levelsLayouts[i]) for i in range(self.model.n, self.model.max_n)]
        self.levelNames = WidgetList(levelNames)

        self.children = (self.name, self.n) + self.levels.children + self.levelNames.children