import { FargateService, FargateServiceProps } from 'aws-cdk-lib/aws-ecs';
import { NetworkLoadBalancer } from 'aws-cdk-lib/aws-elasticloadbalancingv2';
import { PrivateHostedZone } from 'aws-cdk-lib/aws-route53';
import { Construct } from 'constructs';
import { KongFeatureProps } from '../../kong-ecs';
export interface KongAdminServiceProps {
    readonly kongServiceProps: FargateServiceProps;
    readonly adminNlb: NetworkLoadBalancer;
    readonly managerNlb?: NetworkLoadBalancer;
    readonly devPortalNlb?: NetworkLoadBalancer;
    readonly route53_zone: PrivateHostedZone;
    readonly kongFeaturesProps: KongFeatureProps;
}
export declare class KongAdminService extends FargateService {
    private zone;
    private adminPort;
    private adminHttpsPort;
    private managerPort;
    private managerHttpsPort;
    private telemetryPort;
    private clusterPort;
    private devPortalPort;
    private controlPlaneDnsEp;
    private adminEndpoint;
    private managerEndpoint;
    private devPortalEndpoint;
    private clusterEndpoint;
    private telemetryEndpoint;
    constructor(scope: Construct, id: string, props: KongAdminServiceProps);
    private registerKongFeatureTargets;
}
//# sourceMappingURL=kong-admin-service.d.ts.map