"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongControlPlaneECS = void 0;
const aws_ecs_1 = require("aws-cdk-lib/aws-ecs");
const secretManager = require("aws-cdk-lib/aws-secretsmanager");
const constructs_1 = require("constructs");
// import { KongControlPlane } from '../KongControlPlane';
const kong_admin_service_1 = require("./kong-admin-service");
const kong_admin_taskdefinition_1 = require("./kong-admin-taskdefinition");
class KongControlPlaneECS extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        let secrets = {};
        if (props.rds.secret) {
            secrets.KONG_PG_USERNAME = aws_ecs_1.Secret.fromSecretsManager(props.rds.secret, 'username');
            secrets.KONG_PG_PASSWORD = aws_ecs_1.Secret.fromSecretsManager(props.rds.secret, 'password');
            if (props.licenseSecret) {
                const licenseSecret = secretManager.Secret.fromSecretNameV2(this, 'KongCPLicense', (_a = props.licenseSecret) !== null && _a !== void 0 ? _a : '');
                secrets.KONG_LICENSE_DATA = aws_ecs_1.Secret.fromSecretsManager(licenseSecret, 'license');
            }
        }
        const kongAdminTaskDefinition = new kong_admin_taskdefinition_1.KongAdminTaskdefinition(this, 'KongCPTaskDefinition', {
            hostedZoneName: props.route53_zone.zoneName,
            image: props.image,
            dbInstanceEndpointAddress: props.rds.dbInstanceEndpointAddress,
            dbInstanceEndpointPort: props.rds.dbInstanceEndpointPort,
            secrets: secrets,
            cluster: props.cluster,
            certificates: props.certificates,
            kongFeaturesProps: props.kongFeaturesProps,
            kongTaskProps: props.kongTaskProps,
        });
        new kong_admin_service_1.KongAdminService(this, 'KongCPFargateService', {
            kongServiceProps: {
                cluster: props.cluster,
                taskDefinition: kongAdminTaskDefinition,
                desiredCount: props.desiredCount,
            },
            adminNlb: props.adminNlb,
            managerNlb: props.managerNlb,
            devPortalNlb: props.devPortalNlb,
            kongFeaturesProps: props.kongFeaturesProps,
            route53_zone: props.route53_zone,
        });
    }
}
exports.KongControlPlaneECS = KongControlPlaneECS;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvcmVzb3VyY2VzL2Vjcy9pbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxpREFHNkI7QUFJN0IsZ0VBQWdFO0FBQ2hFLDJDQUF1QztBQUl2QywwREFBMEQ7QUFDMUQsNkRBQXdEO0FBQ3hELDJFQUFzRTtBQWlCdEUsTUFBYSxtQkFBb0IsU0FBUSxzQkFBUztJQUVoRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQWtCOztRQUMxRCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksT0FBTyxHQUE4QixFQUFFLENBQUM7UUFFNUMsSUFBSSxLQUFLLENBQUMsR0FBRyxDQUFDLE1BQU0sRUFBRTtZQUNwQixPQUFPLENBQUMsZ0JBQWdCLEdBQUcsZ0JBQU0sQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLE1BQU0sRUFBRSxVQUFVLENBQUMsQ0FBQztZQUNuRixPQUFPLENBQUMsZ0JBQWdCLEdBQUcsZ0JBQU0sQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLE1BQU0sRUFBRSxVQUFVLENBQUMsQ0FBQztZQUVuRixJQUFLLEtBQUssQ0FBQyxhQUFhLEVBQUc7Z0JBQ3pCLE1BQU0sYUFBYSxHQUFHLGFBQWEsQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxFQUFFLGVBQWUsUUFBRSxLQUFLLENBQUMsYUFBYSxtQ0FBSSxFQUFFLENBQUMsQ0FBQztnQkFDOUcsT0FBTyxDQUFDLGlCQUFpQixHQUFHLGdCQUFNLENBQUMsa0JBQWtCLENBQUMsYUFBYSxFQUFFLFNBQVMsQ0FBQyxDQUFDO2FBQ2pGO1NBQ0Y7UUFFRCxNQUFNLHVCQUF1QixHQUFHLElBQUksbURBQXVCLENBQUMsSUFBSSxFQUFFLHNCQUFzQixFQUFFO1lBQ3hGLGNBQWMsRUFBRSxLQUFLLENBQUMsWUFBWSxDQUFDLFFBQVE7WUFDM0MsS0FBSyxFQUFFLEtBQUssQ0FBQyxLQUFLO1lBQ2xCLHlCQUF5QixFQUFFLEtBQUssQ0FBQyxHQUFHLENBQUMseUJBQXlCO1lBQzlELHNCQUFzQixFQUFFLEtBQUssQ0FBQyxHQUFHLENBQUMsc0JBQXNCO1lBQ3hELE9BQU8sRUFBRSxPQUFPO1lBQ2hCLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztZQUN0QixZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7WUFDaEMsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQjtZQUMxQyxhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWE7U0FDbkMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxxQ0FBZ0IsQ0FBQyxJQUFJLEVBQUUsc0JBQXNCLEVBQUU7WUFDakQsZ0JBQWdCLEVBQUU7Z0JBQ2hCLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztnQkFDdEIsY0FBYyxFQUFFLHVCQUF1QjtnQkFDdkMsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO2FBQ2pDO1lBQ0QsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO1lBQ3hCLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtZQUM1QixZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7WUFDaEMsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQjtZQUMxQyxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7U0FDakMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztDQUNGO0FBMUNELGtEQTBDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIENsdXN0ZXIsIEZhcmdhdGVUYXNrRGVmaW5pdGlvblByb3BzLFxuICBTZWNyZXQsXG59IGZyb20gJ2F3cy1jZGstbGliL2F3cy1lY3MnO1xuaW1wb3J0IHsgTmV0d29ya0xvYWRCYWxhbmNlciB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1lbGFzdGljbG9hZGJhbGFuY2luZ3YyJztcbmltcG9ydCB7IERhdGFiYXNlSW5zdGFuY2UgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtcmRzJztcbmltcG9ydCB7IFByaXZhdGVIb3N0ZWRab25lIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLXJvdXRlNTMnO1xuaW1wb3J0ICogYXMgc2VjcmV0TWFuYWdlciBmcm9tICdhd3MtY2RrLWxpYi9hd3Mtc2VjcmV0c21hbmFnZXInO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG4vLyBpbXBvcnQgeyBDZXJ0aWZpY2F0ZXMgfSBmcm9tICcuLi8uLi8uLi8uLi9rb25nLWNvcmUnO1xuaW1wb3J0IHsgQ2VydGlmaWNhdGVzIH0gZnJvbSAna29uZy1jb3JlJztcbmltcG9ydCB7IEtvbmdGZWF0dXJlUHJvcHMgfSBmcm9tICcuLi8uLi9rb25nLWVjcyc7XG4vLyBpbXBvcnQgeyBLb25nQ29udHJvbFBsYW5lIH0gZnJvbSAnLi4vS29uZ0NvbnRyb2xQbGFuZSc7XG5pbXBvcnQgeyBLb25nQWRtaW5TZXJ2aWNlIH0gZnJvbSAnLi9rb25nLWFkbWluLXNlcnZpY2UnO1xuaW1wb3J0IHsgS29uZ0FkbWluVGFza2RlZmluaXRpb24gfSBmcm9tICcuL2tvbmctYWRtaW4tdGFza2RlZmluaXRpb24nO1xuXG5leHBvcnQgaW50ZXJmYWNlIEtvbmdDUFByb3BzIHtcbiAgcmVhZG9ubHkgY2x1c3RlcjogQ2x1c3RlcjtcbiAgcmVhZG9ubHkgcmRzOiBEYXRhYmFzZUluc3RhbmNlO1xuICByZWFkb25seSBpbWFnZTogc3RyaW5nO1xuICByZWFkb25seSByb3V0ZTUzX3pvbmU6IFByaXZhdGVIb3N0ZWRab25lO1xuICByZWFkb25seSBjZXJ0aWZpY2F0ZXM6IENlcnRpZmljYXRlcztcbiAgcmVhZG9ubHkga29uZ0ZlYXR1cmVzUHJvcHM6IEtvbmdGZWF0dXJlUHJvcHM7XG4gIHJlYWRvbmx5IGtvbmdUYXNrUHJvcHM6IEZhcmdhdGVUYXNrRGVmaW5pdGlvblByb3BzO1xuICByZWFkb25seSBhZG1pbk5sYjogTmV0d29ya0xvYWRCYWxhbmNlcjtcbiAgcmVhZG9ubHkgbWFuYWdlck5sYj86IE5ldHdvcmtMb2FkQmFsYW5jZXI7XG4gIHJlYWRvbmx5IGRldlBvcnRhbE5sYj86IE5ldHdvcmtMb2FkQmFsYW5jZXI7XG4gIHJlYWRvbmx5IGxpY2Vuc2VTZWNyZXQ/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGRlc2lyZWRDb3VudDogbnVtYmVyO1xufVxuXG5leHBvcnQgY2xhc3MgS29uZ0NvbnRyb2xQbGFuZUVDUyBleHRlbmRzIENvbnN0cnVjdCB7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEtvbmdDUFByb3BzICkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBsZXQgc2VjcmV0cyA6IHsgW2tleTogc3RyaW5nXTogU2VjcmV0fSA9IHt9O1xuXG4gICAgaWYgKHByb3BzLnJkcy5zZWNyZXQpIHtcbiAgICAgIHNlY3JldHMuS09OR19QR19VU0VSTkFNRSA9IFNlY3JldC5mcm9tU2VjcmV0c01hbmFnZXIocHJvcHMucmRzLnNlY3JldCwgJ3VzZXJuYW1lJyk7XG4gICAgICBzZWNyZXRzLktPTkdfUEdfUEFTU1dPUkQgPSBTZWNyZXQuZnJvbVNlY3JldHNNYW5hZ2VyKHByb3BzLnJkcy5zZWNyZXQsICdwYXNzd29yZCcpO1xuXG4gICAgICBpZiAoIHByb3BzLmxpY2Vuc2VTZWNyZXQgKSB7XG4gICAgICAgIGNvbnN0IGxpY2Vuc2VTZWNyZXQgPSBzZWNyZXRNYW5hZ2VyLlNlY3JldC5mcm9tU2VjcmV0TmFtZVYyKHRoaXMsICdLb25nQ1BMaWNlbnNlJywgcHJvcHMubGljZW5zZVNlY3JldCA/PyAnJyk7XG4gICAgICAgIHNlY3JldHMuS09OR19MSUNFTlNFX0RBVEEgPSBTZWNyZXQuZnJvbVNlY3JldHNNYW5hZ2VyKGxpY2Vuc2VTZWNyZXQsICdsaWNlbnNlJyk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgY29uc3Qga29uZ0FkbWluVGFza0RlZmluaXRpb24gPSBuZXcgS29uZ0FkbWluVGFza2RlZmluaXRpb24odGhpcywgJ0tvbmdDUFRhc2tEZWZpbml0aW9uJywge1xuICAgICAgaG9zdGVkWm9uZU5hbWU6IHByb3BzLnJvdXRlNTNfem9uZS56b25lTmFtZSxcbiAgICAgIGltYWdlOiBwcm9wcy5pbWFnZSxcbiAgICAgIGRiSW5zdGFuY2VFbmRwb2ludEFkZHJlc3M6IHByb3BzLnJkcy5kYkluc3RhbmNlRW5kcG9pbnRBZGRyZXNzLFxuICAgICAgZGJJbnN0YW5jZUVuZHBvaW50UG9ydDogcHJvcHMucmRzLmRiSW5zdGFuY2VFbmRwb2ludFBvcnQsXG4gICAgICBzZWNyZXRzOiBzZWNyZXRzLFxuICAgICAgY2x1c3RlcjogcHJvcHMuY2x1c3RlcixcbiAgICAgIGNlcnRpZmljYXRlczogcHJvcHMuY2VydGlmaWNhdGVzLFxuICAgICAga29uZ0ZlYXR1cmVzUHJvcHM6IHByb3BzLmtvbmdGZWF0dXJlc1Byb3BzLFxuICAgICAga29uZ1Rhc2tQcm9wczogcHJvcHMua29uZ1Rhc2tQcm9wcyxcbiAgICB9KTtcblxuICAgIG5ldyBLb25nQWRtaW5TZXJ2aWNlKHRoaXMsICdLb25nQ1BGYXJnYXRlU2VydmljZScsIHtcbiAgICAgIGtvbmdTZXJ2aWNlUHJvcHM6IHtcbiAgICAgICAgY2x1c3RlcjogcHJvcHMuY2x1c3RlcixcbiAgICAgICAgdGFza0RlZmluaXRpb246IGtvbmdBZG1pblRhc2tEZWZpbml0aW9uLFxuICAgICAgICBkZXNpcmVkQ291bnQ6IHByb3BzLmRlc2lyZWRDb3VudCxcbiAgICAgIH0sXG4gICAgICBhZG1pbk5sYjogcHJvcHMuYWRtaW5ObGIsXG4gICAgICBtYW5hZ2VyTmxiOiBwcm9wcy5tYW5hZ2VyTmxiLFxuICAgICAgZGV2UG9ydGFsTmxiOiBwcm9wcy5kZXZQb3J0YWxObGIsXG4gICAgICBrb25nRmVhdHVyZXNQcm9wczogcHJvcHMua29uZ0ZlYXR1cmVzUHJvcHMsXG4gICAgICByb3V0ZTUzX3pvbmU6IHByb3BzLnJvdXRlNTNfem9uZSxcbiAgICB9KTtcbiAgfVxufSJdfQ==