import { Cluster, FargateTaskDefinitionProps } from 'aws-cdk-lib/aws-ecs';
import { NetworkLoadBalancer } from 'aws-cdk-lib/aws-elasticloadbalancingv2';
import { DatabaseInstance } from 'aws-cdk-lib/aws-rds';
import { PrivateHostedZone } from 'aws-cdk-lib/aws-route53';
import { Construct } from 'constructs';
import { Certificates } from 'kong-core';
import { KongFeatureProps } from '../../kong-ecs';
export interface KongCPProps {
    readonly cluster: Cluster;
    readonly rds: DatabaseInstance;
    readonly image: string;
    readonly route53_zone: PrivateHostedZone;
    readonly certificates: Certificates;
    readonly kongFeaturesProps: KongFeatureProps;
    readonly kongTaskProps: FargateTaskDefinitionProps;
    readonly adminNlb: NetworkLoadBalancer;
    readonly managerNlb?: NetworkLoadBalancer;
    readonly devPortalNlb?: NetworkLoadBalancer;
    readonly licenseSecret?: string;
    readonly desiredCount: number;
}
export declare class KongControlPlaneECS extends Construct {
    constructor(scope: Construct, id: string, props: KongCPProps);
}
//# sourceMappingURL=index.d.ts.map