"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
// import * as kong_core from '../../kong-core/';
const kong_core = require("kong-core");
const index_1 = require("./resources/eks/helm-charts/kong/index");
class KongEks extends constructs_1.Construct {
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        this.clusterDns = `cluster.${props.hostedZoneName}:8005`;
        this.telemetryDns = `telemetry.${props.hostedZoneName}:8006`;
        const control_plane_secretskey = new aws_cdk_lib_1.aws_kms.Key(this, 'CPSecretsKey');
        this.controlPlane = new aws_cdk_lib_1.aws_eks.Cluster(this, 'CP', {
            ...props.controlPlaneClusterProps.eksClusterProps,
            secretsEncryptionKey: control_plane_secretskey,
            defaultCapacity: 0,
        });
        const cp_nodegroup = this.controlPlane.addNodegroupCapacity('CpASG', props.controlPlaneNodeProps);
        cp_nodegroup.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        // new EksNodeHandler(this, 'NodeHandler', {
        //   cluster: this.controlPlane,
        //   nodegroup: cp_nodegroup,
        // });
        new kong_core.MetricsServer(this, 'MetricsServer', {
            cluster: this.controlPlane,
        });
        const kong_rds_instance = new kong_core.RdsStack(this, 'KongRds', {
            vpc: this.controlPlane.vpc,
            databasename: props.rdsProps.databasename,
            postgresversion: props.rdsProps.postgresversion,
            username: props.rdsProps.username,
        });
        const kong_pre_requisites_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongPreReqsStack');
        new kong_core.AutoScalar(this, 'AutoScalar', {
            cluster: this.controlPlane,
            nodegroup: cp_nodegroup,
            namespace: 'kube-system',
        });
        new kong_core.SecretsManager(kong_pre_requisites_nested_stack, 'SecretsCsi', {
            cluster: this.controlPlane,
        });
        new kong_core.ExternalDns(kong_pre_requisites_nested_stack, 'ExtDns', {
            cluster: this.controlPlane,
        });
        const aws_acm_pca = new kong_core.AcmPca(kong_pre_requisites_nested_stack, 'KongCpCa', {
            hostedZoneName: props.hostedZoneName,
            vpc: this.controlPlane.vpc,
        });
        new kong_core.AwsCertManager(kong_pre_requisites_nested_stack, 'KongCpCertManager', {
            cluster: this.controlPlane,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            privateCaArn: aws_acm_pca.privateCaArn,
        });
        // const private_ca = new PrivateCA(kong_pre_requisites_nested_stack, 'KongPCA', {
        //   cluster: this.controlPlane,
        //   nodegroup: cp_nodegroup,
        //   namespace: props.namespace,
        //   cacertname: kong_core.Tls.KONG_CP_CERTNAME,
        //   clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
        //   // commonname: 'www.dummy.com',
        //   hostedZoneName: 'kong-cp.internal',
        //   // dnsNames: [
        //   //   `${props.hostedZoneName}`,
        //   //   `admin.${props.hostedZoneName}`,
        //   //   this.telemetryDns,
        //   //   this.clusterDns,
        //   //   `manager.${props.hostedZoneName}`,
        //   // ],
        // });
        this.privateCaArn = aws_acm_pca.privateCaArn;
        // private_ca.private_ca_arn;
        const kong_control_plane_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongCpNestedStack');
        new index_1.KongControlPlaneEKS(kong_control_plane_nested_stack, 'KongCPHelmInstall', {
            cluster: this.controlPlane,
            rds: kong_rds_instance.kongPostgresSql,
            namespace: props.namespace,
            // nodegroup: cp_nodegroup,
            license_secret_name: props.licenseSecretsName,
            cacertname: kong_core.Tls.KONG_CP_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            // commonname: 'www.dummy.com',
            hostedZoneName: 'kong-cp.internal',
            HelmOptions: props.controlPlaneClusterProps.kongHelmOptions,
            dnsNames: [
                `${props.hostedZoneName}`,
                `admin.${props.hostedZoneName}`,
                this.telemetryDns,
                this.clusterDns,
                `manager.${props.hostedZoneName}`,
            ],
        });
        kong_control_plane_nested_stack.node.addDependency(kong_pre_requisites_nested_stack, kong_rds_instance);
        const telemetry_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongTelemetryNestedStack');
        new kong_core.Telemetry(telemetry_nested_stack, 'KongLogging', {
            createPrometheusWorkspace: props.controlPlaneClusterProps.kongTelemetryOptions.createPrometheusWorkspace,
            cluster: this.controlPlane,
            namespace: kong_core.Namespace.TELEMETRY,
            cacertname: kong_core.Tls.ADOT_CERTNAME,
            clusterIssuerName: kong_core.Tls.KONG_CP_CLUSTER_ISSUER_NAME,
            dnsNames: [
                `${props.hostedZoneName}`,
                `admin.${props.hostedZoneName}`,
                this.telemetryDns,
                this.clusterDns,
                `manager.${props.hostedZoneName}`,
            ],
            hostedZoneName: props.hostedZoneName,
        });
        telemetry_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
        // telemetry.node.addDependency(private_ca_nested_stack.node);
        // telemetry.node.findAll().forEach (function (value) {
        //   value.node.addDependency(private_ca.node.findChild(''));
        // });
    }
    ;
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-control-plane.KongEks", version: "2.0.9" };
//# sourceMappingURL=data:application/json;base64,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