import { aws_rds, aws_eks } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface EksControlPlaneProps {
    /**
      * @summary Name of the hosted zone
      */
    readonly hostedZoneName: string;
    /**
   * @summary Kubernetes Namespace to install Kong Control Plane
   */
    readonly namespace: string;
    /**
      * @summary Name of the Secret in AWS Secrets Manager
      */
    readonly licenseSecretsName: string;
    /**
       * @summary Control Plane EKS Cluster properties
       * @see https://docs.aws.amazon.com/cdk/api/latest/docs/@aws-cdk_aws-eks.ClusterProps.html
       */
    readonly controlPlaneClusterProps: ControlPlaneClusterProps;
    /**
       * @summary Data Plane EKS Cluster properties
       * @see https://docs.aws.amazon.com/cdk/api/latest/docs/@aws-cdk_aws-eks.ClusterProps.html
       */
    /**
       * @summary RDS Database properties
       */
    readonly rdsProps: RdsDatabaseProps;
    /**
       * @summary Kong Control Plane EKS Nodes properties
       * @see https://docs.aws.amazon.com/cdk/api/latest/docs/@aws-cdk_aws-eks.AutoScalingGroupCapacityOptions.html
       */
    readonly controlPlaneNodeProps: aws_eks.NodegroupOptions;
}
export interface RdsDatabaseProps {
    /**
       * @summary RDS PostGres Engine Version
       * @see https://docs.aws.amazon.com/cdk/api/latest/docs/@aws-cdk_aws-rds.PostgresEngineVersion.html
       */
    readonly postgresversion: aws_rds.PostgresEngineVersion;
    /**
       * @summary Master username to be used for RDS
       */
    readonly username: string;
    /**
       * @summary Database name to be used for Artifactory
       */
    readonly databasename: string;
}
export interface ControlPlaneClusterProps {
    readonly eksClusterProps: aws_eks.ClusterProps;
    readonly kongHelmOptions?: aws_eks.HelmChartOptions;
    readonly kongTelemetryOptions: ControlPlaneTelemetryProps;
}
export interface ControlPlaneTelemetryProps {
    readonly createPrometheusWorkspace: Boolean;
    readonly prometheusEndpoint?: string;
}
export declare class KongEks extends Construct {
    readonly controlPlane: aws_eks.Cluster;
    privateCaArn: string;
    telemetryDns: string;
    clusterDns: string;
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope: Construct, id: string, props: EksControlPlaneProps);
}
//# sourceMappingURL=kong-eks.d.ts.map