"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEcs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ecs = require("aws-cdk-lib/aws-ecs");
const aws_rds_1 = require("aws-cdk-lib/aws-rds");
const constructs_1 = require("constructs");
// import * as kong_core from '../../kong-core/';
const kong_core = require("kong-core");
const index_1 = require("./resources/ecs/index");
class KongEcs extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z;
        super(scope, id);
        //Create the Kong CP ECS Cluster
        const cluster = new ecs.Cluster(this, 'KongCPCluster', props.clusterProps);
        this.controlPlane = cluster;
        //Create the RDS Instance for KongCP
        const rds = new kong_core.RdsStack(this, 'KongCPRds', {
            vpc: this.controlPlane.vpc,
            databasename: (_b = props.rdsProps.databasename) !== null && _b !== void 0 ? _b : 'kong',
            username: (_c = props.rdsProps.username) !== null && _c !== void 0 ? _c : 'kong',
            postgresversion: (_d = props.rdsProps.postgresversion) !== null && _d !== void 0 ? _d : aws_rds_1.PostgresEngineVersion.VER_12,
        });
        //Create the NLB for KongCP Admin
        const nlbAdmin = new kong_core.NlbStack(this, 'KongCPAlb', {
            vpc: this.controlPlane.vpc,
            name: props.clusterProps.clusterName + kong_core.Nlb.KONG_CP_ADMIN_LB_SUFFIX,
            internetFacing: (_e = props.internetFacing) !== null && _e !== void 0 ? _e : false,
        });
        //Create the NLB for KongCP Manager
        let nlbManager;
        if (props.kongFeaturesProps.kongManagerProps.enabled) {
            nlbManager = new kong_core.NlbStack(this, 'KongCPManagerAlb', {
                vpc: this.controlPlane.vpc,
                name: props.clusterProps.clusterName + kong_core.Nlb.KONG_CP_MANAGER_LB_SUFFIX,
                internetFacing: (_f = props.internetFacing) !== null && _f !== void 0 ? _f : false,
            });
        }
        //Create the NLB for KongCP DevPortal
        let nlbDevPortal;
        if (props.kongFeaturesProps.devPortalProps.enabled) {
            nlbDevPortal = new kong_core.NlbStack(this, 'KongCPDevPortalAlb', {
                vpc: this.controlPlane.vpc,
                name: props.clusterProps.clusterName + kong_core.Nlb.KONG_CP_DEVPORTAL_LB_SUFFIX,
                internetFacing: (_g = props.internetFacing) !== null && _g !== void 0 ? _g : false,
            });
        }
        const tld = props.hostedZoneName;
        const private_ca = new kong_core.AcmPca(this, 'KongPCA', {
            vpc: cluster.vpc,
            hostedZoneName: tld,
        });
        this.privateCaArn = private_ca.privateCaArn;
        this.clusterDns = 'cluster.' + tld + ':' + ((_h = props.kongFeaturesProps.clusterProps.port) !== null && _h !== void 0 ? _h : 8005);
        this.telemetryDns = 'telemetry.' + tld + ':' + ((_j = props.kongFeaturesProps.clusterTelemetryProps.port) !== null && _j !== void 0 ? _j : 8006);
        const kongCPCertificates = new kong_core.Certificates(this, 'KongCPCertificate', {
            topLevelDomain: tld,
            privateCaArn: private_ca.privateCaArn,
            dnsNames: [
                tld,
                'admin.' + tld,
                'cluster.' + tld,
                'telemetry.' + tld,
                'manager.' + tld,
            ],
        });
        kongCPCertificates.node.addDependency(private_ca);
        new index_1.KongControlPlaneECS(this, 'KongCP', {
            cluster: cluster,
            rds: rds.kongPostgresSql,
            adminNlb: nlbAdmin.kongNlb,
            managerNlb: nlbManager ? nlbManager.kongNlb : undefined,
            devPortalNlb: nlbDevPortal ? nlbDevPortal.kongNlb : undefined,
            image: (_k = props.image) !== null && _k !== void 0 ? _k : 'docker.io/kong/kong-gateway:2.8.1.0-alpine',
            licenseSecret: (_l = props.licenseSecret) !== null && _l !== void 0 ? _l : undefined,
            kongFeaturesProps: {
                adminProps: {
                    httpPort: (_m = props.kongFeaturesProps.adminProps.httpPort) !== null && _m !== void 0 ? _m : 8001,
                    httpsPort: (_o = props.kongFeaturesProps.adminProps.httpsPort) !== null && _o !== void 0 ? _o : 8444,
                    enableHttp: (_p = props.kongFeaturesProps.adminProps.enableHttp) !== null && _p !== void 0 ? _p : true,
                },
                kongManagerProps: {
                    enabled: (_q = props.kongFeaturesProps.kongManagerProps.enabled) !== null && _q !== void 0 ? _q : true,
                    enableHttp: (_r = props.kongFeaturesProps.kongManagerProps.enableHttp) !== null && _r !== void 0 ? _r : true,
                    httpPort: (_s = props.kongFeaturesProps.kongManagerProps.httpPort) !== null && _s !== void 0 ? _s : 8002,
                    httpsPort: (_t = props.kongFeaturesProps.kongManagerProps.httpsPort) !== null && _t !== void 0 ? _t : 8445,
                },
                devPortalProps: {
                    enabled: (_u = props.kongFeaturesProps.devPortalProps.enabled) !== null && _u !== void 0 ? _u : true,
                },
                clusterProps: {
                    enabled: (_v = props.kongFeaturesProps.clusterProps.enabled) !== null && _v !== void 0 ? _v : true,
                    port: (_w = props.kongFeaturesProps.clusterProps.port) !== null && _w !== void 0 ? _w : 8005,
                },
                clusterTelemetryProps: {
                    enabled: (_x = props.kongFeaturesProps.clusterTelemetryProps.enabled) !== null && _x !== void 0 ? _x : true,
                    port: (_y = props.kongFeaturesProps.clusterTelemetryProps.port) !== null && _y !== void 0 ? _y : 8006,
                },
                kongBootstrapMigration: (_z = props.kongFeaturesProps.kongBootstrapMigration) !== null && _z !== void 0 ? _z : true,
            },
            kongTaskProps: props.kongTaskProps,
            certificates: kongCPCertificates,
            route53_zone: private_ca.route53Zone,
            desiredCount: props.desiredCount,
        });
        new aws_cdk_lib_1.CfnOutput(this, 'KongAdminLBDNSName', {
            value: nlbAdmin.kongNlb.loadBalancerDnsName,
            exportName: 'KongAdminLBDNSName',
        });
        if (nlbManager) {
            new aws_cdk_lib_1.CfnOutput(this, 'KongManagerLBBDNSName', {
                value: nlbManager.kongNlb.loadBalancerDnsName,
                exportName: 'KongManagerLBBDNSName',
            });
        }
        if (nlbDevPortal) {
            new aws_cdk_lib_1.CfnOutput(this, 'KongDevPortalLBBDNSName', {
                value: nlbDevPortal.kongNlb.loadBalancerDnsName,
                exportName: 'KongDevPortalLBBDNSName',
            });
        }
    }
}
exports.KongEcs = KongEcs;
_a = JSII_RTTI_SYMBOL_1;
KongEcs[_a] = { fqn: "kong-control-plane.KongEcs", version: "2.0.9" };
//# sourceMappingURL=data:application/json;base64,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