"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codecommit = require("@aws-cdk/aws-codecommit");
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const cloud9 = require("../lib");
class Cloud9Env extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const vpc = new ec2.Vpc(this, 'VPC', {
            maxAzs: 2,
            natGateways: 1,
        });
        // create a codecommit repository to clone into the cloud9 environment
        const repo = new codecommit.Repository(this, 'Repo', {
            repositoryName: 'foo',
        });
        // create a cloud9 ec2 environment in a new VPC
        const c9env = new cloud9.Ec2Environment(this, 'C9Env', {
            vpc,
            // clone repositories into the environment
            clonedRepositories: [
                cloud9.CloneRepository.fromCodeCommit(repo, '/foo'),
            ],
        });
        new cdk.CfnOutput(this, 'URL', { value: c9env.ideUrl });
        new cdk.CfnOutput(this, 'ARN', { value: c9env.ec2EnvironmentArn });
    }
}
exports.Cloud9Env = Cloud9Env;
const app = new cdk.App();
new Cloud9Env(app, 'C9Stack');
//# sourceMappingURL=data:application/json;base64,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