# Vaiz Python SDK

> Official Python SDK for the [Vaiz](https://vaiz.com) App

[![PyPI version](https://badge.fury.io/py/vaiz-sdk.svg)](https://badge.fury.io/py/vaiz-sdk)
[![Python](https://img.shields.io/pypi/pyversions/vaiz-sdk.svg)](https://pypi.org/project/vaiz-sdk/)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

## About

**Vaiz** is a modern project management app that helps teams collaborate and get work done. 
This SDK provides a complete Python interface to the Vaiz API, making it easy to integrate Vaiz into your Python applications and workflows.

## Installation

```bash
pip install vaiz-sdk
```

## Documentation

**[Documentation](https://docs-python-sdk.vaiz.com)**

- [Getting Started](https://docs-python-sdk.vaiz.com/) - Installation and quick start guide
- [API Reference](https://docs-python-sdk.vaiz.com/guides/overview) - Complete API documentation
- [Examples](https://docs-python-sdk.vaiz.com/examples) - Practical code examples

## Links

- [PyPI Package](https://pypi.org/project/vaiz-sdk/)
- [GitHub Repository](https://github.com/vaizcom/vaiz-python-sdk)
- [Changelog](https://github.com/vaizcom/vaiz-python-sdk/blob/main/CHANGELOG.md)
- [Contributing](https://github.com/vaizcom/vaiz-python-sdk/blob/main/CONTRIBUTING.md)
- [Known Issues and Tasks](https://github.com/vaizcom/vaiz-python-sdk/blob/main/KNOWN_ISSUES.md)

## License

MIT License - see [LICENSE](https://github.com/vaizcom/vaiz-python-sdk/blob/main/LICENSE) file for details.

---

Made with ❤️ by the Vaiz team
