"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Backend = exports.AccessLog = exports.Protocol = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const utils_1 = require("./private/utils");
/**
 * Enum of supported AppMesh protocols
 *
 * @deprecated not for use outside package
 */
var Protocol;
(function (Protocol) {
    Protocol["HTTP"] = "http";
    Protocol["TCP"] = "tcp";
    Protocol["HTTP2"] = "http2";
    Protocol["GRPC"] = "grpc";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
/**
 * Configuration for Envoy Access logs for mesh endpoints
 */
class AccessLog {
    /**
     * Path to a file to write access logs to
     *
     * @default - no file based access logging
     */
    static fromFilePath(filePath) {
        return new FileAccessLog(filePath);
    }
}
exports.AccessLog = AccessLog;
_a = JSII_RTTI_SYMBOL_1;
AccessLog[_a] = { fqn: "@aws-cdk/aws-appmesh.AccessLog", version: "1.147.0" };
/**
 * Configuration for Envoy Access logs for mesh endpoints
 */
class FileAccessLog extends AccessLog {
    constructor(filePath) {
        super();
        this.filePath = filePath;
    }
    bind(_scope) {
        return {
            virtualNodeAccessLog: {
                file: {
                    path: this.filePath,
                },
            },
            virtualGatewayAccessLog: {
                file: {
                    path: this.filePath,
                },
            },
        };
    }
}
/**
 * Contains static factory methods to create backends
 */
class Backend {
    /**
     * Construct a Virtual Service backend
     */
    static virtualService(virtualService, props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_IVirtualService(virtualService);
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_VirtualServiceBackendOptions(props);
        return new VirtualServiceBackend(virtualService, props.tlsClientPolicy);
    }
}
exports.Backend = Backend;
_b = JSII_RTTI_SYMBOL_1;
Backend[_b] = { fqn: "@aws-cdk/aws-appmesh.Backend", version: "1.147.0" };
/**
 * Represents the properties needed to define a Virtual Service backend
 */
class VirtualServiceBackend extends Backend {
    constructor(virtualService, tlsClientPolicy) {
        super();
        this.virtualService = virtualService;
        this.tlsClientPolicy = tlsClientPolicy;
    }
    /**
     * Return config for a Virtual Service backend
     */
    bind(scope) {
        return {
            virtualServiceBackend: {
                virtualService: {
                    /**
                     * We want to use the name of the Virtual Service here directly instead of
                     * a `{ 'Fn::GetAtt' }` CFN expression. This avoids a circular dependency in
                     * the case where this Virtual Node is the Virtual Service's provider.
                     */
                    virtualServiceName: cdk.Token.isUnresolved(this.virtualService.virtualServiceName)
                        ? this.virtualService.physicalName
                        : this.virtualService.virtualServiceName,
                    clientPolicy: this.tlsClientPolicy
                        ? {
                            tls: utils_1.renderTlsClientPolicy(scope, this.tlsClientPolicy),
                        }
                        : undefined,
                },
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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