"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HealthCheck = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * Contains static factory methods for creating health checks for different protocols
 */
class HealthCheck {
    /**
     * Construct a HTTP health check
     */
    static http(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_HttpHealthCheckOptions(options);
        return new HealthCheckImpl(shared_interfaces_1.Protocol.HTTP, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout, options.path);
    }
    /**
     * Construct a HTTP2 health check
     */
    static http2(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_HttpHealthCheckOptions(options);
        return new HealthCheckImpl(shared_interfaces_1.Protocol.HTTP2, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout, options.path);
    }
    /**
     * Construct a GRPC health check
     */
    static grpc(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_GrpcHealthCheckOptions(options);
        return new HealthCheckImpl(shared_interfaces_1.Protocol.GRPC, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout);
    }
    /**
     * Construct a TCP health check
     */
    static tcp(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_TcpHealthCheckOptions(options);
        return new HealthCheckImpl(shared_interfaces_1.Protocol.TCP, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout);
    }
}
exports.HealthCheck = HealthCheck;
_a = JSII_RTTI_SYMBOL_1;
HealthCheck[_a] = { fqn: "@aws-cdk/aws-appmesh.HealthCheck", version: "1.147.0" };
class HealthCheckImpl extends HealthCheck {
    constructor(protocol, healthyThreshold = 2, unhealthyThreshold = 2, interval = cdk.Duration.seconds(5), timeout = cdk.Duration.seconds(2), path) {
        super();
        this.protocol = protocol;
        this.healthyThreshold = healthyThreshold;
        this.unhealthyThreshold = unhealthyThreshold;
        this.interval = interval;
        this.timeout = timeout;
        this.path = path;
        if (healthyThreshold < 2 || healthyThreshold > 10) {
            throw new Error('healthyThreshold must be between 2 and 10');
        }
        if (unhealthyThreshold < 2 || unhealthyThreshold > 10) {
            throw new Error('unhealthyThreshold must be between 2 and 10');
        }
        if (interval.toMilliseconds() < 5000 || interval.toMilliseconds() > 300000) {
            throw new Error('interval must be between 5 seconds and 300 seconds');
        }
        if (timeout.toMilliseconds() < 2000 || timeout.toMilliseconds() > 60000) {
            throw new Error('timeout must be between 2 seconds and 60 seconds');
        }
        // Default to / for HTTP Health Checks
        if (path === undefined && (protocol === shared_interfaces_1.Protocol.HTTP || protocol === shared_interfaces_1.Protocol.HTTP2)) {
            this.path = '/';
        }
    }
    bind(_scope, options) {
        return {
            virtualNodeHealthCheck: {
                protocol: this.protocol,
                healthyThreshold: this.healthyThreshold,
                unhealthyThreshold: this.unhealthyThreshold,
                intervalMillis: this.interval.toMilliseconds(),
                timeoutMillis: this.timeout.toMilliseconds(),
                path: this.path,
                port: options.defaultPort,
            },
            virtualGatewayHealthCheck: {
                protocol: this.protocol,
                healthyThreshold: this.healthyThreshold,
                unhealthyThreshold: this.unhealthyThreshold,
                intervalMillis: this.interval.toMilliseconds(),
                timeoutMillis: this.timeout.toMilliseconds(),
                path: this.path,
                port: options.defaultPort,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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