# Generated by Django 2.0.9 on 2020-09-19 08:06

import ckeditor.fields
from django.db import migrations, models
import django.db.models.deletion
import exchange.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Supplier',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Supplier name')),
                ('short_name', models.CharField(max_length=255, verbose_name='Short name')),
                ('code', models.CharField(max_length=255, unique=True, verbose_name='Code')),
                ('country', models.CharField(blank=True, max_length=255, verbose_name='Country')),
                ('currency', exchange.models.CurrencyField(choices=[(980, 'UAH'), (840, 'USD'), (978, 'EUR')], verbose_name='Currency')),
                ('delivery_info', ckeditor.fields.RichTextField(blank=True, verbose_name='Delivery info')),
                ('email', models.EmailField(blank=True, max_length=255, verbose_name='Email')),
                ('discount', models.IntegerField(blank=True, null=True, verbose_name='Discount, %')),
                ('markup', models.IntegerField(blank=True, null=True, verbose_name='Mark-up, %')),
                ('price_updated', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='Price updated date')),
                ('is_visible_for_unregistered_users', models.BooleanField(default=True, verbose_name='Is visible for unregistered users')),
            ],
            options={
                'verbose_name': 'Supplier',
                'verbose_name_plural': 'Suppliers',
            },
        ),
        migrations.CreateModel(
            name='SupplierWarehouse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False, verbose_name='order')),
                ('name', models.CharField(max_length=255, verbose_name='Warehouse name')),
                ('short_name', models.CharField(max_length=255, verbose_name='Short name')),
                ('price_updated', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='Price updated date')),
                ('supplier', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='warehouses', to='suppliers.Supplier', verbose_name='Supplier')),
            ],
            options={
                'verbose_name': 'Supplier warehouse',
                'verbose_name_plural': 'Supplier warehouses',
                'ordering': ('order',),
                'abstract': False,
            },
        ),
    ]
